/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.logging;

import javax.servlet.ServletContext;
import org.apache.turbine.services.logging.BaseLogger;
import org.apache.turbine.services.logging.LoggingConfig;
import org.apache.turbine.util.RunData;

public class ServletLogger
extends BaseLogger {
    protected ServletContext context = null;
    protected String lf = System.getProperty("line.separator", "\n");

    public void init(LoggingConfig loggingConfig) {
        this.context = (ServletContext)loggingConfig.getServletContext();
    }

    public void shutdown() {
    }

    public boolean checkLogger() {
        return true;
    }

    public void debug(String message) {
        this.log(1, message, null, null);
    }

    public void debug(String message, Throwable t) {
        this.log(1, message, null, t);
    }

    public void debug(String message, RunData data) {
        this.log(1, message, data, null);
    }

    public void debug(String message, RunData data, Throwable t) {
        this.log(1, message, data, t);
    }

    public void info(String message) {
        this.log(2, message, null, null);
    }

    public void info(String message, Throwable t) {
        this.log(2, message, null, t);
    }

    public void info(String message, RunData data) {
        this.log(2, message, data, null);
    }

    public void info(String message, RunData data, Throwable t) {
        this.log(2, message, data, t);
    }

    public void warn(String message) {
        this.log(3, message, null, null);
    }

    public void warn(String message, Throwable t) {
        this.log(3, message, null, t);
    }

    public void warn(String message, RunData data) {
        this.log(3, message, data, null);
    }

    public void warn(String message, RunData data, Throwable t) {
        this.log(3, message, data, t);
    }

    public void error(String message) {
        this.log(4, message, null, null);
    }

    public void error(String message, Throwable e) {
        this.log(4, message, null, e);
    }

    public void error(Throwable e) {
        this.log(4, null, null, e);
    }

    public void error(String message, RunData data) {
        this.log(4, message, data, null);
    }

    public void error(String message, RunData data, Throwable e) {
        this.log(4, message, data, e);
    }

    protected void log(int level, String message, RunData data, Throwable e) {
        String levelS;
        switch (level) {
            case 1: {
                levelS = "DEBUG";
                break;
            }
            case 2: {
                levelS = "INFO";
                break;
            }
            case 3: {
                levelS = "WARN";
                break;
            }
            case 4: {
                levelS = "ERROR";
                break;
            }
            default: {
                levelS = "DEBUG";
            }
        }
        this.logAll(levelS, message, data, e);
    }

    protected void logAll(String level, String description, RunData data, Throwable t) {
        boolean odp = true;
        StringBuffer logEntry = new StringBuffer();
        logEntry.append(" -- ");
        logEntry.append(level);
        logEntry.append(" -- ");
        logEntry.append(description);
        if (t != null) {
            this.context.log(logEntry.toString(), t);
        } else {
            this.context.log(logEntry.toString());
        }
    }
}

