% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansi.R
\name{make_ansi_style}
\alias{make_ansi_style}
\title{Create a new ANSI style}
\usage{
make_ansi_style(..., bg = FALSE, grey = FALSE, colors = num_ansi_colors())
}
\arguments{
\item{...}{The style to create. See details and examples below.}

\item{bg}{Whether the color applies to the background.}

\item{grey}{Whether to specifically create a grey color.
This flag is included, because ANSI 256 has a finer color scale
for greys, then the usual 0:5 scale for red, green and blue components.
It is only used for RGB color specifications (either numerically
or via a hexadecimal string), and it is ignored on eight color ANSI
terminals.}

\item{colors}{Number of colors, detected automatically
by default.}
}
\value{
A function that can be used to color (style) strings.
}
\description{
Create a function that can be used to add ANSI styles to text.
}
\details{
The \code{...} style argument can be any of the following:
\itemize{
\item A cli ANSI style function of class \code{cli_ansi_style}. This is returned
as is, without looking at the other arguments.
\item An R color name, see \code{\link[grDevices:colors]{grDevices::colors()}}.
\item A 6- or 8-digit hexadecimal color string, e.g. \verb{#ff0000} means
red. Transparency (alpha channel) values are ignored.
\item A one-column matrix with three rows for the red, green
and blue channels, as returned by \code{\link[grDevices:col2rgb]{grDevices::col2rgb()}}.
}

\code{make_ansi_style()} detects the number of colors to use
automatically (this can be overridden using the \code{colors}
argument). If the number of colors is less than 256 (detected or given),
then it falls back to the color in the ANSI eight color mode that
is closest to the specified (RGB or R) color.
}
\examples{
make_ansi_style("orange")
make_ansi_style("#123456")
make_ansi_style("orange", bg = TRUE)

orange <- make_ansi_style("orange")
orange("foobar")
cat(orange("foobar"))
}
\seealso{
Other ANSI styling: 
\code{\link{ansi-styles}},
\code{\link{combine_ansi_styles}()},
\code{\link{num_ansi_colors}()}
}
\concept{ANSI styling}
