% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canva.R
\docType{data}
\name{canva_palettes}
\alias{canva_palettes}
\title{150 Color Palettes from Canva}
\format{
A named \code{list} of character vector.
The names are the palette names. The values of the character vectors
are hex colors, e.g. \code{"#f98866"}.
}
\usage{
canva_palettes
}
\description{
150 four-color palettes by the
\href{https://www.canva.com/learn/}{canva.com} design school.
These palettes were derived from photos and "impactful websites".
}
\examples{
require("ggplot2")
require("tibble")
if (require("purrr") && require("scales") && require("dplyr")) {
  canva_df <- map2_df(
    canva_palettes,
    names(canva_palettes),
    ~ tibble(
      colors = .x,
      .id = seq_along(colors),
      palette = .y
    )
  )
  ggplot(
    canva_df,
    aes(
      y = palette,
      x = .id,
      fill = colors
    )
  ) +
    geom_raster() +
    scale_fill_identity(guide = FALSE) +
    theme_minimal() +
    theme(
      panel.grid = element_blank(),
      axis.text.x = element_blank()
    ) +
    labs(x = "", y = "")

  show_col(canva_pal("Fresh and bright")(4))
  show_col(canva_pal("Cool blues")(4))
  show_col(canva_pal("Modern and crisp")(4))
}
}
\references{
\itemize{
\item{Janie Kliever, \href{https://www.canva.com/learn/100-color-combinations/}{100 Brilliant Color Combinations and How to Apply Them to Your Designs},
  \emph{Canva.com}, June 20, 2015.}
\item{Mary Stribley, \href{https://www.canva.com/learn/website-color-schemes/}{Website Color Schemes: The Palettes of 50 Visually Impactful Websites to Inspire You},
  \emph{Canva.com}, January 26, 2016.}
\item{Schwabish, Jonathan.
   \href{https://policyviz.com/2017/01/12/150-color-palettes-for-excel/}{150+ Color Palettes for Excel},
    \emph{PolicyViz}, January 12, 2017.}
}
}
\keyword{datasets}
