% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{solution_terms}
\alias{solution_terms}
\alias{solution_terms.vsel}
\alias{solution_terms.projection}
\title{Retrieve the full-data solution path from a \code{\link[=varsel]{varsel()}} or \code{\link[=cv_varsel]{cv_varsel()}} run
or the predictor combination from a \code{\link[=project]{project()}} run}
\usage{
solution_terms(object, ...)

\method{solution_terms}{vsel}(object, ...)

\method{solution_terms}{projection}(object, ...)
}
\arguments{
\item{object}{The object from which to retrieve the predictor terms. Possible
classes may be inferred from the names of the corresponding methods (see
also the description).}

\item{...}{Currently ignored.}
}
\value{
A character vector of predictor terms.
}
\description{
The \code{\link[=solution_terms.vsel]{solution_terms.vsel()}} method retrieves the solution path from a
full-data search (\code{vsel} objects are returned by \code{\link[=varsel]{varsel()}} or
\code{\link[=cv_varsel]{cv_varsel()}}). The \code{\link[=solution_terms.projection]{solution_terms.projection()}} method retrieves the
predictor combination onto which a projection was performed (\code{projection}
objects are returned by \code{\link[=project]{project()}}, possibly as elements of a \code{list}). Both
methods (and hence also the \code{\link[=solution_terms]{solution_terms()}} generic) are deprecated and
will be removed in a future release. Please use \code{\link[=ranking]{ranking()}} instead of
\code{\link[=solution_terms.vsel]{solution_terms.vsel()}} (\code{\link[=ranking]{ranking()}}'s output element \code{fulldata} contains the
full-data predictor ranking that is extracted by \code{\link[=solution_terms.vsel]{solution_terms.vsel()}};
\code{\link[=ranking]{ranking()}}'s output element \code{foldwise} contains the fold-wise predictor
rankings---if available---which were previously not accessible via a built-in
function) and \code{\link[=predictor_terms]{predictor_terms()}} instead of \code{\link[=solution_terms.projection]{solution_terms.projection()}}.
}
