/* SPDX-License-Identifier: GPL-2.0-only */

#include <device/azalia_device.h>
#include <device/azalia_codec/realtek.h>

const u32 cim_verb_data[] = {
	/* coreboot specific header */
	0x10ec0269,	/* Codec Vendor / Device ID: Realtek ALC269 */
	0x1025174e,	/* Subsystem ID */
	18,		/* Number of verb entries */

	/* Reset Codec First */
	AZALIA_RESET(0x1),

	/* HDA Codec Subsystem ID */
	AZALIA_SUBVENDOR(0, 0x1025174e),

	/* Pin Widget Verb-table */
	AZALIA_PIN_CFG(0, ALC269_DMIC12,	AZALIA_PIN_DESC(
							AZALIA_INTEGRATED,
							AZALIA_MOBILE_LID_INSIDE,
							AZALIA_MIC_IN,
							AZALIA_OTHER_DIGITAL,
							AZALIA_COLOR_UNKNOWN,
							AZALIA_NO_JACK_PRESENCE_DETECT,
							3,
							0
						)),
	AZALIA_PIN_CFG(0, ALC269_SPEAKERS,	AZALIA_PIN_DESC(
							AZALIA_INTEGRATED,
							AZALIA_INTERNAL | AZALIA_TOP,
							AZALIA_SPEAKER,
							AZALIA_OTHER_ANALOG,
							AZALIA_COLOR_UNKNOWN,
							AZALIA_NO_JACK_PRESENCE_DETECT,
							1,
							0
						)),
	AZALIA_PIN_CFG(0, ALC269_VC_HP_OUT,	AZALIA_PIN_DESC(
							AZALIA_JACK,
							AZALIA_EXTERNAL_PRIMARY_CHASSIS | AZALIA_RIGHT,
							AZALIA_HP_OUT,
							AZALIA_STEREO_MONO_1_8,
							AZALIA_BLACK,
							AZALIA_JACK_PRESENCE_DETECT,
							2,
							0
						)),
	AZALIA_PIN_CFG(0, ALC269_MIC1,		AZALIA_PIN_DESC(
							AZALIA_JACK,
							AZALIA_EXTERNAL_PRIMARY_CHASSIS | AZALIA_RIGHT,
							AZALIA_MIC_IN,
							AZALIA_STEREO_MONO_1_8,
							AZALIA_BLACK,
							AZALIA_JACK_PRESENCE_DETECT,
							4,
							0
						)),
	AZALIA_PIN_CFG(0, ALC269_MONO,		AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, ALC269_MIC2,		AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, ALC269_LINE1,		AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, ALC269_LINE2,		AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, ALC269_PC_BEEP,	AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, ALC269_SPDIF_OUT,	AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, ALC269_VB_HP_OUT,	AZALIA_PIN_CFG_NC(0)),

	0x02050018,
	0x02040184,
	0x0205001C,
	0x02044b00,

	0x02050024,
	0x02040000,
	0x02050004,
	0x02040080,

	0x02050008,
	0x02040000,
	0x0205000C,
	0x02043F00,

	0x02050015,
	0x02048002,
	0x02050015,
	0x02048002,

	0x00C37080,
	0x00270610,
	0x00D37080,
	0x00370610,
};

const u32 pc_beep_verbs[] = {
};

AZALIA_ARRAY_SIZES;
