//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armhdinsight_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hdinsight/armhdinsight"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2023-04-15-preview/examples/GetAllApplications.json
func ExampleApplicationsClient_NewListByClusterPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhdinsight.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewApplicationsClient().NewListByClusterPager("rg1", "cluster1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ApplicationListResult = armhdinsight.ApplicationListResult{
		// 	Value: []*armhdinsight.Application{
		// 		{
		// 			Name: to.Ptr("app"),
		// 			Type: to.Ptr("Microsoft.HDInsight/clusters/applications"),
		// 			ID: to.Ptr("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.HDInsight/clusters/cluster1/applications/app"),
		// 			Etag: to.Ptr("CF938302-6B4D-44A0-A6D2-C0D67E847AEC"),
		// 			Properties: &armhdinsight.ApplicationProperties{
		// 				ApplicationState: to.Ptr("Running"),
		// 				ApplicationType: to.Ptr("CustomApplication"),
		// 				ComputeProfile: &armhdinsight.ComputeProfile{
		// 					Roles: []*armhdinsight.Role{
		// 						{
		// 							Name: to.Ptr("edgenode"),
		// 							HardwareProfile: &armhdinsight.HardwareProfile{
		// 								VMSize: to.Ptr("Standard_D12_v2"),
		// 							},
		// 							TargetInstanceCount: to.Ptr[int32](1),
		// 					}},
		// 				},
		// 				CreatedDate: to.Ptr("2017-03-22T21:34:39.293"),
		// 				HTTPSEndpoints: []*armhdinsight.ApplicationGetHTTPSEndpoint{
		// 					{
		// 						AccessModes: []*string{
		// 							to.Ptr("WebPage")},
		// 							DestinationPort: to.Ptr[int32](20000),
		// 							Location: to.Ptr("https://cluster1-app.apps.azurehdinsight.net:443"),
		// 							PublicPort: to.Ptr[int32](443),
		// 					}},
		// 					InstallScriptActions: []*armhdinsight.RuntimeScriptAction{
		// 						{
		// 							Name: to.Ptr("app-install-app"),
		// 							Roles: []*string{
		// 								to.Ptr("edgenode")},
		// 								URI: to.Ptr("http://testurl.com/public/hdi-app/20170301/hdinsight-app-install.sh"),
		// 						}},
		// 						MarketplaceIdentifier: to.Ptr("app-on-hdiapp-on-hdi.1.0.3"),
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 						SSHEndpoints: []*armhdinsight.ApplicationGetEndpoint{
		// 							{
		// 								DestinationPort: to.Ptr[int32](22),
		// 								Location: to.Ptr("app.cluster1-ssh.azurehdinsight.net:22"),
		// 								PublicPort: to.Ptr[int32](22),
		// 						}},
		// 						UninstallScriptActions: []*armhdinsight.RuntimeScriptAction{
		// 						},
		// 					},
		// 					Tags: map[string]*string{
		// 						"key1": to.Ptr("val1"),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("app2"),
		// 					Type: to.Ptr("Microsoft.HDInsight/clusters/applications"),
		// 					ID: to.Ptr("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.HDInsight/clusters/cluster1/applications/app2"),
		// 					Etag: to.Ptr("2C128F8E-BB26-4637-99E4-18EBC39FD51F"),
		// 					Properties: &armhdinsight.ApplicationProperties{
		// 						ApplicationState: to.Ptr("AzureVMConfiguration"),
		// 						ApplicationType: to.Ptr("CustomApplication"),
		// 						ComputeProfile: &armhdinsight.ComputeProfile{
		// 							Roles: []*armhdinsight.Role{
		// 								{
		// 									Name: to.Ptr("edgenode"),
		// 									HardwareProfile: &armhdinsight.HardwareProfile{
		// 										VMSize: to.Ptr("Standard_D3"),
		// 									},
		// 									TargetInstanceCount: to.Ptr[int32](1),
		// 							}},
		// 						},
		// 						CreatedDate: to.Ptr("2017-03-28T02:01:25.107"),
		// 						HTTPSEndpoints: []*armhdinsight.ApplicationGetHTTPSEndpoint{
		// 							{
		// 								AccessModes: []*string{
		// 									to.Ptr("WebPage")},
		// 									DestinationPort: to.Ptr[int32](18630),
		// 									Location: to.Ptr("location"),
		// 									PublicPort: to.Ptr[int32](443),
		// 							}},
		// 							InstallScriptActions: []*armhdinsight.RuntimeScriptAction{
		// 								{
		// 									Name: to.Ptr("app2-Install"),
		// 									Roles: []*string{
		// 										to.Ptr("edgenode")},
		// 										URI: to.Ptr("https://app2url.com/azure/2.4.0.0/app2_install.sh"),
		// 								}},
		// 								MarketplaceIdentifier: to.Ptr("app2-hdinsightsmall.1.0.8"),
		// 								ProvisioningState: to.Ptr("Succeeded"),
		// 								SSHEndpoints: []*armhdinsight.ApplicationGetEndpoint{
		// 								},
		// 								UninstallScriptActions: []*armhdinsight.RuntimeScriptAction{
		// 								},
		// 							},
		// 							Tags: map[string]*string{
		// 								"key1": to.Ptr("val1"),
		// 							},
		// 					}},
		// 				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2023-04-15-preview/examples/GetApplicationInProgress.json
func ExampleApplicationsClient_Get_getApplicationOnHdInsightClusterCreationInProgress() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhdinsight.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationsClient().Get(ctx, "rg1", "cluster1", "app", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Application = armhdinsight.Application{
	// 	Name: to.Ptr("app"),
	// 	Type: to.Ptr("Microsoft.HDInsight/clusters/applications"),
	// 	ID: to.Ptr("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.HDInsight/clusters/cluster1/applications/app"),
	// 	Etag: to.Ptr("2C128F8E-BB26-4637-99E4-18EBC39FD51F"),
	// 	Properties: &armhdinsight.ApplicationProperties{
	// 		ApplicationState: to.Ptr("AzureVMConfiguration"),
	// 		ApplicationType: to.Ptr("CustomApplication"),
	// 		ComputeProfile: &armhdinsight.ComputeProfile{
	// 			Roles: []*armhdinsight.Role{
	// 				{
	// 					Name: to.Ptr("edgenode"),
	// 					HardwareProfile: &armhdinsight.HardwareProfile{
	// 						VMSize: to.Ptr("Standard_D3"),
	// 					},
	// 					TargetInstanceCount: to.Ptr[int32](1),
	// 			}},
	// 		},
	// 		CreatedDate: to.Ptr("2017-03-28T02:01:25.107"),
	// 		HTTPSEndpoints: []*armhdinsight.ApplicationGetHTTPSEndpoint{
	// 			{
	// 				AccessModes: []*string{
	// 					to.Ptr("WebPage")},
	// 					DestinationPort: to.Ptr[int32](18630),
	// 					Location: to.Ptr("location"),
	// 					PublicPort: to.Ptr[int32](443),
	// 			}},
	// 			InstallScriptActions: []*armhdinsight.RuntimeScriptAction{
	// 				{
	// 					Name: to.Ptr("app-Install"),
	// 					Roles: []*string{
	// 						to.Ptr("edgenode")},
	// 						URI: to.Ptr("https://app.com/azure/app_install.sh"),
	// 				}},
	// 				MarketplaceIdentifier: to.Ptr("id"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				SSHEndpoints: []*armhdinsight.ApplicationGetEndpoint{
	// 				},
	// 				UninstallScriptActions: []*armhdinsight.RuntimeScriptAction{
	// 				},
	// 			},
	// 			Tags: map[string]*string{
	// 				"key1": to.Ptr("val1"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2023-04-15-preview/examples/GetApplicationCreated.json
func ExampleApplicationsClient_Get_getApplicationOnHdInsightClusterSuccessfullyCreated() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhdinsight.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationsClient().Get(ctx, "rg1", "cluster1", "app", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Application = armhdinsight.Application{
	// 	Name: to.Ptr("app"),
	// 	Type: to.Ptr("Microsoft.HDInsight/clusters/applications"),
	// 	ID: to.Ptr("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.HDInsight/clusters/cluster1/applications/app"),
	// 	Etag: to.Ptr("CF938302-6B4D-44A0-A6D2-C0D67E847AEC"),
	// 	Properties: &armhdinsight.ApplicationProperties{
	// 		ApplicationState: to.Ptr("Running"),
	// 		ApplicationType: to.Ptr("CustomApplication"),
	// 		ComputeProfile: &armhdinsight.ComputeProfile{
	// 			Roles: []*armhdinsight.Role{
	// 				{
	// 					Name: to.Ptr("edgenode"),
	// 					HardwareProfile: &armhdinsight.HardwareProfile{
	// 						VMSize: to.Ptr("Standard_D12_v2"),
	// 					},
	// 					TargetInstanceCount: to.Ptr[int32](1),
	// 			}},
	// 		},
	// 		CreatedDate: to.Ptr("2017-03-22T21:34:39.293"),
	// 		HTTPSEndpoints: []*armhdinsight.ApplicationGetHTTPSEndpoint{
	// 			{
	// 				AccessModes: []*string{
	// 					to.Ptr("WebPage")},
	// 					DestinationPort: to.Ptr[int32](20000),
	// 					Location: to.Ptr("https://cluster1.apps.azurehdinsight.net:443"),
	// 					PublicPort: to.Ptr[int32](443),
	// 			}},
	// 			InstallScriptActions: []*armhdinsight.RuntimeScriptAction{
	// 				{
	// 					Name: to.Ptr("app-install"),
	// 					Roles: []*string{
	// 						to.Ptr("edgenode")},
	// 						URI: to.Ptr("http://app.com/public/hdi-app/20170301/app-install.sh"),
	// 				}},
	// 				MarketplaceIdentifier: to.Ptr("appMarketId"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				SSHEndpoints: []*armhdinsight.ApplicationGetEndpoint{
	// 					{
	// 						DestinationPort: to.Ptr[int32](22),
	// 						Location: to.Ptr("cluster1-ssh.azurehdinsight.net:22"),
	// 						PublicPort: to.Ptr[int32](22),
	// 				}},
	// 				UninstallScriptActions: []*armhdinsight.RuntimeScriptAction{
	// 				},
	// 			},
	// 			Tags: map[string]*string{
	// 				"key1": to.Ptr("val1"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2023-04-15-preview/examples/CreateApplication.json
func ExampleApplicationsClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhdinsight.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewApplicationsClient().BeginCreate(ctx, "rg1", "cluster1", "hue", armhdinsight.Application{
		Properties: &armhdinsight.ApplicationProperties{
			ApplicationType: to.Ptr("CustomApplication"),
			ComputeProfile: &armhdinsight.ComputeProfile{
				Roles: []*armhdinsight.Role{
					{
						Name: to.Ptr("edgenode"),
						HardwareProfile: &armhdinsight.HardwareProfile{
							VMSize: to.Ptr("Standard_D12_v2"),
						},
						TargetInstanceCount: to.Ptr[int32](1),
					}},
			},
			Errors: []*armhdinsight.Errors{},
			HTTPSEndpoints: []*armhdinsight.ApplicationGetHTTPSEndpoint{
				{
					AccessModes: []*string{
						to.Ptr("WebPage")},
					DestinationPort: to.Ptr[int32](20000),
					SubDomainSuffix: to.Ptr("dss"),
				}},
			InstallScriptActions: []*armhdinsight.RuntimeScriptAction{
				{
					Name:       to.Ptr("app-install-app1"),
					Parameters: to.Ptr("-version latest -port 20000"),
					Roles: []*string{
						to.Ptr("edgenode")},
					URI: to.Ptr("https://.../install.sh"),
				}},
			UninstallScriptActions: []*armhdinsight.RuntimeScriptAction{},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Application = armhdinsight.Application{
	// 	Name: to.Ptr("hue"),
	// 	Type: to.Ptr("Microsoft.HDInsight/clusters/applications"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.HDInsight/clusters/cluster1/applications/hue"),
	// 	Etag: to.Ptr("etag"),
	// 	Properties: &armhdinsight.ApplicationProperties{
	// 		ApplicationState: to.Ptr("ApplicationConfiguration"),
	// 		ApplicationType: to.Ptr("CustomApplication"),
	// 		ComputeProfile: &armhdinsight.ComputeProfile{
	// 			Roles: []*armhdinsight.Role{
	// 				{
	// 					Name: to.Ptr("edgenode"),
	// 					HardwareProfile: &armhdinsight.HardwareProfile{
	// 						VMSize: to.Ptr("Standard_D12_v2"),
	// 					},
	// 					TargetInstanceCount: to.Ptr[int32](1),
	// 			}},
	// 		},
	// 		CreatedDate: to.Ptr("2017-02-28"),
	// 		Errors: []*armhdinsight.Errors{
	// 		},
	// 		HTTPSEndpoints: []*armhdinsight.ApplicationGetHTTPSEndpoint{
	// 			{
	// 				AccessModes: []*string{
	// 					to.Ptr("WebPage")},
	// 					DestinationPort: to.Ptr[int32](20000),
	// 			}},
	// 			InstallScriptActions: []*armhdinsight.RuntimeScriptAction{
	// 				{
	// 					Name: to.Ptr("app-install-app1"),
	// 					Roles: []*string{
	// 						to.Ptr("edgenode")},
	// 						URI: to.Ptr("https://.../install.sh"),
	// 				}},
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				SSHEndpoints: []*armhdinsight.ApplicationGetEndpoint{
	// 				},
	// 				UninstallScriptActions: []*armhdinsight.RuntimeScriptAction{
	// 				},
	// 			},
	// 			Tags: map[string]*string{
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2023-04-15-preview/examples/DeleteApplication.json
func ExampleApplicationsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhdinsight.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewApplicationsClient().BeginDelete(ctx, "rg1", "cluster1", "hue", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/310a0100f5b020c1900c527a6aa70d21992f078a/specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2023-04-15-preview/examples/GetApplicationCreationAsyncOperationStatus.json
func ExampleApplicationsClient_GetAzureAsyncOperationStatus() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhdinsight.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationsClient().GetAzureAsyncOperationStatus(ctx, "rg1", "cluster1", "app", "CF938302-6B4D-44A0-A6D2-C0D67E847AEC", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AsyncOperationResult = armhdinsight.AsyncOperationResult{
	// 	Status: to.Ptr(armhdinsight.AsyncOperationStateInProgress),
	// }
}
