#pragma once
/*
 *  $Id: serializable-utils.h 28793 2025-11-05 08:18:57Z yeti-dn $
 *  Copyright (C) 2009-2025 David Nečas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_SERIALIZABLE_UTILS_H__
#define __GWY_SERIALIZABLE_UTILS_H__

#include <glib-object.h>
#include <libgwyddion/error-list.h>
#include <libgwyddion/serializable.h>

G_BEGIN_DECLS

void     gwy_fill_serializable_defaults_pspec(GwySerializableItem *items,
                                              gsize n_items,
                                              gboolean names_may_differ);
void     gwy_deserialize_filter_items        (GwySerializableItem *model,
                                              gsize n_items,
                                              GwySerializableGroup *group,
                                              const gchar *type_name,
                                              GwyErrorList **error_list);
gboolean gwy_check_object_component          (const GwySerializableItem *item,
                                              const gchar *type_name,
                                              GType component_type,
                                              GwyErrorList **error_list);
gboolean gwy_check_double_component          (const GwySerializableItem *item,
                                              const gchar *type_name,
                                              gdouble min,
                                              gdouble max,
                                              GwyErrorList **error_list);
gboolean gwy_check_int32_component           (const GwySerializableItem *item,
                                              const gchar *type_name,
                                              gint32 min,
                                              gint32 max,
                                              GwyErrorList **error_list);
gboolean gwy_check_enum_component            (const GwySerializableItem *item,
                                              const gchar *type_name,
                                              GType enum_type,
                                              GwyErrorList **error_list);
gboolean gwy_check_data_length_multiple      (GwyErrorList **error_list,
                                              const gchar *type_name,
                                              gsize len,
                                              guint multiple);
gboolean gwy_check_data_dimension            (GwyErrorList **error_list,
                                              const gchar *type_name,
                                              guint n_dims,
                                              gsize expected_size,
                                              ...);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
