% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{calendar-boundary}
\alias{calendar-boundary}
\alias{calendar_start}
\alias{calendar_end}
\title{Boundaries: calendars}
\usage{
calendar_start(x, precision)

calendar_end(x, precision)
}
\arguments{
\item{x}{\verb{[calendar]}

A calendar vector.}

\item{precision}{\verb{[character(1)]}

A precision. Allowed precisions are dependent on the calendar used.}
}
\value{
\code{x} at the same precision, but with some components altered to be
at the boundary value.
}
\description{
\itemize{
\item \code{calendar_start()} computes the start of a calendar at a particular
\code{precision}, such as the "start of the quarter".
\item \code{calendar_end()} computes the end of a calendar at a particular
\code{precision}, such as the "end of the month".
}

For both \code{calendar_start()} and \code{calendar_end()}, the precision of \code{x} is
always retained.

Each calendar has its own help page describing the precisions that you
can compute a boundary at:
\itemize{
\item \link[=year-month-day-boundary]{year-month-day}
\item \link[=year-month-weekday-boundary]{year-month-weekday}
\item \link[=year-week-day-boundary]{year-week-day}
\item \link[=iso-year-week-day-boundary]{iso-year-week-day}
\item \link[=year-quarter-day-boundary]{year-quarter-day}
\item \link[=year-day-boundary]{year-day}
}
}
\examples{
# Hour precision
x <- year_month_day(2019, 2:4, 5, 6)
x

# Compute the start of the month
calendar_start(x, "month")

# Or the end of the month, notice that the hour value is adjusted as well
calendar_end(x, "month")
}
