/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.List;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.OnFallbackDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing,error")
@XmlRootElement(name="circuitBreaker")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"resilience4jConfiguration", "faultToleranceConfiguration", "outputs", "onFallback"})
public class CircuitBreakerDefinition
extends OutputDefinition<CircuitBreakerDefinition> {
    @XmlAttribute
    private String configuration;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="false")
    private Boolean inheritErrorHandler;
    @XmlElement
    private Resilience4jConfigurationDefinition resilience4jConfiguration;
    @XmlElement
    private FaultToleranceConfigurationDefinition faultToleranceConfiguration;
    @XmlElement
    private OnFallbackDefinition onFallback;

    public CircuitBreakerDefinition() {
    }

    protected CircuitBreakerDefinition(CircuitBreakerDefinition source) {
        super(source);
        this.configuration = source.configuration;
        this.inheritErrorHandler = source.inheritErrorHandler;
        this.resilience4jConfiguration = source.resilience4jConfiguration != null ? source.resilience4jConfiguration.copyDefinition() : null;
        this.faultToleranceConfiguration = source.faultToleranceConfiguration != null ? source.faultToleranceConfiguration.copyDefinition() : null;
        this.onFallback = source.onFallback != null ? source.onFallback.copyDefinition() : null;
    }

    @Override
    public CircuitBreakerDefinition copyDefinition() {
        return new CircuitBreakerDefinition(this);
    }

    @Override
    public String toString() {
        return "CircuitBreaker[" + String.valueOf(this.getOutputs()) + "]";
    }

    @Override
    public String getShortName() {
        return "circuitBreaker";
    }

    @Override
    public String getLabel() {
        return "circuitBreaker";
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        if (this.onFallback != null) {
            this.onFallback.addOutput(output);
        } else {
            super.addOutput(output);
        }
    }

    public Resilience4jConfigurationDefinition getResilience4jConfiguration() {
        return this.resilience4jConfiguration;
    }

    public void setResilience4jConfiguration(Resilience4jConfigurationDefinition resilience4jConfiguration) {
        this.resilience4jConfiguration = resilience4jConfiguration;
    }

    public FaultToleranceConfigurationDefinition getFaultToleranceConfiguration() {
        return this.faultToleranceConfiguration;
    }

    public void setFaultToleranceConfiguration(FaultToleranceConfigurationDefinition faultToleranceConfiguration) {
        this.faultToleranceConfiguration = faultToleranceConfiguration;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @Override
    public Boolean getInheritErrorHandler() {
        return this.inheritErrorHandler;
    }

    @Override
    public void setInheritErrorHandler(Boolean inheritErrorHandler) {
        this.inheritErrorHandler = inheritErrorHandler;
    }

    public OnFallbackDefinition getOnFallback() {
        return this.onFallback;
    }

    public void setOnFallback(OnFallbackDefinition onFallback) {
        this.onFallback = onFallback;
    }

    public Resilience4jConfigurationDefinition resilience4jConfiguration() {
        this.resilience4jConfiguration = this.resilience4jConfiguration == null ? new Resilience4jConfigurationDefinition(this) : this.resilience4jConfiguration;
        return this.resilience4jConfiguration;
    }

    public CircuitBreakerDefinition resilience4jConfiguration(Resilience4jConfigurationDefinition configuration) {
        this.resilience4jConfiguration = configuration;
        return this;
    }

    public FaultToleranceConfigurationDefinition faultToleranceConfiguration() {
        this.faultToleranceConfiguration = this.faultToleranceConfiguration == null ? new FaultToleranceConfigurationDefinition(this) : this.faultToleranceConfiguration;
        return this.faultToleranceConfiguration;
    }

    public CircuitBreakerDefinition faultToleranceConfiguration(FaultToleranceConfigurationDefinition configuration) {
        this.faultToleranceConfiguration = configuration;
        return this;
    }

    public CircuitBreakerDefinition configuration(String ref) {
        this.configuration = ref;
        return this;
    }

    public CircuitBreakerDefinition inheritErrorHandler(boolean inheritErrorHandler) {
        this.inheritErrorHandler = inheritErrorHandler;
        return this;
    }

    public CircuitBreakerDefinition onFallback() {
        this.onFallback = new OnFallbackDefinition();
        this.onFallback.setParent(this);
        return this;
    }

    public CircuitBreakerDefinition onFallbackViaNetwork() {
        this.onFallback = new OnFallbackDefinition();
        this.onFallback.setFallbackViaNetwork(Boolean.toString(true));
        this.onFallback.setParent(this);
        return this;
    }
}

