/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.camel.LoggingLevel;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration")
@XmlRootElement(name="redeliveryPolicy")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RedeliveryPolicyDefinition
extends IdentifiedType
implements Cloneable {
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String maximumRedeliveries;
    @XmlAttribute
    @Metadata(javaType="java.time.Duration", defaultValue="1000")
    private String redeliveryDelay;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String asyncDelayedRedelivery;
    @XmlAttribute
    @Metadata(javaType="java.lang.Double", defaultValue="2.0")
    private String backOffMultiplier;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String useExponentialBackOff;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Double", defaultValue="0.15")
    private String collisionAvoidanceFactor;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String useCollisionAvoidance;
    @XmlAttribute
    @Metadata(javaType="java.time.Duration", defaultValue="60000")
    private String maximumRedeliveryDelay;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.LoggingLevel", defaultValue="ERROR", enums="TRACE,DEBUG,INFO,WARN,ERROR,OFF")
    private String retriesExhaustedLogLevel;
    @XmlAttribute
    @Metadata(javaType="org.apache.camel.LoggingLevel", defaultValue="DEBUG", enums="TRACE,DEBUG,INFO,WARN,ERROR,OFF")
    private String retryAttemptedLogLevel;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Integer", defaultValue="1")
    private String retryAttemptedLogInterval;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String logRetryAttempted;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String logStackTrace;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String logRetryStackTrace;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String logHandled;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String logNewException;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String logContinued;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String logExhausted;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String logExhaustedMessageHistory;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String logExhaustedMessageBody;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String disableRedelivery;
    @XmlAttribute
    @Metadata(label="advanced")
    private String delayPattern;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String allowRedeliveryWhileStopping;
    @XmlAttribute
    @Metadata(label="advanced")
    private String exchangeFormatterRef;

    public String toString() {
        return "RedeliveryPolicy[maximumRedeliveries: " + this.maximumRedeliveries + "]";
    }

    public RedeliveryPolicyDefinition() {
    }

    protected RedeliveryPolicyDefinition(RedeliveryPolicyDefinition source) {
        this.maximumRedeliveries = source.maximumRedeliveries;
        this.redeliveryDelay = source.redeliveryDelay;
        this.asyncDelayedRedelivery = source.asyncDelayedRedelivery;
        this.backOffMultiplier = source.backOffMultiplier;
        this.useExponentialBackOff = source.useExponentialBackOff;
        this.collisionAvoidanceFactor = source.collisionAvoidanceFactor;
        this.useCollisionAvoidance = source.useCollisionAvoidance;
        this.maximumRedeliveryDelay = source.maximumRedeliveryDelay;
        this.retriesExhaustedLogLevel = source.retriesExhaustedLogLevel;
        this.retryAttemptedLogLevel = source.retryAttemptedLogLevel;
        this.retryAttemptedLogInterval = source.retryAttemptedLogInterval;
        this.logRetryAttempted = source.logRetryAttempted;
        this.logStackTrace = source.logStackTrace;
        this.logRetryStackTrace = source.logRetryStackTrace;
        this.logHandled = source.logHandled;
        this.logNewException = source.logNewException;
        this.logContinued = source.logContinued;
        this.logExhausted = source.logExhausted;
        this.logExhaustedMessageHistory = source.logExhaustedMessageHistory;
        this.logExhaustedMessageBody = source.logExhaustedMessageBody;
        this.disableRedelivery = source.disableRedelivery;
        this.delayPattern = source.delayPattern;
        this.allowRedeliveryWhileStopping = source.allowRedeliveryWhileStopping;
        this.exchangeFormatterRef = source.exchangeFormatterRef;
    }

    @Deprecated
    public RedeliveryPolicyDefinition copy() {
        try {
            return (RedeliveryPolicyDefinition)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone: " + String.valueOf(e), e);
        }
    }

    public RedeliveryPolicyDefinition copyDefinition() {
        return new RedeliveryPolicyDefinition(this);
    }

    public RedeliveryPolicyDefinition asyncDelayedRedelivery() {
        this.setAsyncDelayedRedelivery("true");
        return this;
    }

    public RedeliveryPolicyDefinition allowRedeliveryWhileStopping(boolean allowRedeliveryWhileStopping) {
        return this.allowRedeliveryWhileStopping(Boolean.toString(allowRedeliveryWhileStopping));
    }

    public RedeliveryPolicyDefinition allowRedeliveryWhileStopping(String allowRedeliveryWhileStopping) {
        this.setAllowRedeliveryWhileStopping(allowRedeliveryWhileStopping);
        return this;
    }

    public RedeliveryPolicyDefinition backOffMultiplier(double backOffMultiplier) {
        return this.backOffMultiplier(Double.toString(backOffMultiplier));
    }

    public RedeliveryPolicyDefinition backOffMultiplier(String backOffMultiplier) {
        this.setBackOffMultiplier(backOffMultiplier);
        return this;
    }

    public RedeliveryPolicyDefinition collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.setCollisionAvoidanceFactor(Double.toString(collisionAvoidancePercent * 0.01));
        return this;
    }

    public RedeliveryPolicyDefinition collisionAvoidanceFactor(double collisionAvoidanceFactor) {
        return this.collisionAvoidanceFactor(Double.toString(collisionAvoidanceFactor));
    }

    public RedeliveryPolicyDefinition collisionAvoidanceFactor(String collisionAvoidanceFactor) {
        this.setCollisionAvoidanceFactor(collisionAvoidanceFactor);
        return this;
    }

    public RedeliveryPolicyDefinition redeliveryDelay(long delay) {
        return this.redeliveryDelay(Long.toString(delay));
    }

    public RedeliveryPolicyDefinition redeliveryDelay(String delay) {
        this.setRedeliveryDelay(delay);
        return this;
    }

    public RedeliveryPolicyDefinition retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        return this.retriesExhaustedLogLevel(retriesExhaustedLogLevel.name());
    }

    public RedeliveryPolicyDefinition retriesExhaustedLogLevel(String retriesExhaustedLogLevel) {
        this.setRetriesExhaustedLogLevel(retriesExhaustedLogLevel);
        return this;
    }

    public RedeliveryPolicyDefinition retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        return this.retryAttemptedLogLevel(retryAttemptedLogLevel.name());
    }

    public RedeliveryPolicyDefinition retryAttemptedLogLevel(String retryAttemptedLogLevel) {
        this.setRetryAttemptedLogLevel(retryAttemptedLogLevel);
        return this;
    }

    public RedeliveryPolicyDefinition retryAttemptedLogInterval(String retryAttemptedLogInterval) {
        this.setRetryAttemptedLogInterval(retryAttemptedLogInterval);
        return this;
    }

    public RedeliveryPolicyDefinition logStackTrace(boolean logStackTrace) {
        return this.logStackTrace(Boolean.toString(logStackTrace));
    }

    public RedeliveryPolicyDefinition logStackTrace(String logStackTrace) {
        this.setLogStackTrace(logStackTrace);
        return this;
    }

    public RedeliveryPolicyDefinition logRetryStackTrace(boolean logRetryStackTrace) {
        return this.logRetryStackTrace(Boolean.toString(logRetryStackTrace));
    }

    public RedeliveryPolicyDefinition logRetryStackTrace(String logRetryStackTrace) {
        this.setLogRetryStackTrace(logRetryStackTrace);
        return this;
    }

    public RedeliveryPolicyDefinition logRetryAttempted(boolean logRetryAttempted) {
        return this.logRetryAttempted(Boolean.toString(logRetryAttempted));
    }

    public RedeliveryPolicyDefinition logRetryAttempted(String logRetryAttempted) {
        this.setLogRetryAttempted(logRetryAttempted);
        return this;
    }

    public RedeliveryPolicyDefinition logHandled(boolean logHandled) {
        return this.logHandled(Boolean.toString(logHandled));
    }

    public RedeliveryPolicyDefinition logHandled(String logHandled) {
        this.setLogHandled(logHandled);
        return this;
    }

    public RedeliveryPolicyDefinition logNewException(boolean logNewException) {
        return this.logNewException(Boolean.toString(logNewException));
    }

    public RedeliveryPolicyDefinition logNewException(String logNewException) {
        this.setLogNewException(logNewException);
        return this;
    }

    public RedeliveryPolicyDefinition logContinued(boolean logContinued) {
        return this.logContinued(Boolean.toString(logContinued));
    }

    public RedeliveryPolicyDefinition logContinued(String logContinued) {
        this.setLogContinued(logContinued);
        return this;
    }

    public RedeliveryPolicyDefinition logExhausted(boolean logExhausted) {
        return this.logExhausted(Boolean.toString(logExhausted));
    }

    public RedeliveryPolicyDefinition logExhausted(String logExhausted) {
        this.setLogExhausted(logExhausted);
        return this;
    }

    public RedeliveryPolicyDefinition logExhaustedMessageHistory(boolean logExhaustedMessageHistory) {
        this.setLogExhaustedMessageHistory(Boolean.toString(logExhaustedMessageHistory));
        return this;
    }

    public RedeliveryPolicyDefinition logExhaustedMessageHistory(String logExhaustedMessageHistory) {
        this.setLogExhaustedMessageHistory(logExhaustedMessageHistory);
        return this;
    }

    public RedeliveryPolicyDefinition logExhaustedMessageBody(boolean logExhaustedMessageBody) {
        this.setLogExhaustedMessageBody(Boolean.toString(logExhaustedMessageBody));
        return this;
    }

    public RedeliveryPolicyDefinition logExhaustedMessageBody(String logExhaustedMessageBody) {
        this.setLogExhaustedMessageBody(logExhaustedMessageBody);
        return this;
    }

    public RedeliveryPolicyDefinition maximumRedeliveries(int maximumRedeliveries) {
        return this.maximumRedeliveries(Integer.toString(maximumRedeliveries));
    }

    public RedeliveryPolicyDefinition maximumRedeliveries(String maximumRedeliveries) {
        this.setMaximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public RedeliveryPolicyDefinition useCollisionAvoidance() {
        this.setUseCollisionAvoidance("true");
        return this;
    }

    public RedeliveryPolicyDefinition useExponentialBackOff() {
        this.setUseExponentialBackOff("true");
        return this;
    }

    public RedeliveryPolicyDefinition maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        return this.maximumRedeliveryDelay(Long.toString(maximumRedeliveryDelay));
    }

    public RedeliveryPolicyDefinition maximumRedeliveryDelay(String maximumRedeliveryDelay) {
        this.setMaximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public RedeliveryPolicyDefinition delayPattern(String delayPattern) {
        this.setDelayPattern(delayPattern);
        return this;
    }

    public RedeliveryPolicyDefinition exchangeFormatterRef(String exchangeFormatterRef) {
        this.setExchangeFormatterRef(exchangeFormatterRef);
        return this;
    }

    public String getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(String maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public String getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public void setRedeliveryDelay(String redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
    }

    public String getAsyncDelayedRedelivery() {
        return this.asyncDelayedRedelivery;
    }

    public void setAsyncDelayedRedelivery(String asyncDelayedRedelivery) {
        this.asyncDelayedRedelivery = asyncDelayedRedelivery;
    }

    public String getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(String backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public String getUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(String useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    public String getCollisionAvoidanceFactor() {
        return this.collisionAvoidanceFactor;
    }

    public void setCollisionAvoidanceFactor(String collisionAvoidanceFactor) {
        this.collisionAvoidanceFactor = collisionAvoidanceFactor;
    }

    public String getUseCollisionAvoidance() {
        return this.useCollisionAvoidance;
    }

    public void setUseCollisionAvoidance(String useCollisionAvoidance) {
        this.useCollisionAvoidance = useCollisionAvoidance;
    }

    public String getMaximumRedeliveryDelay() {
        return this.maximumRedeliveryDelay;
    }

    public void setMaximumRedeliveryDelay(String maximumRedeliveryDelay) {
        this.maximumRedeliveryDelay = maximumRedeliveryDelay;
    }

    public String getRetriesExhaustedLogLevel() {
        return this.retriesExhaustedLogLevel;
    }

    public void setRetriesExhaustedLogLevel(String retriesExhaustedLogLevel) {
        this.retriesExhaustedLogLevel = retriesExhaustedLogLevel;
    }

    public String getRetryAttemptedLogLevel() {
        return this.retryAttemptedLogLevel;
    }

    public void setRetryAttemptedLogLevel(String retryAttemptedLogLevel) {
        this.retryAttemptedLogLevel = retryAttemptedLogLevel;
    }

    public String getRetryAttemptedLogInterval() {
        return this.retryAttemptedLogInterval;
    }

    public void setRetryAttemptedLogInterval(String retryAttemptedLogInterval) {
        this.retryAttemptedLogInterval = retryAttemptedLogInterval;
    }

    public String getLogRetryAttempted() {
        return this.logRetryAttempted;
    }

    public void setLogRetryAttempted(String logRetryAttempted) {
        this.logRetryAttempted = logRetryAttempted;
    }

    public String getLogStackTrace() {
        return this.logStackTrace;
    }

    public void setLogStackTrace(String logStackTrace) {
        this.logStackTrace = logStackTrace;
    }

    public String getLogRetryStackTrace() {
        return this.logRetryStackTrace;
    }

    public void setLogRetryStackTrace(String logRetryStackTrace) {
        this.logRetryStackTrace = logRetryStackTrace;
    }

    public String getLogHandled() {
        return this.logHandled;
    }

    public void setLogHandled(String logHandled) {
        this.logHandled = logHandled;
    }

    public String getLogNewException() {
        return this.logNewException;
    }

    public void setLogNewException(String logNewException) {
        this.logNewException = logNewException;
    }

    public String getLogContinued() {
        return this.logContinued;
    }

    public void setLogContinued(String logContinued) {
        this.logContinued = logContinued;
    }

    public String getLogExhausted() {
        return this.logExhausted;
    }

    public void setLogExhausted(String logExhausted) {
        this.logExhausted = logExhausted;
    }

    public String getLogExhaustedMessageHistory() {
        return this.logExhaustedMessageHistory;
    }

    public void setLogExhaustedMessageHistory(String logExhaustedMessageHistory) {
        this.logExhaustedMessageHistory = logExhaustedMessageHistory;
    }

    public String getLogExhaustedMessageBody() {
        return this.logExhaustedMessageBody;
    }

    public void setLogExhaustedMessageBody(String logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
    }

    public String getDisableRedelivery() {
        return this.disableRedelivery;
    }

    public void setDisableRedelivery(String disableRedelivery) {
        this.disableRedelivery = disableRedelivery;
    }

    public String getDelayPattern() {
        return this.delayPattern;
    }

    public void setDelayPattern(String delayPattern) {
        this.delayPattern = delayPattern;
    }

    public String getAllowRedeliveryWhileStopping() {
        return this.allowRedeliveryWhileStopping;
    }

    public void setAllowRedeliveryWhileStopping(String allowRedeliveryWhileStopping) {
        this.allowRedeliveryWhileStopping = allowRedeliveryWhileStopping;
    }

    public String getExchangeFormatterRef() {
        return this.exchangeFormatterRef;
    }

    public void setExchangeFormatterRef(String exchangeFormatterRef) {
        this.exchangeFormatterRef = exchangeFormatterRef;
    }
}

