/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.CassandraVersionFeatures;
import org.apache.cassandra.spark.bulkwriter.BroadcastableClusterInfo;
import org.apache.cassandra.spark.bulkwriter.BroadcastableClusterInfoGroup;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.CassandraClusterInfo;
import org.apache.cassandra.spark.bulkwriter.CassandraContext;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.IBroadcastableClusterInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.WriteAvailability;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedWriteConf;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterSupport;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.exception.SidecarApiCallException;
import org.apache.cassandra.spark.exception.TimeSkewTooLargeException;
import org.apache.cassandra.spark.validation.StartupValidatable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraClusterInfoGroup
implements ClusterInfo,
MultiClusterSupport<ClusterInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraClusterInfoGroup.class);
    private final List<ClusterInfo> clusterInfos;
    private final String clusterId;
    private volatile Map<String, ClusterInfo> clusterInfoById;
    private volatile TokenRangeMapping<RingInstance> consolidatedTokenRangeMapping;
    private Partitioner cachedPartitioner;
    private String cachedLowestCassandraVersion;

    public static CassandraClusterInfoGroup fromBulkSparkConf(BulkSparkConf conf) {
        return CassandraClusterInfoGroup.fromBulkSparkConf(conf, clusterId -> new CassandraClusterInfo(conf, (String)clusterId));
    }

    public static CassandraClusterInfoGroup from(BroadcastableClusterInfoGroup broadcastable) {
        return new CassandraClusterInfoGroup(broadcastable);
    }

    public static CassandraClusterInfoGroup fromBulkSparkConf(BulkSparkConf conf, Function<String, ClusterInfo> clusterInfoFactory) {
        CoordinatedWriteConf coordinatedWriteConf = conf.coordinatedWriteConf();
        Preconditions.checkArgument((coordinatedWriteConf != null ? 1 : 0) != 0, (Object)("In order to create an instance of CassandraCoordinatedBulkWriterContext, you must provide the appropriate coordinated write configuration by setting the `" + String.valueOf(WriterOptions.COORDINATED_WRITE_CONFIG) + "` writer option."));
        for (String clusterId : coordinatedWriteConf.clusters().keySet()) {
            Preconditions.checkState((!StringUtils.isEmpty((CharSequence)clusterId) ? 1 : 0) != 0, (String)"Found coordinatedWriteConf with empty or null clusterId. %s", (Object[])new Object[]{coordinatedWriteConf});
        }
        List<ClusterInfo> clusterInfos = coordinatedWriteConf.clusters().keySet().stream().map(clusterInfoFactory).collect(Collectors.toList());
        Preconditions.checkState((!clusterInfos.isEmpty() ? 1 : 0) != 0, (String)"No cluster info is built from %s", (Object[])new Object[]{coordinatedWriteConf});
        return new CassandraClusterInfoGroup(clusterInfos);
    }

    @VisibleForTesting
    public static CassandraClusterInfoGroup createFrom(List<ClusterInfo> clusterInfos) {
        return new CassandraClusterInfoGroup(clusterInfos);
    }

    private CassandraClusterInfoGroup(List<ClusterInfo> clusterInfos) {
        this.clusterInfos = Collections.unmodifiableList(clusterInfos);
        this.clusterInfoById();
        this.clusterId = "ClusterInfoGroup: [" + String.join((CharSequence)", ", this.applyOnEach(ClusterInfo::clusterId).values()) + "]";
    }

    private CassandraClusterInfoGroup(BroadcastableClusterInfoGroup broadcastable) {
        ArrayList clusterInfosList = new ArrayList();
        broadcastable.forEach((String clusterId, IBroadcastableClusterInfo broadcastableInfo) -> clusterInfosList.add(new CassandraClusterInfo((BroadcastableClusterInfo)broadcastableInfo)));
        this.clusterInfos = Collections.unmodifiableList(clusterInfosList);
        this.cachedPartitioner = broadcastable.getPartitioner();
        this.cachedLowestCassandraVersion = broadcastable.getLowestCassandraVersion();
        this.clusterId = broadcastable.clusterId();
        this.clusterInfoById();
    }

    @Override
    public void refreshClusterInfo() {
        this.runOnEach(ClusterInfo::refreshClusterInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenRangeMapping<RingInstance> getTokenRangeMapping(boolean cached) {
        if (this.clusterInfos.size() == 1) {
            return this.clusterInfos.get(0).getTokenRangeMapping(cached);
        }
        if (!cached || this.consolidatedTokenRangeMapping == null) {
            CassandraClusterInfoGroup cassandraClusterInfoGroup = this;
            synchronized (cassandraClusterInfoGroup) {
                if (cached && this.consolidatedTokenRangeMapping != null) {
                    return this.consolidatedTokenRangeMapping;
                }
                Map<String, TokenRangeMapping> aggregated = this.applyOnEach(c -> c.getTokenRangeMapping(cached));
                this.consolidatedTokenRangeMapping = TokenRangeMapping.consolidate(new ArrayList(aggregated.values()));
            }
        }
        return this.consolidatedTokenRangeMapping;
    }

    @Override
    public String getLowestCassandraVersion() {
        if (this.cachedLowestCassandraVersion != null) {
            return this.cachedLowestCassandraVersion;
        }
        if (this.clusterInfos.size() == 1) {
            return this.clusterInfos.get(0).getLowestCassandraVersion();
        }
        Map<String, String> aggregated = this.applyOnEach(ClusterInfo::getLowestCassandraVersion);
        List versions = aggregated.values().stream().map(CassandraVersionFeatures::cassandraVersionFeaturesFromCassandraVersion).sorted().collect(Collectors.toList());
        CassandraVersionFeatures first = (CassandraVersionFeatures)versions.get(0);
        CassandraVersionFeatures last = (CassandraVersionFeatures)versions.get(versions.size() - 1);
        Preconditions.checkState((first.getMajorVersion() == last.getMajorVersion() ? 1 : 0) != 0, (String)"Cluster versions are not compatible. lowest=%s and highest=%s", (Object[])new Object[]{first.getRawVersionString(), last.getRawVersionString()});
        return first.getRawVersionString();
    }

    @Override
    public Map<RingInstance, WriteAvailability> clusterWriteAvailability() {
        if (this.clusterInfos.size() == 1) {
            return this.clusterInfos.get(0).clusterWriteAvailability();
        }
        Map<String, Map> aggregated = this.applyOnEach(ClusterInfo::clusterWriteAvailability);
        HashMap<RingInstance, WriteAvailability> consolidated = new HashMap<RingInstance, WriteAvailability>();
        aggregated.values().forEach(consolidated::putAll);
        return consolidated;
    }

    @Override
    public Partitioner getPartitioner() {
        if (this.cachedPartitioner != null) {
            return this.cachedPartitioner;
        }
        Map<String, Partitioner> aggregated = this.applyOnEach(ClusterInfo::getPartitioner);
        EnumSet<Partitioner> partitioners = EnumSet.copyOf(aggregated.values());
        if (partitioners.size() != 1) {
            throw new IllegalStateException("Clusters are not running with the same partitioner kind. Found partitioners: " + String.valueOf(aggregated));
        }
        return (Partitioner)partitioners.iterator().next();
    }

    @Override
    public void checkBulkWriterIsEnabledOrThrow() {
        this.runOnEach(ClusterInfo::checkBulkWriterIsEnabledOrThrow);
    }

    @Override
    public void validateTimeSkew(Range<BigInteger> range) throws SidecarApiCallException, TimeSkewTooLargeException {
        this.clusterInfos.forEach((? super T ci) -> ci.validateTimeSkew(range));
    }

    @Override
    public String getKeyspaceSchema(boolean cached) {
        return this.clusterInfos.get(0).getKeyspaceSchema(cached);
    }

    @Override
    public ReplicationFactor replicationFactor() {
        throw new UnsupportedOperationException("Not implemented in CassandraClusterInfoGroup");
    }

    @Override
    public CassandraContext getCassandraContext() {
        throw new UnsupportedOperationException("Not implemented in CassandraClusterInfoGroup");
    }

    @Override
    public void startupValidate() {
        this.runOnEach(StartupValidatable::startupValidate);
    }

    @Override
    public String clusterId() {
        return this.clusterId;
    }

    @Override
    public int size() {
        return this.clusterInfos.size();
    }

    @Override
    public void forEach(BiConsumer<String, ClusterInfo> action) {
        this.clusterInfoById().forEach(action);
    }

    @Override
    @Nullable
    public ClusterInfo getValueOrNull(@NotNull String clusterId) {
        return this.clusterInfoById().get(clusterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ClusterInfo> clusterInfoById() {
        if (this.clusterInfoById == null) {
            CassandraClusterInfoGroup cassandraClusterInfoGroup = this;
            synchronized (cassandraClusterInfoGroup) {
                if (this.clusterInfoById == null) {
                    this.clusterInfoById = this.clusterInfos.stream().collect(Collectors.toMap(ClusterInfo::clusterId, Function.identity()));
                }
            }
        }
        return this.clusterInfoById;
    }

    private void runOnEach(Consumer<ClusterInfo> action) {
        for (ClusterInfo clusterInfo : this.clusterInfos) {
            try {
                action.accept(clusterInfo);
            }
            catch (Throwable cause) {
                throw this.toRuntimeException(clusterInfo, cause);
            }
        }
    }

    private <T> Map<String, T> applyOnEach(Function<ClusterInfo, T> action) {
        LinkedHashMap<String, T> aggregated = new LinkedHashMap<String, T>(this.clusterInfos.size());
        for (ClusterInfo clusterInfo : this.clusterInfos) {
            try {
                aggregated.put(clusterInfo.clusterId(), action.apply(clusterInfo));
            }
            catch (Throwable cause) {
                throw this.toRuntimeException(clusterInfo, cause);
            }
        }
        return aggregated;
    }

    private RuntimeException toRuntimeException(ClusterInfo clusterInfo, Throwable cause) {
        LOGGER.error("Failed to perform action on cluster. cluster={}", (Object)clusterInfo.clusterId(), (Object)cause);
        return new RuntimeException("Failed to perform action on cluster: " + clusterInfo.clusterId(), cause);
    }

    @VisibleForTesting
    Map<String, ClusterInfo> clusterInfoByIdUnsafe() {
        return this.clusterInfoById;
    }
}

