/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaTransformations;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.Types;

public class SchemaUpdater {
    private SchemaUpdater() {
    }

    public static void load(Schema schema, KeyspaceMetadata keyspaceMetadata) {
        schema.transform(SchemaTransformations.addKeyspace((KeyspaceMetadata)keyspaceMetadata, (boolean)false));
    }

    public static void load(Schema schema, KeyspaceMetadata keyspaceMetadata, TableMetadata tableMetadata) {
        schema.transform(SchemaTransformations.addTable((TableMetadata)tableMetadata, (boolean)false));
    }

    public static void load(Schema schema, KeyspaceMetadata keyspaceMetadata, Types userTypes) {
        schema.transform(SchemaTransformations.addTypes((Types)userTypes, (boolean)true));
    }

    public static void updateTable(Schema schema, KeyspaceMetadata keyspaceMetadata, TableMetadata tableMetadata) {
        schema.transform(st -> st.withAddedOrUpdated(keyspaceMetadata.withSwapped(keyspaceMetadata.tables.withSwapped(tableMetadata))));
    }
}

