/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.spark.data.NativeType;
import org.apache.cassandra.spark.utils.RandomUtils;

public class Decimal
extends NativeType {
    public static final Decimal INSTANCE = new Decimal();

    public String name() {
        return "decimal";
    }

    @Override
    public AbstractType<?> dataType() {
        return DecimalType.instance;
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        BigInteger unscaledVal = new BigInteger(BigNumberConfig.DEFAULT.bigDecimalPrecision(), RandomUtils.RANDOM);
        int scale = BigNumberConfig.DEFAULT.bigDecimalScale();
        return new BigDecimal(unscaledVal, scale);
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, Object value) {
        udtValue.setDecimal(position, (BigDecimal)value);
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return DataType.decimal();
    }
}

