/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class PendingHintsInfo {
    public static final String HOST_ID = "host_id";
    public static final String TOTAL_FILES = "total_files";
    public static final String OLDEST_TIMESTAMP = "oldest_timestamp";
    public static final String NEWEST_TIMESTAMP = "newest_timestamp";
    public final UUID hostId;
    public final int totalFiles;
    public final long oldestTimestamp;
    public final long newestTimestamp;

    public PendingHintsInfo(UUID hostId, int totalFiles, long oldestTimestamp, long newestTimestamp) {
        this.hostId = hostId;
        this.totalFiles = totalFiles;
        this.oldestTimestamp = oldestTimestamp;
        this.newestTimestamp = newestTimestamp;
    }

    public Map<String, String> asMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(HOST_ID, this.hostId.toString());
        ret.put(TOTAL_FILES, String.valueOf(this.totalFiles));
        ret.put(OLDEST_TIMESTAMP, String.valueOf(this.oldestTimestamp));
        ret.put(NEWEST_TIMESTAMP, String.valueOf(this.newestTimestamp));
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PendingHintsInfo that = (PendingHintsInfo)o;
        return this.totalFiles == that.totalFiles && this.oldestTimestamp == that.oldestTimestamp && this.newestTimestamp == that.newestTimestamp && Objects.equals(this.hostId, that.hostId);
    }

    public int hashCode() {
        return Objects.hash(this.hostId, this.totalFiles, this.oldestTimestamp, this.newestTimestamp);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("hostId", this.hostId).add("totalFiles", this.totalFiles).add("oldestTimestamp", this.oldestTimestamp).add("newestTimestamp", this.newestTimestamp).toString();
    }
}

