/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bitpack;

import java.io.IOException;
import org.apache.cassandra.index.sai.disk.io.IndexFileUtils;
import org.apache.cassandra.index.sai.disk.io.IndexInputReader;
import org.apache.cassandra.index.sai.disk.v1.DirectReaders;
import org.apache.cassandra.index.sai.disk.v1.LongArray;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.index.sai.disk.v1.bitpack.AbstractBlockPackedReader;
import org.apache.cassandra.index.sai.disk.v1.bitpack.NumericValuesMeta;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BitUtil;

public class BlockPackedReader
implements LongArray.Factory {
    private final FileHandle file;
    private final int blockShift;
    private final int blockMask;
    private final long valueCount;
    private final byte[] blockBitsPerValue;
    private final long[] blockOffsets;
    private final long[] minValues;

    public BlockPackedReader(FileHandle file, NumericValuesMeta meta) throws IOException {
        this.file = file;
        this.valueCount = meta.valueCount;
        this.blockShift = SAICodecUtils.checkBlockSize(meta.blockSize, 64, 0x8000000);
        this.blockMask = meta.blockSize - 1;
        int numBlocks = SAICodecUtils.numBlocks(this.valueCount, meta.blockSize);
        this.blockBitsPerValue = new byte[numBlocks];
        this.blockOffsets = new long[numBlocks];
        this.minValues = new long[numBlocks];
        try (RandomAccessReader reader = this.file.createReader();
             IndexInputReader in = IndexInputReader.create(reader);){
            SAICodecUtils.validate(in);
            in.seek(meta.blockMetaOffset);
            for (int i = 0; i < numBlocks; ++i) {
                long val;
                int token = in.readByte() & 0xFF;
                int bitsPerValue = token >>> 1;
                int blockIndex = i;
                DirectReaders.checkBitsPerValue(bitsPerValue, in, () -> String.format("Block %d", blockIndex));
                this.minValues[i] = (token & 1) == 0 ? (val = BitUtil.zigZagDecode(1L + SAICodecUtils.readVLong(in))) : 0L;
                this.blockBitsPerValue[i] = (byte)bitsPerValue;
                this.blockOffsets[i] = bitsPerValue > 0 ? in.readVLong() : -1L;
            }
        }
    }

    @Override
    public LongArray open() {
        final IndexInput indexInput = IndexFileUtils.instance.openInput(this.file);
        return new AbstractBlockPackedReader(indexInput, this.blockBitsPerValue, this.blockShift, this.blockMask, this.valueCount){

            @Override
            protected long blockOffsetAt(int block) {
                return BlockPackedReader.this.blockOffsets[block];
            }

            @Override
            long delta(int block, int idx) {
                return BlockPackedReader.this.minValues[block];
            }

            @Override
            public void close() throws IOException {
                indexInput.close();
            }
        };
    }
}

