/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.cleanup;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.NoPayload;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupHistory;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupResponse;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupSession;
import org.apache.cassandra.service.paxos.cleanup.PaxosTableRepairs;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.IntrusiveStack;

public class PaxosRepairState {
    private final SharedContext ctx;
    private final AtomicReference<PendingCleanup> pendingCleanup = new AtomicReference();
    private final Map<UUID, PaxosCleanupSession> sessions = new ConcurrentHashMap<UUID, PaxosCleanupSession>();
    private final ConcurrentMap<TableId, PaxosTableRepairs> tableRepairsMap = new ConcurrentHashMap<TableId, PaxosTableRepairs>();

    public PaxosRepairState(SharedContext ctx) {
        this.ctx = ctx;
    }

    public static PaxosRepairState instance() {
        return Holder.instance;
    }

    PaxosTableRepairs getForTable(TableId tableId) {
        return this.tableRepairsMap.computeIfAbsent(tableId, k -> new PaxosTableRepairs());
    }

    public void evictHungRepairs() {
        long deadline = this.ctx.clock().nanoTime() - TimeUnit.MINUTES.toNanos(5L);
        for (PaxosTableRepairs repairs : this.tableRepairsMap.values()) {
            repairs.evictHungRepairs(deadline);
        }
    }

    public void clearRepairs() {
        for (PaxosTableRepairs repairs : this.tableRepairsMap.values()) {
            repairs.clear();
        }
    }

    public void setSession(PaxosCleanupSession session) {
        Preconditions.checkState(!this.sessions.containsKey(session.session));
        this.sessions.put(session.session, session);
    }

    public void removeSession(PaxosCleanupSession session) {
        Preconditions.checkState(this.sessions.containsKey(session.session));
        this.sessions.remove(session.session);
    }

    public void finishSession(InetAddressAndPort from, PaxosCleanupResponse response) {
        PaxosCleanupSession session = this.sessions.get(response.session);
        if (session != null) {
            session.finish(from, response);
        }
    }

    public void addCleanupHistory(Message<PaxosCleanupHistory> message) {
        PendingCleanup.add(this.ctx, this.pendingCleanup, message);
    }

    static class PendingCleanup
    extends IntrusiveStack<PendingCleanup> {
        private final Message<PaxosCleanupHistory> message;

        PendingCleanup(Message<PaxosCleanupHistory> message) {
            this.message = message;
        }

        private static void add(SharedContext ctx, AtomicReference<PendingCleanup> pendingCleanup, Message<PaxosCleanupHistory> message) {
            PendingCleanup next = new PendingCleanup(message);
            PendingCleanup prev = IntrusiveStack.push(AtomicReference::get, AtomicReference::compareAndSet, pendingCleanup, next);
            if (prev == null) {
                Stage.MISC.execute(() -> PendingCleanup.cleanup(ctx, pendingCleanup));
            }
        }

        /*
         * WARNING - void declaration
         */
        private static void cleanup(SharedContext ctx, AtomicReference<PendingCleanup> pendingCleanup) {
            void var5_13;
            void var5_10;
            PendingCleanup list = pendingCleanup.getAndSet(null);
            if (list == null) {
                return;
            }
            Ballot highBound = Ballot.none();
            for (PendingCleanup pendingCleanup2 : IntrusiveStack.iterable(list)) {
                PaxosCleanupHistory paxosCleanupHistory = (PaxosCleanupHistory)pendingCleanup2.message.payload;
                if (paxosCleanupHistory.highBound.compareTo(highBound) <= 0) continue;
                highBound = paxosCleanupHistory.highBound;
            }
            try {
                try {
                    PaxosState.ballotTracker().updateLowBound(highBound);
                }
                catch (IOException e) {
                    throw new FSWriteError(e);
                }
            }
            catch (Throwable t2) {
                for (PendingCleanup pendingCleanup3 : IntrusiveStack.iterable(list)) {
                    ctx.messaging().respondWithFailure(RequestFailureReason.UNKNOWN, pendingCleanup3.message);
                }
                throw t2;
            }
            Set failed = null;
            Object var5_9 = null;
            for (PendingCleanup pending : IntrusiveStack.iterable(list)) {
                try {
                    Schema.instance.getColumnFamilyStoreInstance(((PaxosCleanupHistory)pending.message.payload).tableId).syncPaxosRepairHistory(((PaxosCleanupHistory)pending.message.payload).history, false);
                }
                catch (Throwable t3) {
                    Throwable throwable = Throwables.merge(var5_10, t3);
                    if (failed == null) {
                        failed = Collections.newSetFromMap(new IdentityHashMap());
                    }
                    failed.add(pending);
                    ctx.messaging().respondWithFailure(RequestFailureReason.UNKNOWN, pending.message);
                }
            }
            try {
                SystemKeyspace.flushPaxosRepairHistory();
                for (PendingCleanup pending : IntrusiveStack.iterable(list)) {
                    if (failed != null && failed.contains(pending)) continue;
                    ctx.messaging().respond(NoPayload.noPayload, pending.message);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = Throwables.merge(var5_10, throwable);
                for (PendingCleanup pending : IntrusiveStack.iterable(list)) {
                    if (failed != null && failed.contains(pending)) continue;
                    ctx.messaging().respondWithFailure(RequestFailureReason.UNKNOWN, pending.message);
                }
            }
            Throwables.maybeFail((Throwable)var5_13);
        }
    }

    private static class Holder {
        private static final PaxosRepairState instance = new PaxosRepairState(SharedContext.Global.instance);

        private Holder() {
        }
    }
}

