/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.apache.cassandra.io.util.BytesReadTracker;
import org.apache.cassandra.io.util.DataInputPlus;

public class TrackedDataInputPlus
implements DataInputPlus,
BytesReadTracker {
    private long bytesRead;
    private final long limit;
    final DataInput source;

    public TrackedDataInputPlus(DataInput source) {
        this(source, -1L);
    }

    public TrackedDataInputPlus(DataInput source, long limit) {
        this.source = source;
        this.limit = limit;
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public void reset(long count) {
        this.bytesRead = count;
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.checkCanRead(1);
        boolean bool = this.source.readBoolean();
        ++this.bytesRead;
        return bool;
    }

    @Override
    public byte readByte() throws IOException {
        this.checkCanRead(1);
        byte b = this.source.readByte();
        ++this.bytesRead;
        return b;
    }

    @Override
    public char readChar() throws IOException {
        this.checkCanRead(2);
        char c = this.source.readChar();
        this.bytesRead += 2L;
        return c;
    }

    @Override
    public double readDouble() throws IOException {
        this.checkCanRead(8);
        double d = this.source.readDouble();
        this.bytesRead += 8L;
        return d;
    }

    @Override
    public float readFloat() throws IOException {
        this.checkCanRead(4);
        float f = this.source.readFloat();
        this.bytesRead += 4L;
        return f;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.checkCanRead(len);
        this.source.readFully(b, off, len);
        this.bytesRead += (long)len;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.checkCanRead(b.length);
        this.source.readFully(b);
        this.bytesRead += (long)b.length;
    }

    @Override
    public int readInt() throws IOException {
        this.checkCanRead(4);
        int i = this.source.readInt();
        this.bytesRead += 4L;
        return i;
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong() throws IOException {
        this.checkCanRead(8);
        long l = this.source.readLong();
        this.bytesRead += 8L;
        return l;
    }

    @Override
    public short readShort() throws IOException {
        this.checkCanRead(2);
        short s2 = this.source.readShort();
        this.bytesRead += 2L;
        return s2;
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.checkCanRead(1);
        int i = this.source.readUnsignedByte();
        ++this.bytesRead;
        return i;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.checkCanRead(2);
        int i = this.source.readUnsignedShort();
        this.bytesRead += 2L;
        return i;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int skipped = this.source.skipBytes(this.limit < 0L ? n : (int)Math.min(this.limit - this.bytesRead, (long)n));
        this.bytesRead += (long)skipped;
        return skipped;
    }

    private void checkCanRead(int size) throws IOException {
        if (this.limit >= 0L && this.bytesRead + (long)size > this.limit) {
            this.skipBytes((int)(this.limit - this.bytesRead));
            throw new EOFException("EOF after " + (this.limit - this.bytesRead) + " bytes out of " + size);
        }
    }
}

