/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.data.partitioner.TokenPartitioner;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.quicktheories.QuickTheory;
import org.quicktheories.generators.SourceDSL;

public class TokenPartitionerTests {
    private static final int NUM_TOKEN_TESTS = 100;

    @Test
    public void testTokenPartitioner() {
        QuickTheory.qt().forAll(TestUtils.partitioners(), SourceDSL.arbitrary().pick(Arrays.asList(1, 3, 6, 12, 104, 208, 416)), SourceDSL.arbitrary().pick(Arrays.asList(1, 2, 4, 16, 128, 1024))).checkAssert(this::runTest);
    }

    private void runTest(Partitioner partitioner, int numInstances, int numCores) {
        TokenPartitioner tokenPartitioner = new TokenPartitioner(TestUtils.createRing(partitioner, numInstances), 1, numCores);
        if (numInstances == 1 && numCores == 1) {
            Assertions.assertThat((int)tokenPartitioner.numPartitions()).isEqualTo(1);
        } else {
            Assertions.assertThat((int)tokenPartitioner.numPartitions()).isGreaterThan(1);
        }
        Map tokens = IntStream.range(0, 100).mapToObj(token -> RandomUtils.randomBigInteger((Partitioner)partitioner)).collect(Collectors.toMap(Function.identity(), token -> 0));
        for (int partition = 0; partition < tokenPartitioner.numPartitions(); ++partition) {
            Range range = tokenPartitioner.getTokenRange(partition);
            for (BigInteger token2 : tokens.keySet()) {
                if (!range.contains((Comparable)token2)) continue;
                tokens.put(token2, tokens.get(token2) + 1);
                Assertions.assertThat((boolean)tokenPartitioner.isInPartition(token2, ByteBuffer.wrap("not important".getBytes()), partition)).isTrue();
            }
        }
        for (Map.Entry entry : tokens.entrySet()) {
            ((AbstractIntegerAssert)Assertions.assertThat((Integer)entry.getValue()).as("Token not found in any token partitions: " + String.valueOf(entry.getKey()), new Object[0])).isGreaterThanOrEqualTo(1);
            ((AbstractIntegerAssert)Assertions.assertThat((Integer)entry.getValue()).as("Token exists in more than one token partition: " + String.valueOf(entry.getKey()), new Object[0])).isLessThanOrEqualTo(1);
        }
    }
}

