/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.ProxyInputStreamTest;
import org.apache.commons.io.test.CustomIOException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class BoundedInputStreamTest {
    BoundedInputStreamTest() {
    }

    static Stream<Arguments> testAvailableAfterClose() throws IOException {
        InputStream noOpClose = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)noOpClose.available()).thenReturn((Object)42, (Object[])new Integer[]{42});
        InputStream returnsZeroAfterClose = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)returnsZeroAfterClose.available()).thenReturn((Object)42, (Object[])new Integer[]{0});
        InputStream throwsAfterClose = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)throwsAfterClose.available()).thenReturn((Object)42).thenThrow(new Throwable[]{new IOException("Stream closed")});
        return Stream.of(Arguments.of((Object[])new Object[]{"underlying stream still returns 42 after close", noOpClose, 42}), Arguments.of((Object[])new Object[]{"underlying stream returns 0 after close", returnsZeroAfterClose, 42}), Arguments.of((Object[])new Object[]{"underlying stream throws IOException after close", throwsAfterClose, 42}));
    }

    static Stream<Arguments> testAvailableUpperLimit() {
        byte[] helloWorld = "Hello World".getBytes(StandardCharsets.UTF_8);
        return Stream.of(Arguments.of((Object[])new Object[]{new ByteArrayInputStream(helloWorld), helloWorld.length - 1, helloWorld.length - 1, 0}), Arguments.of((Object[])new Object[]{new ByteArrayInputStream(helloWorld), helloWorld.length + 1, helloWorld.length, 0}), Arguments.of((Object[])new Object[]{new NullInputStream(Long.MAX_VALUE), Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE}));
    }

    static Stream<Arguments> testReadAfterClose() throws IOException {
        InputStream noOpClose = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)noOpClose.read()).thenReturn((Object)42);
        InputStream returnsEofAfterClose = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)returnsEofAfterClose.read()).thenReturn((Object)-1);
        InputStream throwsAfterClose = (InputStream)Mockito.mock(InputStream.class);
        IOException closed = new IOException("Stream closed");
        Mockito.when((Object)throwsAfterClose.read()).thenThrow(new Throwable[]{closed});
        return Stream.of(Arguments.of((Object[])new Object[]{"underlying stream still reads data after close", noOpClose, 42}), Arguments.of((Object[])new Object[]{"underlying stream returns EOF after close", returnsEofAfterClose, -1}), Arguments.of((Object[])new Object[]{"underlying stream throws IOException after close", throwsAfterClose, closed}));
    }

    static Stream<Arguments> testRemaining() {
        return Stream.of(Arguments.of((Object[])new Object[]{"unbounded (EOF constant)", -1, Long.MAX_VALUE}), Arguments.of((Object[])new Object[]{"unbounded (arbitrary negative)", Long.MIN_VALUE, Long.MAX_VALUE}), Arguments.of((Object[])new Object[]{"bounded (zero)", 0L, 0L}), Arguments.of((Object[])new Object[]{"bounded (small)", 1024L, 1024L}), Arguments.of((Object[])new Object[]{"bounded (Integer.MAX_VALUE)", Integer.MAX_VALUE, Integer.MAX_VALUE}), Arguments.of((Object[])new Object[]{"bounded (Long.MAX_VALUE)", Long.MAX_VALUE, Long.MAX_VALUE}));
    }

    private void compare(String message, byte[] expected, byte[] actual) {
        Assertions.assertEquals((int)expected.length, (int)actual.length, () -> message + " (array length equals check)");
        MutableInt mi = new MutableInt();
        for (int i = 0; i < expected.length; ++i) {
            mi.setValue(i);
            Assertions.assertEquals((byte)expected[i], (byte)actual[i], () -> message + " byte[" + mi + "]");
        }
    }

    @Test
    void testAfterReadConsumer() throws Exception {
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        AtomicBoolean boolRef = new AtomicBoolean();
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(hello))).setMaxCount((long)hello.length)).setAfterRead(i -> boolRef.set(true))).get();){
            IOUtils.consume((InputStream)bounded);
        }
        Assertions.assertTrue((boolean)boolRef.get());
        String message = "test exception message";
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(hello))).setMaxCount((long)hello.length)).setAfterRead(i -> {
            throw new CustomIOException("test exception message");
        })).get();){
            Assertions.assertEquals((Object)"test exception message", (Object)((CustomIOException)Assertions.assertThrowsExactly(CustomIOException.class, () -> BoundedInputStreamTest.lambda$testAfterReadConsumer$4((InputStream)bounded))).getMessage());
        }
    }

    @ParameterizedTest(name="{index} \u2014 {0}")
    @MethodSource
    void testAvailableAfterClose(String caseName, InputStream delegate, int expectedBeforeClose) throws Exception {
        BoundedInputStream shadow;
        try (BoundedInputStream in = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(delegate)).setPropagateClose(true)).get();){
            Assertions.assertEquals((int)expectedBeforeClose, (int)in.available(), (String)(caseName + " (before close)"));
            shadow = in;
        }
        ((InputStream)Mockito.verify((Object)delegate, (VerificationMode)Mockito.times((int)1))).close();
        Assertions.assertEquals((int)0, (int)shadow.available(), (String)(caseName + " (after close)"));
        ((InputStream)Mockito.verify((Object)delegate, (VerificationMode)Mockito.times((int)1))).available();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{delegate});
    }

    @ParameterizedTest
    @MethodSource
    void testAvailableUpperLimit(InputStream input, long maxCount, int expectedBeforeSkip, int expectedAfterSkip) throws Exception {
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(input)).setMaxCount(maxCount)).get();){
            Assertions.assertEquals((int)expectedBeforeSkip, (int)bounded.available(), (String)"available should be limited by maxCount and data length");
            IOUtils.skip((InputStream)bounded, (long)expectedBeforeSkip);
            Assertions.assertEquals((int)expectedAfterSkip, (int)bounded.available(), (String)"after skipping available should be limited by maxCount and data length");
        }
    }

    @Test
    void testBuilderGet() {
        Assertions.assertThrows(IllegalStateException.class, () -> BoundedInputStream.builder().get());
    }

    @Test
    void testCloseHandleIOException() throws IOException {
        ProxyInputStreamTest.testCloseHandleIOException(BoundedInputStream.builder());
    }

    @ParameterizedTest
    @ValueSource(longs={-100L, -1L, 0L, 1L, 2L, 4L, 8L, 16L, 32L, 64L})
    void testCounts(long startCount) throws Exception {
        int i;
        int readCount;
        byte[] helloWorld = "Hello World".getBytes(StandardCharsets.UTF_8);
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        long actualStart = startCount < 0L ? 0L : startCount;
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setCount(startCount)).setMaxCount((long)helloWorld.length)).get();){
            Assertions.assertTrue((boolean)bounded.markSupported());
            Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxCount());
            Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)actualStart, (long)bounded.getCount());
            Assertions.assertEquals((long)Math.max(0L, bounded.getMaxCount() - actualStart), (long)bounded.getRemaining());
            Assertions.assertEquals((long)Math.max(0L, bounded.getMaxLength() - actualStart), (long)bounded.getRemaining());
            int readCount2 = 0;
            for (int i2 = 0; i2 < helloWorld.length; ++i2) {
                int expectedCh = bounded.getRemaining() > 0L ? helloWorld[i2] : -1;
                int actualCh = bounded.read();
                Assertions.assertEquals((int)expectedCh, (int)actualCh, (String)("limit = length byte[" + i2 + "]"));
                if (actualCh != -1) {
                    ++readCount2;
                }
                Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxCount());
                Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxLength());
                Assertions.assertEquals((long)(actualStart + (long)readCount2), (long)bounded.getCount(), (String)("i=" + i2));
                Assertions.assertEquals((long)Math.max(0L, bounded.getMaxCount() - ((long)readCount2 + actualStart)), (long)bounded.getRemaining());
                Assertions.assertEquals((long)Math.max(0L, bounded.getMaxLength() - ((long)readCount2 + actualStart)), (long)bounded.getRemaining());
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit = length end");
            Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)((long)readCount2 + actualStart), (long)bounded.getCount());
            Assertions.assertEquals((long)0L, (long)bounded.getRemaining());
            Assertions.assertEquals((int)0, (int)bounded.available());
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        int maxCountP1 = helloWorld.length + 1;
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setCount(startCount)).setMaxCount((long)maxCountP1)).get();){
            Assertions.assertTrue((boolean)bounded.markSupported());
            Assertions.assertEquals((long)maxCountP1, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)actualStart, (long)bounded.getCount());
            Assertions.assertEquals((long)Math.max(0L, bounded.getMaxCount() - actualStart), (long)bounded.getRemaining());
            Assertions.assertEquals((long)Math.max(0L, bounded.getMaxLength() - actualStart), (long)bounded.getRemaining());
            readCount = 0;
            for (i = 0; i < helloWorld.length; ++i) {
                int expectedCh = bounded.getRemaining() > 0L ? helloWorld[i] : -1;
                int actualCh = bounded.read();
                Assertions.assertEquals((int)expectedCh, (int)actualCh, (String)("limit = length byte[" + i + "]"));
                if (actualCh != -1) {
                    ++readCount;
                }
                Assertions.assertEquals((long)maxCountP1, (long)bounded.getMaxCount());
                Assertions.assertEquals((long)maxCountP1, (long)bounded.getMaxLength());
                Assertions.assertEquals((long)(actualStart + (long)readCount), (long)bounded.getCount(), (String)("i=" + i));
                Assertions.assertEquals((long)Math.max(0L, bounded.getMaxCount() - ((long)readCount + actualStart)), (long)bounded.getRemaining());
                Assertions.assertEquals((long)Math.max(0L, bounded.getMaxLength() - ((long)readCount + actualStart)), (long)bounded.getRemaining());
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit > length end");
            Assertions.assertEquals((int)0, (int)bounded.available());
            Assertions.assertEquals((long)maxCountP1, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)((long)readCount + actualStart), (long)bounded.getCount());
            Assertions.assertEquals((long)Math.max(0L, (long)maxCountP1 - bounded.getCount()), (long)bounded.getRemaining());
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)hello.length)).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            Assertions.assertEquals((long)hello.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)0L, (long)bounded.getCount());
            Assertions.assertEquals((long)bounded.getMaxLength(), (long)bounded.getRemaining());
            readCount = 0;
            for (i = 0; i < hello.length; ++i) {
                Assertions.assertEquals((int)hello[i], (int)bounded.read(), (String)("limit < length byte[" + i + "]"));
                Assertions.assertEquals((long)hello.length, (long)bounded.getMaxLength());
                Assertions.assertEquals((long)(++readCount), (long)bounded.getCount());
                Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount), (long)bounded.getRemaining());
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit < length end");
            Assertions.assertEquals((int)0, (int)bounded.available());
            Assertions.assertEquals((long)hello.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)readCount, (long)bounded.getCount());
            Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount), (long)bounded.getRemaining());
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
    }

    @Test
    void testMarkReset() throws Exception {
        byte[] helloWorld = "Hello World".getBytes(StandardCharsets.UTF_8);
        int helloWorldLen = helloWorld.length;
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        byte[] world = " World".getBytes(StandardCharsets.UTF_8);
        int helloLen = hello.length;
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).get();){
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.mark(0);
            this.compare("limit = -1", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = -1", hello, IOUtils.toByteArray((InputStream)bounded, (int)helloLen));
            bounded.mark(helloWorldLen);
            this.compare("limit = -1", world, IOUtils.toByteArray((InputStream)bounded));
            bounded.reset();
            this.compare("limit = -1", world, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount(0L)).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.mark(0);
            this.compare("limit = 0", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = 0", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            bounded.mark(helloWorldLen);
            this.compare("limit = 0", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)helloWorld.length)).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.mark(0);
            this.compare("limit = length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = length", hello, IOUtils.toByteArray((InputStream)bounded, (int)helloLen));
            bounded.mark(helloWorldLen);
            this.compare("limit = length", world, IOUtils.toByteArray((InputStream)bounded));
            bounded.reset();
            this.compare("limit = length", world, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)(helloWorld.length + 1))).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.mark(0);
            this.compare("limit > length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit > length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            bounded.reset();
            this.compare("limit > length", hello, IOUtils.toByteArray((InputStream)bounded, (int)helloLen));
            bounded.mark(helloWorldLen);
            this.compare("limit > length", world, IOUtils.toByteArray((InputStream)bounded));
            bounded.reset();
            this.compare("limit > length", world, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)(helloWorld.length - (hello.length + 1)))).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.mark(0);
            this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded));
            bounded.reset();
            this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded, (int)helloLen));
            bounded.mark(helloWorldLen);
            this.compare("limit < length", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            bounded.reset();
            this.compare("limit < length", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
    }

    @Test
    void testOnMaxCountConsumer() throws Exception {
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        AtomicBoolean boolRef = new AtomicBoolean();
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(hello))).setMaxCount((long)hello.length)).setOnMaxCount(null)).setOnMaxCount((m, c) -> boolRef.set(true))).get();){
            IOUtils.consume((InputStream)bounded);
        }
        Assertions.assertTrue((boolean)boolRef.get());
        String message = "test exception message";
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(hello))).setMaxCount((long)hello.length)).setOnMaxCount((m, c) -> {
            throw new CustomIOException("test exception message");
        })).get();){
            Assertions.assertEquals((Object)"test exception message", (Object)((CustomIOException)Assertions.assertThrowsExactly(CustomIOException.class, () -> IOUtils.consume((InputStream)bounded))).getMessage());
        }
    }

    @Test
    void testOnMaxLength() throws Exception {
        int i;
        int readCount;
        byte[] helloWorld = "Hello World".getBytes(StandardCharsets.UTF_8);
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        AtomicBoolean boolRef = new AtomicBoolean();
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)helloWorld.length)).setOnMaxCount((m, c) -> boolRef.set(true))).get();){
            Assertions.assertTrue((boolean)bounded.markSupported());
            Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxCount());
            Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)0L, (long)bounded.getCount());
            Assertions.assertEquals((long)bounded.getMaxCount(), (long)bounded.getRemaining());
            Assertions.assertEquals((long)bounded.getMaxLength(), (long)bounded.getRemaining());
            Assertions.assertFalse((boolean)boolRef.get());
            int readCount2 = 0;
            for (int i2 = 0; i2 < helloWorld.length; ++i2) {
                Assertions.assertEquals((int)helloWorld[i2], (int)bounded.read(), (String)("limit = length byte[" + i2 + "]"));
                Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxCount());
                Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxLength());
                Assertions.assertEquals((long)(++readCount2), (long)bounded.getCount());
                Assertions.assertEquals((long)(bounded.getMaxCount() - (long)readCount2), (long)bounded.getRemaining());
                Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount2), (long)bounded.getRemaining());
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit = length end");
            Assertions.assertEquals((int)0, (int)bounded.available());
            Assertions.assertEquals((long)helloWorld.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)readCount2, (long)bounded.getCount());
            Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount2), (long)bounded.getRemaining());
            Assertions.assertTrue((boolean)boolRef.get());
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        boolRef.set(false);
        int length2 = helloWorld.length + 1;
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)length2)).setOnMaxCount((m, c) -> boolRef.set(true))).get();){
            Assertions.assertTrue((boolean)bounded.markSupported());
            Assertions.assertEquals((long)length2, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)0L, (long)bounded.getCount());
            Assertions.assertEquals((long)bounded.getMaxLength(), (long)bounded.getRemaining());
            Assertions.assertFalse((boolean)boolRef.get());
            readCount = 0;
            for (i = 0; i < helloWorld.length; ++i) {
                Assertions.assertEquals((int)helloWorld[i], (int)bounded.read(), (String)("limit > length byte[" + i + "]"));
                Assertions.assertEquals((long)length2, (long)bounded.getMaxLength());
                Assertions.assertEquals((long)(++readCount), (long)bounded.getCount());
                Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount), (long)bounded.getRemaining());
            }
            Assertions.assertEquals((int)0, (int)bounded.available());
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit > length end");
            Assertions.assertEquals((long)length2, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)readCount, (long)bounded.getCount());
            Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount), (long)bounded.getRemaining());
            Assertions.assertFalse((boolean)boolRef.get());
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        boolRef.set(false);
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)hello.length)).setOnMaxCount((m, c) -> boolRef.set(true))).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            Assertions.assertEquals((long)hello.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)0L, (long)bounded.getCount());
            Assertions.assertEquals((long)bounded.getMaxLength(), (long)bounded.getRemaining());
            Assertions.assertFalse((boolean)boolRef.get());
            readCount = 0;
            for (i = 0; i < hello.length; ++i) {
                Assertions.assertEquals((int)hello[i], (int)bounded.read(), (String)("limit < length byte[" + i + "]"));
                Assertions.assertEquals((long)hello.length, (long)bounded.getMaxLength());
                Assertions.assertEquals((long)(++readCount), (long)bounded.getCount());
                Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount), (long)bounded.getRemaining());
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit < length end");
            Assertions.assertEquals((long)hello.length, (long)bounded.getMaxLength());
            Assertions.assertEquals((long)readCount, (long)bounded.getCount());
            Assertions.assertEquals((long)(bounded.getMaxLength() - (long)readCount), (long)bounded.getRemaining());
            Assertions.assertTrue((boolean)boolRef.get());
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
    }

    @Test
    void testPublicConstructors() throws IOException {
        byte[] helloWorld = "Hello World".getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream baos = new ByteArrayInputStream(helloWorld);
             BoundedInputStream inputStream = new BoundedInputStream((InputStream)baos);){
            Assertions.assertSame((Object)baos, (Object)inputStream.unwrap());
        }
        long maxCount = 2L;
        try (ByteArrayInputStream baos = new ByteArrayInputStream(helloWorld);
             BoundedInputStream inputStream = new BoundedInputStream((InputStream)baos, 2L);){
            Assertions.assertSame((Object)baos, (Object)inputStream.unwrap());
            Assertions.assertSame((Object)2L, (Object)inputStream.getMaxCount());
        }
    }

    @ParameterizedTest(name="{index} \u2014 {0}")
    @MethodSource(value={"testReadAfterClose"})
    void testReadAfterClose(String caseName, InputStream delegate, Object expectedAfterClose) throws Exception {
        BoundedInputStream bounded;
        try (BoundedInputStream in = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(delegate)).setPropagateClose(true)).get();){
            bounded = in;
        }
        ((InputStream)Mockito.verify((Object)delegate, (VerificationMode)Mockito.times((int)1))).close();
        if (expectedAfterClose instanceof Integer) {
            Assertions.assertEquals((Object)expectedAfterClose, (Object)bounded.read(), (String)(caseName + " (after close)"));
        } else if (expectedAfterClose instanceof IOException) {
            IOException actual = (IOException)Assertions.assertThrows(IOException.class, ((InputStream)bounded)::read, (String)(caseName + " (after close)"));
            Assertions.assertSame((Object)expectedAfterClose, (Object)actual, (String)(caseName + " (exception instance)"));
        } else {
            Assertions.fail((String)("Unexpected expectedAfterClose type: " + expectedAfterClose));
        }
        ((InputStream)Mockito.verify((Object)delegate, (VerificationMode)Mockito.times((int)1))).read();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{delegate});
    }

    @Test
    void testReadArray() throws Exception {
        byte[] helloWorld = "Hello World".getBytes(StandardCharsets.UTF_8);
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).get();){
            Assertions.assertTrue((boolean)bounded.markSupported());
            this.compare("limit = -1", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount(0L)).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            this.compare("limit = 0", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)helloWorld.length)).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            this.compare("limit = length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)(helloWorld.length + 1))).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            this.compare("limit > length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)(helloWorld.length - 6))).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
    }

    @Test
    void testReadSingle() throws Exception {
        int i;
        byte[] helloWorld = "Hello World".getBytes(StandardCharsets.UTF_8);
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)helloWorld.length)).get();){
            Assertions.assertTrue((boolean)bounded.markSupported());
            for (i = 0; i < helloWorld.length; ++i) {
                Assertions.assertEquals((int)helloWorld[i], (int)bounded.read(), (String)("limit = length byte[" + i + "]"));
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit = length end");
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)(helloWorld.length + 1))).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            for (i = 0; i < helloWorld.length; ++i) {
                Assertions.assertEquals((int)helloWorld[i], (int)bounded.read(), (String)("limit > length byte[" + i + "]"));
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit > length end");
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)hello.length)).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            for (i = 0; i < hello.length; ++i) {
                Assertions.assertEquals((int)hello[i], (int)bounded.read(), (String)("limit < length byte[" + i + "]"));
            }
            Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit < length end");
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
    }

    @ParameterizedTest(name="{index}: {0} -> initial remaining {2}")
    @MethodSource
    void testRemaining(String caseName, long maxCount, long expectedInitialRemaining) throws Exception {
        byte[] data = "Hello World".getBytes(StandardCharsets.UTF_8);
        try (BoundedInputStream in = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setByteArray(data)).setMaxCount(maxCount)).get();){
            Assertions.assertEquals((long)expectedInitialRemaining, (long)in.getRemaining(), (String)(caseName + " (initial)"));
            long skipped = IOUtils.skip((InputStream)in, (long)42L);
            long expectedAfterSkip = in.getMaxCount() == -1L ? expectedInitialRemaining : expectedInitialRemaining - skipped;
            Assertions.assertEquals((long)expectedAfterSkip, (long)in.getRemaining(), (String)(caseName + " (after skip)"));
        }
    }

    @Test
    void testReset() throws Exception {
        byte[] helloWorld = "Hello World".getBytes(StandardCharsets.UTF_8);
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        try (BoundedInputStream bounded = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).get();){
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = -1", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = -1", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount(0L)).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = 0", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = 0", IOUtils.EMPTY_BYTE_ARRAY, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)helloWorld.length)).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit = length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)(helloWorld.length + 1))).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit > length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit > length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
        bounded = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream(helloWorld))).setMaxCount((long)(helloWorld.length - 6))).get();
        try {
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
            bounded.reset();
            this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded));
            Assertions.assertTrue((boolean)bounded.markSupported());
        }
        finally {
            if (bounded != null) {
                bounded.close();
            }
        }
    }

    private static /* synthetic */ void lambda$testAfterReadConsumer$4(InputStream bounded) throws Throwable {
        IOUtils.consume((InputStream)bounded);
    }
}

