/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.DestroyMode;
import org.apache.commons.pool2.TrackedUse;

final class PooledTestObject
implements TrackedUse {
    private static final AtomicInteger ATOMIC_HASH = new AtomicInteger();
    private static final Instant INSTANT_0 = Instant.ofEpochMilli(0L);
    private static final Instant INSTANT_1 = Instant.ofEpochMilli(1L);
    private boolean active;
    private boolean destroyed;
    private final int hash = ATOMIC_HASH.incrementAndGet();
    private boolean abandoned;
    private boolean detached;

    PooledTestObject() {
    }

    void destroy(DestroyMode mode) {
        this.destroyed = true;
        if (mode.equals((Object)DestroyMode.ABANDONED)) {
            this.detached = true;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PooledTestObject)) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }

    public long getLastUsed() {
        if (this.abandoned) {
            return 1L;
        }
        return 0L;
    }

    public Instant getLastUsedInstant() {
        if (this.abandoned) {
            return INSTANT_1;
        }
        return INSTANT_0;
    }

    public int hashCode() {
        return this.hash;
    }

    synchronized boolean isActive() {
        return this.active;
    }

    boolean isDestroyed() {
        return this.destroyed;
    }

    boolean isDetached() {
        return this.detached;
    }

    void setAbandoned(boolean b) {
        this.abandoned = b;
    }

    synchronized void setActive(boolean b) {
        this.active = b;
    }
}

