/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.values;

import com.siemens.ct.exi.core.values.AbstractValue;
import com.siemens.ct.exi.core.values.ValueType;

public class StringValue
extends AbstractValue {
    protected char[] characters;
    protected String sValue;

    public StringValue(char[] ca) {
        super(ValueType.STRING);
        this.characters = ca;
    }

    public StringValue(String s) {
        super(ValueType.STRING);
        this.sValue = s;
    }

    private void checkCharacters() {
        if (this.characters == null) {
            this.characters = this.sValue.toCharArray();
        }
    }

    @Override
    public int getCharactersLength() {
        this.checkCharacters();
        return this.characters.length;
    }

    @Override
    public char[] getCharacters() {
        this.checkCharacters();
        return this.characters;
    }

    @Override
    public void getCharacters(char[] cbuffer, int offset) {
        this.checkCharacters();
        System.arraycopy(this.characters, 0, cbuffer, offset, this.characters.length);
    }

    @Override
    public String toString() {
        if (this.sValue == null) {
            this.sValue = new String(this.characters);
        }
        return this.sValue;
    }

    @Override
    public String toString(char[] cbuffer, int offset) {
        return this.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this == o ? true : this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

