/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.CompactQuantilesDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.DoublesUtil;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketch;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;

final class HeapCompactDoublesSketch
extends CompactQuantilesDoublesSketch {
    static final int MIN_HEAP_DOUBLES_SER_VER = 1;
    private double minItem_;
    private double maxItem_;
    private long n_;
    private int baseBufferCount_;
    private long bitPattern_;
    private double[] combinedBuffer_;

    private HeapCompactDoublesSketch(int k) {
        super(k);
    }

    static HeapCompactDoublesSketch createFromUpdateSketch(UpdatableQuantilesDoublesSketch sketch) {
        int k = sketch.getK();
        long n = sketch.getN();
        HeapCompactDoublesSketch hcds = new HeapCompactDoublesSketch(k);
        hcds.n_ = n;
        hcds.bitPattern_ = ClassicUtil.computeBitPattern(k, n);
        assert (hcds.bitPattern_ == sketch.getBitPattern());
        hcds.minItem_ = sketch.isEmpty() ? Double.NaN : sketch.getMinItem();
        hcds.maxItem_ = sketch.isEmpty() ? Double.NaN : sketch.getMaxItem();
        hcds.baseBufferCount_ = ClassicUtil.computeBaseBufferItems(k, n);
        assert (hcds.baseBufferCount_ == sketch.getBaseBufferCount());
        int retainedItems = ClassicUtil.computeRetainedItems(k, n);
        double[] combinedBuffer = new double[retainedItems];
        DoublesSketchAccessor accessor = DoublesSketchAccessor.wrap(sketch, false);
        assert (hcds.baseBufferCount_ == accessor.numItems());
        System.arraycopy(accessor.getArray(0, hcds.baseBufferCount_), 0, combinedBuffer, 0, hcds.baseBufferCount_);
        Arrays.sort(combinedBuffer, 0, hcds.baseBufferCount_);
        int combinedBufferOffset = hcds.baseBufferCount_;
        int lvl = 0;
        for (long bitPattern = hcds.bitPattern_; bitPattern > 0L; bitPattern >>>= 1) {
            if ((bitPattern & 1L) > 0L) {
                accessor.setLevel(lvl);
                System.arraycopy(accessor.getArray(0, k), 0, combinedBuffer, combinedBufferOffset, k);
                combinedBufferOffset += k;
            }
            ++lvl;
        }
        hcds.combinedBuffer_ = combinedBuffer;
        return hcds;
    }

    static HeapCompactDoublesSketch heapifyInstance(MemorySegment srcSeg) {
        long segCapBytes = srcSeg.byteSize();
        if (segCapBytes < 8L) {
            throw new SketchesArgumentException("Source MemorySegment too small: " + segCapBytes + " < 8");
        }
        int preLongs = PreambleUtil.extractPreLongs(srcSeg);
        int serVer = PreambleUtil.extractSerVer(srcSeg);
        int familyID = PreambleUtil.extractFamilyID(srcSeg);
        int flags = PreambleUtil.extractFlags(srcSeg);
        int k = PreambleUtil.extractK(srcSeg);
        boolean empty = (flags & 4) > 0;
        long n = empty ? 0L : PreambleUtil.extractN(srcSeg);
        DoublesUtil.checkDoublesSerVer(serVer, 1);
        ClassicUtil.checkHeapFlags(flags);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer(flags, serVer, preLongs);
        ClassicUtil.checkFamilyID(familyID);
        HeapCompactDoublesSketch hcds = new HeapCompactDoublesSketch(k);
        if (empty) {
            hcds.n_ = 0L;
            hcds.combinedBuffer_ = null;
            hcds.baseBufferCount_ = 0;
            hcds.bitPattern_ = 0L;
            hcds.minItem_ = Double.NaN;
            hcds.maxItem_ = Double.NaN;
            return hcds;
        }
        boolean srcIsCompact = serVer == 2 || (flags & 0xA) > 0;
        HeapUpdateDoublesSketch.checkHeapSegCapacity(k, n, srcIsCompact, serVer, segCapBytes);
        hcds.n_ = n;
        hcds.baseBufferCount_ = ClassicUtil.computeBaseBufferItems(k, n);
        hcds.bitPattern_ = ClassicUtil.computeBitPattern(k, n);
        hcds.minItem_ = srcSeg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 16L);
        hcds.maxItem_ = srcSeg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 24L);
        int totItems = ClassicUtil.computeRetainedItems(k, n);
        hcds.srcMemorySegmentToCombinedBuffer(srcSeg, serVer, srcIsCompact, totItems);
        return hcds;
    }

    @Override
    public long getN() {
        return this.n_;
    }

    @Override
    public boolean hasMemorySegment() {
        return false;
    }

    @Override
    public boolean isOffHeap() {
        return false;
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return false;
    }

    @Override
    public double getMinItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.minItem_;
    }

    @Override
    public double getMaxItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.maxItem_;
    }

    private void srcMemorySegmentToCombinedBuffer(MemorySegment srcSeg, int serVer, boolean srcIsCompact, int combBufCap) {
        int preLongs = 2;
        int extra = serVer == 1 ? 3 : 2;
        int preBytes = 2 + extra << 3;
        int k = this.getK();
        this.combinedBuffer_ = new double[combBufCap];
        if (srcIsCompact) {
            MemorySegment.copy(srcSeg, ValueLayout.JAVA_DOUBLE_UNALIGNED, preBytes, this.combinedBuffer_, 0, combBufCap);
            if (serVer == 2) {
                Arrays.sort(this.combinedBuffer_, 0, this.baseBufferCount_);
            }
        } else {
            MemorySegment.copy(srcSeg, ValueLayout.JAVA_DOUBLE_UNALIGNED, preBytes, this.combinedBuffer_, 0, this.baseBufferCount_);
            Arrays.sort(this.combinedBuffer_, 0, this.baseBufferCount_);
            int srcOffset = preBytes + (2 * k << 3);
            int dstOffset = this.baseBufferCount_;
            for (long bitPattern = this.bitPattern_; bitPattern != 0L; bitPattern >>>= 1) {
                if ((bitPattern & 1L) > 0L) {
                    MemorySegment.copy(srcSeg, ValueLayout.JAVA_DOUBLE_UNALIGNED, srcOffset, this.combinedBuffer_, dstOffset, k);
                    dstOffset += k;
                }
                srcOffset += k << 3;
            }
        }
    }

    @Override
    int getBaseBufferCount() {
        return this.baseBufferCount_;
    }

    @Override
    int getCombinedBufferItemCapacity() {
        return this.combinedBuffer_.length;
    }

    @Override
    double[] getCombinedBuffer() {
        return this.combinedBuffer_;
    }

    @Override
    long getBitPattern() {
        return this.bitPattern_;
    }

    @Override
    MemorySegment getMemorySegment() {
        return null;
    }
}

