/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator.discovery;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.druid.client.selector.DiscoverySelector;
import org.apache.druid.client.selector.Server;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;

@Deprecated
public class ServerDiscoverySelector
implements DiscoverySelector<Server> {
    private static final Logger log = new Logger(ServerDiscoverySelector.class);
    private final ServiceProvider serviceProvider;
    private final String name;
    private static final Function<ServiceInstance, Server> TO_SERVER = new Function<ServiceInstance, Server>(){

        public Server apply(final ServiceInstance instance) {
            String scheme;
            int port;
            Preconditions.checkState((instance.getPort() >= 0 || instance.getSslPort() != null && instance.getSslPort() >= 0 ? 1 : 0) != 0, (Object)"Both port and sslPort not set");
            if (instance.getSslPort() == null) {
                port = instance.getPort();
                scheme = "http";
            } else {
                port = instance.getSslPort() >= 0 ? instance.getSslPort() : instance.getPort();
                scheme = instance.getSslPort() >= 0 ? "https" : "http";
            }
            return new Server(){

                @Override
                public String getHost() {
                    return HostAndPort.fromParts((String)this.getAddress(), (int)this.getPort()).toString();
                }

                @Override
                public String getAddress() {
                    return instance.getAddress();
                }

                @Override
                public int getPort() {
                    return port;
                }

                @Override
                public String getScheme() {
                    return scheme;
                }
            };
        }
    };

    public ServerDiscoverySelector(ServiceProvider serviceProvider, String name) {
        this.serviceProvider = serviceProvider;
        this.name = name;
    }

    @Override
    @Nullable
    public Server pick() {
        ServiceInstance instance;
        try {
            instance = this.serviceProvider.getInstance();
        }
        catch (Exception e) {
            log.info((Throwable)e, "Exception getting instance for [%s]", new Object[]{this.name});
            return null;
        }
        if (instance == null) {
            log.error("No server instance found for [%s]", new Object[]{this.name});
            return null;
        }
        return (Server)TO_SERVER.apply((Object)instance);
    }

    public Collection<Server> getAll() {
        try {
            return Collections2.transform((Collection)this.serviceProvider.getAllInstances(), TO_SERVER);
        }
        catch (Exception e) {
            log.info((Throwable)e, "Unable to get all instances", new Object[0]);
            return Collections.emptyList();
        }
    }

    @LifecycleStart
    public void start() throws Exception {
        this.serviceProvider.start();
    }

    @LifecycleStop
    public void stop() throws IOException {
        this.serviceProvider.close();
    }
}

