/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.segment.cache;

import java.sql.ResultSet;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.SqlSegmentsMetadataQuery;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;

class SegmentRecord {
    private static final Logger log = new Logger(SegmentRecord.class);
    private final SegmentId segmentId;
    private final boolean isUsed;
    private final DateTime lastUpdatedTime;

    SegmentRecord(SegmentId segmentId, boolean isUsed, DateTime lastUpdatedTime) {
        this.segmentId = segmentId;
        this.isUsed = isUsed;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public SegmentId getSegmentId() {
        return this.segmentId;
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    public DateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Nullable
    static SegmentRecord fromResultSet(ResultSet r) {
        String serializedId = null;
        String dataSource = null;
        try {
            serializedId = r.getString("id");
            dataSource = r.getString("dataSource");
            DateTime lastUpdatedTime = SqlSegmentsMetadataQuery.nullAndEmptySafeDate(r.getString("used_status_last_updated"));
            SegmentId segmentId = SegmentId.tryParse((String)dataSource, (String)serializedId);
            if (segmentId == null) {
                log.error("Could not parse Segment ID[%s] of datasource[%s]", new Object[]{serializedId, dataSource});
                return null;
            }
            return new SegmentRecord(segmentId, true, lastUpdatedTime);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error occurred while reading Segment ID[%s] of datasource[%s]", new Object[]{serializedId, dataSource});
            return null;
        }
    }
}

