/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.stats;

public class CoordinatorStat {
    private final String metricName;
    private final String shortName;
    private final Level level;

    public static CoordinatorStat toDebugOnly(String shortName) {
        return new CoordinatorStat(shortName, null, Level.DEBUG);
    }

    public static CoordinatorStat toDebugAndEmit(String shortName, String metricName) {
        return new CoordinatorStat(shortName, metricName, Level.DEBUG);
    }

    public static CoordinatorStat toLogAndEmit(String shortName, String metricName, Level level) {
        return new CoordinatorStat(shortName, metricName, level);
    }

    private CoordinatorStat(String shortStatName, String metricName, Level level) {
        this.metricName = metricName;
        this.shortName = shortStatName;
        this.level = level == null ? Level.DEBUG : level;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean shouldEmit() {
        return this.metricName != null;
    }

    public String toString() {
        return this.shortName;
    }

    public static enum Level {
        DEBUG,
        INFO,
        ERROR;

    }
}

