/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.partition;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.batch.partition.CompletePartitionAnalysis;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.DimensionRangeBucketShardSpec;
import org.apache.druid.timeline.partition.PartitionBoundaries;
import org.joda.time.Interval;

public class RangePartitionAnalysis
implements CompletePartitionAnalysis<PartitionBoundaries, DimensionRangePartitionsSpec> {
    private final Map<Interval, PartitionBoundaries> intervalToPartitionBoundaries = new HashMap<Interval, PartitionBoundaries>();
    private final DimensionRangePartitionsSpec partitionsSpec;

    public RangePartitionAnalysis(DimensionRangePartitionsSpec partitionsSpec) {
        this.partitionsSpec = partitionsSpec;
    }

    @Override
    public DimensionRangePartitionsSpec getPartitionsSpec() {
        return this.partitionsSpec;
    }

    @Override
    public void updateBucket(Interval interval, PartitionBoundaries bucketAnalysis) {
        this.intervalToPartitionBoundaries.put(interval, bucketAnalysis);
    }

    @Override
    public PartitionBoundaries getBucketAnalysis(Interval interval) {
        PartitionBoundaries bucketAnalysis = this.intervalToPartitionBoundaries.get(interval);
        if (bucketAnalysis == null) {
            throw new IAE("Missing bucket analysis for interval[%s]", new Object[]{interval});
        }
        return bucketAnalysis;
    }

    @Override
    public Set<Interval> getAllIntervalsToIndex() {
        return Collections.unmodifiableSet(this.intervalToPartitionBoundaries.keySet());
    }

    private void forEach(BiConsumer<Interval, PartitionBoundaries> consumer) {
        this.intervalToPartitionBoundaries.forEach(consumer);
    }

    @Override
    public int getNumTimePartitions() {
        return this.intervalToPartitionBoundaries.size();
    }

    private static List<BucketNumberedShardSpec<?>> translatePartitionBoundaries(List<String> partitionDimensions, PartitionBoundaries partitionBoundaries) {
        if (partitionBoundaries.isEmpty()) {
            return Collections.emptyList();
        }
        return IntStream.range(0, partitionBoundaries.size() - 1).mapToObj(i -> new DimensionRangeBucketShardSpec(i, partitionDimensions, (StringTuple)partitionBoundaries.get(i), (StringTuple)partitionBoundaries.get(i + 1))).collect(Collectors.toList());
    }

    @Override
    public Map<Interval, List<BucketNumberedShardSpec<?>>> createBuckets(TaskToolbox toolbox) {
        List partitionDimensions = this.partitionsSpec.getPartitionDimensions();
        HashMap intervalToSegmentIds = Maps.newHashMapWithExpectedSize((int)this.getNumTimePartitions());
        this.forEach((interval, partitionBoundaries) -> intervalToSegmentIds.put(interval, RangePartitionAnalysis.translatePartitionBoundaries(partitionDimensions, partitionBoundaries)));
        return intervalToSegmentIds;
    }
}

