/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.common;

public class StreamPartition<PartitionIdType> {
    private final String stream;
    private final PartitionIdType partitionId;

    public StreamPartition(String stream, PartitionIdType partitionId) {
        this.stream = stream;
        this.partitionId = partitionId;
    }

    public static <PartitionType> StreamPartition<PartitionType> of(String stream, PartitionType partitionId) {
        return new StreamPartition<PartitionType>(stream, partitionId);
    }

    public String getStream() {
        return this.stream;
    }

    public PartitionIdType getPartitionId() {
        return this.partitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamPartition that = (StreamPartition)o;
        if (this.stream != null ? !this.stream.equals(that.stream) : that.stream != null) {
            return false;
        }
        return !(this.partitionId == null ? that.partitionId != null : !this.partitionId.equals(that.partitionId));
    }

    public int hashCode() {
        int result = this.stream != null ? this.stream.hashCode() : 0;
        result = 31 * result + (this.partitionId != null ? this.partitionId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StreamPartition{stream='" + this.stream + "', partitionId='" + this.partitionId + "'}";
    }
}

