/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.logger.Logger;

@NotThreadSafe
public class LazyResourceHolder<T>
implements ResourceHolder<T> {
    private static final Logger log = new Logger(LazyResourceHolder.class);
    private final Supplier<ResourceHolder<T>> supplier;
    private ResourceHolder<T> supplied = null;

    public LazyResourceHolder(Supplier<ResourceHolder<T>> supplier) {
        this.supplier = (Supplier)Preconditions.checkNotNull(supplier, (Object)"supplier");
    }

    public T get() {
        if (this.supplied == null) {
            this.supplied = this.supplier.get();
        }
        return (T)this.supplied.get();
    }

    public void close() {
        if (this.supplied != null) {
            try {
                this.supplied.close();
            }
            catch (Throwable e) {
                log.noStackTrace().warn(e, "Exception encountered while closing resource: %s", new Object[]{this.supplied.get()});
            }
            finally {
                this.supplied = null;
            }
        }
    }
}

