/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.orc;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.druid.data.input.orc.OrcHadoopInputRowParser;
import org.apache.druid.data.input.orc.OrcInputFormat;
import org.apache.druid.data.input.orc.OrcParseSpec;
import org.apache.druid.data.input.orc.guice.Orc;
import org.apache.druid.initialization.DruidModule;
import org.apache.hadoop.conf.Configuration;

public class OrcExtensionsModule
implements DruidModule {
    private Properties props = null;

    @Inject
    public void setProperties(Properties props) {
        this.props = props;
    }

    public List<? extends Module> getJacksonModules() {
        return Collections.singletonList(new SimpleModule("OrcInputRowParserModule").registerSubtypes(new NamedType[]{new NamedType(OrcHadoopInputRowParser.class, "orc"), new NamedType(OrcParseSpec.class, "orc"), new NamedType(OrcInputFormat.class, "orc")}));
    }

    public void configure(Binder binder) {
        Configuration conf = new Configuration();
        conf.setClassLoader(this.getClass().getClassLoader());
        if (this.props != null) {
            for (String propName : this.props.stringPropertyNames()) {
                if (!propName.startsWith("hadoop.")) continue;
                conf.set(propName.substring("hadoop.".length()), this.props.getProperty(propName));
            }
        }
        binder.bind(Configuration.class).annotatedWith(Orc.class).toInstance((Object)conf);
    }
}

