/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.inject.Inject;
import java.util.Optional;
import java.util.UUID;
import org.apache.druid.common.exception.ErrorResponseTransformStrategy;
import org.apache.druid.common.exception.NoErrorResponseTransformStrategy;
import org.apache.druid.common.exception.SanitizableException;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.security.ForbiddenException;

class ErrorHandler {
    private final ErrorResponseTransformStrategy errorResponseTransformStrategy;
    private static final Logger log = new Logger(ErrorHandler.class);

    @Inject
    ErrorHandler(ServerConfig serverConfig) {
        this.errorResponseTransformStrategy = serverConfig.getErrorResponseTransformStrategy();
    }

    public <T extends Throwable> RuntimeException sanitize(T error) {
        if (error instanceof QueryException) {
            return (QueryException)this.errorResponseTransformStrategy.transformIfNeeded((SanitizableException)((QueryException)error));
        }
        if (error instanceof ForbiddenException) {
            return (ForbiddenException)((Object)this.errorResponseTransformStrategy.transformIfNeeded((SanitizableException)((ForbiddenException)error)));
        }
        if (error instanceof ISE) {
            return (ISE)this.errorResponseTransformStrategy.transformIfNeeded((SanitizableException)((ISE)error));
        }
        if (error instanceof UOE) {
            return (UOE)this.errorResponseTransformStrategy.transformIfNeeded((SanitizableException)((UOE)error));
        }
        if (error instanceof SanitizableException) {
            return new RuntimeException(this.errorResponseTransformStrategy.transformIfNeeded((SanitizableException)error));
        }
        if (error instanceof RuntimeException && error.getCause() instanceof SanitizableException) {
            return new RuntimeException(this.errorResponseTransformStrategy.transformIfNeeded((SanitizableException)error.getCause()));
        }
        if (error instanceof DruidException) {
            String errorId = UUID.randomUUID().toString();
            Optional transformedException = this.errorResponseTransformStrategy.maybeTransform((DruidException)error, Optional.of(errorId));
            if (transformedException.isPresent()) {
                log.error(error, StringUtils.format((String)"External Error ID: [%s]", (Object[])new Object[]{errorId}), new Object[0]);
            }
            QueryInterruptedException wrappedError = QueryInterruptedException.wrapIfNeeded((Throwable)transformedException.orElse((Exception)error));
            return (QueryException)this.errorResponseTransformStrategy.transformIfNeeded((SanitizableException)wrappedError);
        }
        QueryInterruptedException wrappedError = QueryInterruptedException.wrapIfNeeded(error);
        return (QueryException)this.errorResponseTransformStrategy.transformIfNeeded((SanitizableException)wrappedError);
    }

    public boolean hasAffectingErrorResponseTransformStrategy() {
        return !this.errorResponseTransformStrategy.equals(NoErrorResponseTransformStrategy.INSTANCE);
    }
}

