/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.DruidConvention;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;

public class DruidUnionRel
extends DruidRel<DruidUnionRel> {
    private final RelDataType rowType;
    private final List<RelNode> rels;
    private final int limit;

    private DruidUnionRel(RelOptCluster cluster, RelTraitSet traitSet, PlannerContext plannerContext, RelDataType rowType, List<RelNode> rels, int limit) {
        super(cluster, traitSet, plannerContext);
        this.rowType = rowType;
        this.rels = rels;
        this.limit = limit;
    }

    public static DruidUnionRel create(PlannerContext plannerContext, RelDataType rowType, List<RelNode> rels, int limit) {
        Preconditions.checkState((rels.size() > 0 ? 1 : 0) != 0, (Object)"rels must be nonempty");
        return new DruidUnionRel(rels.get(0).getCluster(), rels.get(0).getTraitSet(), plannerContext, rowType, new ArrayList<RelNode>(rels), limit);
    }

    @Override
    @Nullable
    public PartialDruidQuery getPartialDruidQuery() {
        return null;
    }

    @Override
    public QueryResponse<Object[]> runQuery() {
        if (this.limit == 0) {
            return new QueryResponse(Sequences.empty(), ResponseContext.createEmpty());
        }
        QueryResponse<Object[]> queryResponse = ((DruidRel)this.rels.get(0)).runQuery();
        List<Sequence> firstAsList = Collections.singletonList(queryResponse.getResults());
        FluentIterable theRestTransformed = FluentIterable.from(this.rels.subList(1, this.rels.size())).transform(rel -> {
            QueryResponse<Object[]> response = ((DruidRel)((Object)rel)).runQuery();
            ResponseContext nextContext = response.getResponseContext();
            List uncoveredIntervals = nextContext.getUncoveredIntervals();
            if (uncoveredIntervals == null || uncoveredIntervals.isEmpty()) {
                return response.getResults();
            }
            throw new ISE("uncoveredIntervals[%s] existed on a sub-query of a union, incomplete data, failing", new Object[]{uncoveredIntervals});
        });
        Iterable recombinedSequences = Iterables.concat(firstAsList, (Iterable)theRestTransformed);
        Sequence returnSequence = Sequences.concat((Iterable)recombinedSequences);
        return new QueryResponse(this.limit > 0 ? returnSequence.limit((long)this.limit) : returnSequence, queryResponse.getResponseContext());
    }

    @Override
    public DruidUnionRel withPartialQuery(PartialDruidQuery newQueryBuilder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DruidQuery toDruidQuery(boolean finalizeAggregations) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DruidQuery toDruidQueryForExplaining() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DruidUnionRel asDruidConvention() {
        return new DruidUnionRel(this.getCluster(), this.getTraitSet().replace((RelTrait)DruidConvention.instance()), this.getPlannerContext(), this.rowType, this.rels.stream().map(rel -> RelOptRule.convert((RelNode)rel, (RelTrait)DruidConvention.instance())).collect(Collectors.toList()), this.limit);
    }

    public List<RelNode> getInputs() {
        return this.rels;
    }

    public void replaceInput(int ordinalInParent, RelNode p) {
        this.rels.set(ordinalInParent, p);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DruidUnionRel(this.getCluster(), traitSet, this.getPlannerContext(), this.rowType, inputs, this.limit);
    }

    @Override
    public Set<String> getDataSourceNames() {
        return this.rels.stream().flatMap(rel -> ((DruidRel)((Object)rel)).getDataSourceNames().stream()).collect(Collectors.toSet());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        for (int i = 0; i < this.rels.size(); ++i) {
            pw.input(StringUtils.format((String)"input#%d", (Object[])new Object[]{i}), this.rels.get(i));
        }
        return pw.item("limit", (Object)this.limit);
    }

    protected RelDataType deriveRowType() {
        return this.rowType;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeCost(1.0, 0.0, 0.0);
    }

    public int getLimit() {
        return this.limit;
    }
}

