/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.guava;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.ISE;

public class FutureUtils {
    public static <T> T get(ListenableFuture<T> future, boolean cancelIfInterrupted) throws InterruptedException, ExecutionException {
        try {
            return (T)future.get();
        }
        catch (InterruptedException e) {
            if (cancelIfInterrupted) {
                future.cancel(true);
            }
            throw e;
        }
    }

    public static <T> T getUnchecked(ListenableFuture<T> future, boolean cancelIfInterrupted) {
        try {
            return FutureUtils.get(future, cancelIfInterrupted);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static <T> T getUncheckedImmediately(ListenableFuture<T> future) {
        if (future.isDone()) {
            return FutureUtils.getUnchecked(future, false);
        }
        if (future.isCancelled()) {
            throw new ISE("Canceled", new Object[0]);
        }
        throw new ISE("Not yet done", new Object[0]);
    }

    public static <T, R> ListenableFuture<R> transform(ListenableFuture<T> future, Function<T, R> fn) {
        return Futures.transform(future, fn::apply, (Executor)MoreExecutors.directExecutor());
    }

    public static <T, R> ListenableFuture<R> transformAsync(ListenableFuture<T> future, AsyncFunction<T, R> fn) {
        return Futures.transformAsync(future, fn, (Executor)MoreExecutors.directExecutor());
    }

    public static <T> ListenableFuture<List<Either<Throwable, T>>> coalesce(List<ListenableFuture<T>> futures) {
        return FutureUtils.transform(Futures.successfulAsList(futures), values -> {
            ArrayList<Either<Object, Object>> eithers = new ArrayList<Either<Object, Object>>();
            for (int i = 0; i < values.size(); ++i) {
                ListenableFuture future = (ListenableFuture)futures.get(i);
                Object value = values.get(i);
                if (value != null) {
                    eithers.add(Either.value(value));
                    continue;
                }
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    eithers.add(Either.error(e.getCause()));
                    continue;
                }
                catch (Throwable e) {
                    eithers.add(Either.error(e));
                    continue;
                }
                eithers.add(Either.value(null));
            }
            return eithers;
        });
    }

    public static <T> ListenableFuture<T> futureWithBaggage(ListenableFuture<T> future, final Closeable baggage) {
        final SettableFuture retVal = SettableFuture.create();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(@Nullable T result) {
                try {
                    baggage.close();
                }
                catch (Exception e) {
                    retVal.setException((Throwable)e);
                    return;
                }
                retVal.set(result);
            }

            public void onFailure(Throwable e) {
                try {
                    baggage.close();
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                retVal.setException(e);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return retVal;
    }
}

