/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.processor.MultiColumnSelectorFactory;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.read.FrameReaderUtils;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;

public class FrameChannelHashPartitioner
implements FrameProcessor<Long> {
    private static final String PARTITION_COLUMN_NAME = StringUtils.format("%s_part", "___druid");
    private static final long HASH_SEED = 0L;
    private final List<ReadableFrameChannel> inputChannels;
    private final List<WritableFrameChannel> outputChannels;
    private final FrameReader frameReader;
    private final int keyFieldCount;
    private final FrameWriterFactory frameWriterFactory;
    private final IntSet awaitSet;
    private Cursor cursor;
    private LongSupplier cursorRowPartitionNumberSupplier;
    private long rowsWritten;
    private final MultiColumnSelectorFactory cursorColumnSelectorFactory;
    private final FrameWriter[] frameWriters;

    public FrameChannelHashPartitioner(List<ReadableFrameChannel> inputChannels, List<WritableFrameChannel> outputChannels, FrameReader frameReader, int keyFieldCount, FrameWriterFactory frameWriterFactory) {
        this.inputChannels = inputChannels;
        this.outputChannels = outputChannels;
        this.frameReader = frameReader;
        this.keyFieldCount = keyFieldCount;
        this.frameWriterFactory = frameWriterFactory;
        this.awaitSet = FrameProcessors.rangeSet(inputChannels.size());
        this.frameWriters = new FrameWriter[outputChannels.size()];
        this.cursorColumnSelectorFactory = new MultiColumnSelectorFactory(Collections.singletonList(() -> this.cursor.getColumnSelectorFactory()), frameReader.signature()).withRowMemoryAndSignatureColumns();
        if (!frameReader.signature().equals(frameWriterFactory.signature())) {
            throw new IAE("Input signature does not match output signature", new Object[0]);
        }
    }

    @Override
    public List<ReadableFrameChannel> inputChannels() {
        return this.inputChannels;
    }

    @Override
    public List<WritableFrameChannel> outputChannels() {
        return this.outputChannels;
    }

    @Override
    public ReturnOrAwait<Long> runIncrementally(IntSet readableInputs) throws IOException {
        if (this.cursor == null) {
            this.readNextFrame(readableInputs);
        }
        if (this.cursor != null) {
            this.processCursor();
        }
        if (this.cursor != null) {
            return ReturnOrAwait.runAgain();
        }
        if (this.awaitSet.isEmpty()) {
            this.flushFrameWriters();
            return ReturnOrAwait.returnObject(this.rowsWritten);
        }
        return ReturnOrAwait.awaitAny(this.awaitSet);
    }

    @Override
    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), this.frameWriters);
    }

    private void processCursor() throws IOException {
        assert (this.cursor != null);
        while (!this.cursor.isDone()) {
            int partition = (int)this.cursorRowPartitionNumberSupplier.getAsLong();
            FrameWriter frameWriter = this.getOrCreateFrameWriter(partition);
            if (frameWriter.addSelection()) {
                this.cursor.advance();
                continue;
            }
            if (frameWriter.getNumRows() > 0) {
                this.writeFrame(partition);
                return;
            }
            throw new FrameRowTooLargeException(this.frameWriterFactory.allocatorCapacity());
        }
        this.cursor = null;
        this.cursorRowPartitionNumberSupplier = null;
    }

    private void readNextFrame(IntSet readableInputs) {
        int channelNumber;
        ReadableFrameChannel channel;
        if (this.cursor != null) {
            throw new ISE("Already reading a frame", new Object[0]);
        }
        IntAVLTreeSet readySet = new IntAVLTreeSet((IntCollection)readableInputs);
        IntIterator intIterator = readableInputs.iterator();
        while (intIterator.hasNext()) {
            int channelNumber2 = (Integer)intIterator.next();
            ReadableFrameChannel channel2 = this.inputChannels.get(channelNumber2);
            if (!channel2.isFinished()) continue;
            this.awaitSet.remove(channelNumber2);
            readySet.remove(channelNumber2);
        }
        if (!readySet.isEmpty() && !(channel = this.inputChannels.get(channelNumber = FrameProcessors.selectRandom((IntSet)readySet))).isFinished()) {
            Frame frame = channel.read().ensureRowBased();
            HashPartitionVirtualColumn hashPartitionVirtualColumn = new HashPartitionVirtualColumn(PARTITION_COLUMN_NAME, this.frameReader, this.frameWriterFactory.frameType(), this.keyFieldCount, this.outputChannels.size());
            this.cursor = FrameProcessors.makeCursor(frame, this.frameReader, VirtualColumns.create(Collections.singletonList(hashPartitionVirtualColumn)));
            this.cursorRowPartitionNumberSupplier = this.cursor.getColumnSelectorFactory().makeColumnValueSelector(PARTITION_COLUMN_NAME)::getLong;
        }
    }

    private void flushFrameWriters() throws IOException {
        for (int i = 0; i < this.frameWriters.length; ++i) {
            if (this.frameWriters[i] == null) continue;
            this.writeFrame(i);
        }
    }

    private FrameWriter getOrCreateFrameWriter(int partition) {
        if (this.frameWriters[partition] == null) {
            this.frameWriters[partition] = this.frameWriterFactory.newFrameWriter(this.cursorColumnSelectorFactory);
        }
        return this.frameWriters[partition];
    }

    private void writeFrame(int partition) throws IOException {
        if (this.frameWriters[partition] == null || this.frameWriters[partition].getNumRows() == 0) {
            throw new ISE("Nothing to write for partition [%,d]", partition);
        }
        Frame frame = Frame.wrap(this.frameWriters[partition].toByteArray());
        this.outputChannels.get(partition).write(frame);
        this.frameWriters[partition].close();
        this.frameWriters[partition] = null;
        this.rowsWritten += (long)frame.numRows();
    }

    private static class HashPartitionVirtualColumn
    implements VirtualColumn {
        private final String name;
        private final FrameReader frameReader;
        private final FrameType outputFrameType;
        private final int keyFieldCount;
        private final int partitionCount;

        public HashPartitionVirtualColumn(String name, FrameReader frameReader, FrameType outputFrameType, int keyFieldCount, int partitionCount) {
            this.name = name;
            this.frameReader = frameReader;
            this.outputFrameType = outputFrameType;
            this.keyFieldCount = keyFieldCount;
            this.partitionCount = partitionCount;
        }

        @Override
        public String getOutputName() {
            return this.name;
        }

        @Override
        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
            final Supplier<MemoryRange<Memory>> rowMemorySupplier = FrameReaderUtils.makeRowMemorySupplier(factory, this.outputFrameType, this.frameReader.signature());
            final int frameFieldCount = this.frameReader.signature().size();
            return new LongColumnSelector(){

                @Override
                public long getLong() {
                    if (keyFieldCount == 0) {
                        return 0L;
                    }
                    MemoryRange rowMemoryRange = (MemoryRange)rowMemorySupplier.get();
                    if (rowMemoryRange == null) {
                        throw DruidException.defensive("Unexpectedly null row memory", new Object[0]);
                    }
                    Object memory = rowMemoryRange.memory();
                    long keyStartPosition = 4L * (long)frameFieldCount;
                    long keyEndPosition = memory.getInt(rowMemoryRange.start() + 4L * (long)(keyFieldCount - 1));
                    int keyLength = (int)(keyEndPosition - keyStartPosition);
                    long hash = memory.xxHash64(rowMemoryRange.start() + keyStartPosition, (long)keyLength, 0L);
                    return Math.abs(hash % (long)partitionCount);
                }

                @Override
                public boolean isNull() {
                    return false;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }
            };
        }

        @Override
        public ColumnCapabilities capabilities(String columnName) {
            return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(ColumnType.LONG).setHasNulls(false);
        }

        @Override
        public List<String> requiredColumns() {
            return ImmutableList.of((Object)"___druid_frame_type", (Object)"___druid_frame_row_mem", (Object)"___druid_frame_row_signature");
        }

        @Override
        public boolean usesDotNotation() {
            return false;
        }

        @Override
        public byte[] getCacheKey() {
            throw new UnsupportedOperationException();
        }
    }
}

