/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public abstract class BivariateFunctionVectorProcessor<TLeftInput, TRightInput, TOutput>
implements ExprVectorProcessor<TOutput> {
    private final ExpressionType outputType;
    private final ExprVectorProcessor<TLeftInput> left;
    private final ExprVectorProcessor<TRightInput> right;

    public BivariateFunctionVectorProcessor(ExpressionType outputType, ExprVectorProcessor<TLeftInput> left, ExprVectorProcessor<TRightInput> right) {
        this.outputType = outputType;
        this.left = left;
        this.right = right;
    }

    @Override
    public ExprEvalVector<TOutput> evalVector(Expr.VectorInputBinding bindings) {
        ExprEvalVector<TLeftInput> lhs = this.left.evalVector(bindings);
        ExprEvalVector<TRightInput> rhs = this.right.evalVector(bindings);
        TLeftInput leftValues = lhs.values();
        TRightInput rightValues = rhs.values();
        boolean[] leftNulls = this.outputType.isNumeric() ? lhs.getNullVector() : null;
        boolean[] rightNulls = this.outputType.isNumeric() ? rhs.getNullVector() : null;
        for (int i = 0; i < bindings.getCurrentVectorSize(); ++i) {
            this.processIndex(leftValues, leftNulls, rightValues, rightNulls, i);
        }
        return this.asEval();
    }

    public abstract void processIndex(TLeftInput var1, @Nullable boolean[] var2, TRightInput var3, @Nullable boolean[] var4, int var5);

    public abstract ExprEvalVector<TOutput> asEval();

    @Override
    public ExpressionType getOutputType() {
        return this.outputType;
    }

    @Override
    public int maxVectorSize() {
        return this.left.maxVectorSize();
    }
}

