/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.MergeIterable;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.AbstractPrioritizedQueryRunnerCallable;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.context.ResponseContext;

public class ChainedExecutionQueryRunner<T>
implements QueryRunner<T> {
    private static final Logger log = new Logger(ChainedExecutionQueryRunner.class);
    private final QueryProcessingPool queryProcessingPool;
    private final Iterable<QueryRunner<T>> queryables;
    private final QueryWatcher queryWatcher;

    public ChainedExecutionQueryRunner(QueryProcessingPool queryProcessingPool, QueryWatcher queryWatcher, Iterable<QueryRunner<T>> queryables) {
        this.queryProcessingPool = queryProcessingPool;
        this.queryables = Iterables.unmodifiableIterable(queryables);
        this.queryWatcher = queryWatcher;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, final ResponseContext responseContext) {
        final Query<T> query = queryPlus.getQuery();
        final int priority = query.context().getPriority();
        final Ordering<T> ordering = query.getResultOrdering();
        final QueryPlus<T> threadSafeQueryPlus = queryPlus.withoutThreadUnsafeState();
        final QueryContext context = query.context();
        final boolean usePerSegmentTimeout = context.usePerSegmentTimeout();
        final long perSegmentTimeout = context.getPerSegmentTimeout();
        return new BaseSequence(new BaseSequence.IteratorMaker<T, Iterator<T>>(){

            @Override
            public Iterator<T> make() {
                ArrayList futures = Lists.newArrayList((Iterable)Iterables.transform(ChainedExecutionQueryRunner.this.queryables, input -> {
                    if (input == null) {
                        throw new ISE("Null queryRunner! Looks to be some segment unmapping action happening", new Object[0]);
                    }
                    AbstractPrioritizedQueryRunnerCallable callable = new AbstractPrioritizedQueryRunnerCallable<Iterable<T>, T>(priority, (QueryRunner)input, (QueryRunner)input, threadSafeQueryPlus, responseContext, query){
                        final /* synthetic */ QueryRunner val$input;
                        final /* synthetic */ QueryPlus val$threadSafeQueryPlus;
                        final /* synthetic */ ResponseContext val$responseContext;
                        final /* synthetic */ Query val$query;
                        {
                            this.val$input = queryRunner;
                            this.val$threadSafeQueryPlus = queryPlus;
                            this.val$responseContext = responseContext;
                            this.val$query = query;
                            super(priority, runner);
                        }

                        @Override
                        public Iterable<T> call() {
                            try {
                                Sequence result = this.val$input.run(this.val$threadSafeQueryPlus, this.val$responseContext);
                                if (result == null) {
                                    throw new ISE("Got a null result! Segments are missing!", new Object[0]);
                                }
                                List retVal = result.toList();
                                if (retVal == null) {
                                    throw new ISE("Got a null list of results", new Object[0]);
                                }
                                return retVal;
                            }
                            catch (QueryInterruptedException e) {
                                throw new RuntimeException(e);
                            }
                            catch (QueryTimeoutException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                if (this.val$query.context().isDebug()) {
                                    log.error(e, "Exception with one of the sequences!", new Object[0]);
                                } else {
                                    log.noStackTrace().error(e, "Exception with one of the sequences!", new Object[0]);
                                }
                                Throwables.throwIfUnchecked((Throwable)e);
                                throw new RuntimeException(e);
                            }
                        }
                    };
                    if (usePerSegmentTimeout) {
                        return ChainedExecutionQueryRunner.this.queryProcessingPool.submitRunnerTask(callable, perSegmentTimeout, TimeUnit.MILLISECONDS);
                    }
                    return ChainedExecutionQueryRunner.this.queryProcessingPool.submitRunnerTask(callable);
                }));
                ListenableFuture future = Futures.allAsList((Iterable)futures);
                ChainedExecutionQueryRunner.this.queryWatcher.registerQueryFuture(query, future);
                try {
                    return new MergeIterable(context.hasTimeout() ? (Iterable)future.get(context.getTimeout(), TimeUnit.MILLISECONDS) : (Iterable)future.get(), ordering.nullsFirst()).iterator();
                }
                catch (InterruptedException | CancellationException e) {
                    log.noStackTrace().warn(e, "Query interrupted, cancelling pending results for query [%s]", query.getId());
                    GuavaUtils.cancelAll(true, future, futures);
                    throw new QueryInterruptedException(e);
                }
                catch (TimeoutException | QueryTimeoutException e) {
                    log.noStackTrace().warn(e, "Query timeout, cancelling pending results for query [%s]", query.getId());
                    GuavaUtils.cancelAll(true, future, futures);
                    throw new QueryTimeoutException(StringUtils.nonStrictFormat("Query [%s] timed out", query.getId()));
                }
                catch (ExecutionException e) {
                    log.noStackTrace().warn(e, "Query error, cancelling pending results for query [%s]", query.getId());
                    GuavaUtils.cancelAll(true, future, futures);
                    Throwable cause = e.getCause();
                    if (cause instanceof TimeoutException) {
                        throw new QueryTimeoutException(StringUtils.nonStrictFormat("Query timeout, cancelling pending results for query [%s]. Per-segment timeout exceeded.", query.getId()));
                    }
                    Throwables.throwIfUnchecked((Throwable)cause);
                    throw new RuntimeException(cause);
                }
            }

            @Override
            public void cleanup(Iterator<T> tIterator) {
            }
        });
    }
}

