/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatMinVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector selector;

    public FloatMinVectorAggregator(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putFloat(position, Float.POSITIVE_INFINITY);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        float[] vector = this.selector.getFloatVector();
        float min = buf.getFloat(position);
        for (int i = startRow; i < endRow; ++i) {
            min = Math.min(min, vector[i]);
        }
        buf.putFloat(position, min);
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        float[] vector = this.selector.getFloatVector();
        for (int i = 0; i < numRows; ++i) {
            int position = positions[i] + positionOffset;
            buf.putFloat(position, Math.min(buf.getFloat(position), vector[rows != null ? rows[i] : i]));
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return Float.valueOf(buf.getFloat(position));
    }

    @Override
    public void close() {
    }
}

