/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.schemarepo.DelegatingRepository;
import org.schemarepo.Repository;
import org.schemarepo.RepositoryCache;
import org.schemarepo.Subject;
import org.schemarepo.SubjectConfig;

public class CacheRepository
extends DelegatingRepository {
    private final RepositoryCache cache;

    @Inject
    public CacheRepository(Repository repo, RepositoryCache cache) {
        super(repo);
        this.cache = cache;
    }

    @Override
    public Subject register(String subjectName, SubjectConfig config) {
        Subject s = this.cache.lookup(subjectName);
        if (s == null) {
            return this.cache.add(this.repo.register(subjectName, config));
        }
        return s;
    }

    @Override
    public Subject lookup(String subjectName) {
        Subject s = this.cache.lookup(subjectName);
        if (s == null) {
            return this.cache.add(this.repo.lookup(subjectName));
        }
        return s;
    }

    @Override
    public Iterable<Subject> subjects() {
        Iterable<Subject> subs = this.repo.subjects();
        for (Subject s : subs) {
            this.cache.add(s);
        }
        return subs;
    }

    @Override
    protected Map<String, String> exposeConfiguration() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(super.exposeConfiguration());
        properties.put("CACHE", this.repo.toString());
        return properties;
    }
}

