/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.schemarepo.SchemaEntry;
import org.schemarepo.Subject;
import org.schemarepo.SubjectConfig;

public final class RepositoryUtil {
    private RepositoryUtil() {
    }

    public static String subjectsToString(Iterable<Subject> subjects) {
        StringBuilder sb = new StringBuilder();
        for (Subject s : subjects) {
            sb.append(s.getName()).append("\n");
        }
        return sb.toString();
    }

    public static Iterable<String> subjectNamesFromString(String str) {
        ArrayList<String> subjects = new ArrayList<String>();
        if (str != null && !str.isEmpty()) {
            String[] strs;
            for (String s : strs = str.split("\n")) {
                subjects.add(s);
            }
        }
        return subjects;
    }

    public static String schemasToString(Iterable<SchemaEntry> allEntries) {
        StringBuilder sb = new StringBuilder();
        boolean scheamWithNewLine = false;
        for (SchemaEntry s : allEntries) {
            if (s.getSchema().contains("\n")) {
                scheamWithNewLine = true;
            }
            sb.append(s.toString()).append("\n");
        }
        if (scheamWithNewLine) {
            return "ERROR: One of the schemas for this topic contains a new line and won't be parse-able properly. Please use a non-plain text format instead (e.g.: JSON).\n" + sb;
        }
        return sb.toString();
    }

    public static Iterable<SchemaEntry> schemasFromString(String str) {
        ArrayList<SchemaEntry> schemas = new ArrayList<SchemaEntry>();
        if (str != null && !str.isEmpty()) {
            String[] strs;
            for (String s : strs = str.split("\n")) {
                schemas.add(new SchemaEntry(s));
            }
        }
        return schemas;
    }

    public static void validateSchemaOrSubject(String val) {
        if (null == val || val.isEmpty()) {
            throw new IllegalArgumentException("Provided string is null or empty: '" + val + "'");
        }
    }

    public static SubjectConfig configFromProperties(Properties props) {
        HashMap<String, String> propData = new HashMap<String, String>();
        for (String key : props.stringPropertyNames()) {
            propData.put(key, props.getProperty(key));
        }
        return new SubjectConfig.Builder().set(propData).build();
    }

    public static SubjectConfig safeConfig(SubjectConfig config) {
        if (null == config) {
            return SubjectConfig.emptyConfig();
        }
        return config;
    }

    public static List<String> commaSplit(String toSplit) {
        if (toSplit == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : toSplit.split(",")) {
            if ((s = s.trim()).isEmpty()) continue;
            list.add(s);
        }
        return list;
    }

    public static String commaJoin(Collection<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            sb.append(s).append(',');
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    public static String propertiesToString(Properties props, String comment) {
        StringWriter writer = new StringWriter();
        try {
            props.store(writer, comment);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }
}

