/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.client.ConfiguredRMFailoverProxyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AutoRefreshRMFailoverProxyProvider<T>
extends ConfiguredRMFailoverProxyProvider<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AutoRefreshRMFailoverProxyProvider.class);

    @Override
    public synchronized void performFailover(T currentProxy) {
        RPC.stopProxy(currentProxy);
        HashSet<String> rmIds = new HashSet<String>();
        for (Map.Entry entry : this.proxies.entrySet()) {
            Object proxy = entry.getValue();
            if (!proxy.equals(currentProxy)) continue;
            String rmId = (String)entry.getKey();
            rmIds.add(rmId);
        }
        for (String rmId : rmIds) {
            this.proxies.remove(rmId);
        }
        super.performFailover(currentProxy);
    }
}

