/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateSnapshotRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateSnapshotRequest> {
    private String description;
    private String outpostArn;
    private String volumeId;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public CreateSnapshotRequest() {
    }

    public CreateSnapshotRequest(String volumeId, String description) {
        this.setVolumeId(volumeId);
        this.setDescription(description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateSnapshotRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setOutpostArn(String outpostArn) {
        this.outpostArn = outpostArn;
    }

    public String getOutpostArn() {
        return this.outpostArn;
    }

    public CreateSnapshotRequest withOutpostArn(String outpostArn) {
        this.setOutpostArn(outpostArn);
        return this;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public CreateSnapshotRequest withVolumeId(String volumeId) {
        this.setVolumeId(volumeId);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public CreateSnapshotRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateSnapshotRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    @Override
    public Request<CreateSnapshotRequest> getDryRunRequest() {
        Request<CreateSnapshotRequest> request = new CreateSnapshotRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getOutpostArn() != null) {
            sb.append("OutpostArn: ").append(this.getOutpostArn()).append(",");
        }
        if (this.getVolumeId() != null) {
            sb.append("VolumeId: ").append(this.getVolumeId()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotRequest)) {
            return false;
        }
        CreateSnapshotRequest other = (CreateSnapshotRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getOutpostArn() == null ^ this.getOutpostArn() == null) {
            return false;
        }
        if (other.getOutpostArn() != null && !other.getOutpostArn().equals(this.getOutpostArn())) {
            return false;
        }
        if (other.getVolumeId() == null ^ this.getVolumeId() == null) {
            return false;
        }
        if (other.getVolumeId() != null && !other.getVolumeId().equals(this.getVolumeId())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getOutpostArn() == null ? 0 : this.getOutpostArn().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeId() == null ? 0 : this.getVolumeId().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    public CreateSnapshotRequest clone() {
        return (CreateSnapshotRequest)super.clone();
    }
}

