/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.InstanceEventWindowTimeRangeRequest;
import com.amazonaws.services.ec2.model.ModifyInstanceEventWindowRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyInstanceEventWindowRequestMarshaller
implements Marshaller<Request<ModifyInstanceEventWindowRequest>, ModifyInstanceEventWindowRequest> {
    public Request<ModifyInstanceEventWindowRequest> marshall(ModifyInstanceEventWindowRequest modifyInstanceEventWindowRequest) {
        SdkInternalList modifyInstanceEventWindowRequestTimeRangesList;
        if (modifyInstanceEventWindowRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyInstanceEventWindowRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyInstanceEventWindow");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyInstanceEventWindowRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)modifyInstanceEventWindowRequest.getName()));
        }
        if (modifyInstanceEventWindowRequest.getInstanceEventWindowId() != null) {
            request.addParameter("InstanceEventWindowId", StringUtils.fromString((String)modifyInstanceEventWindowRequest.getInstanceEventWindowId()));
        }
        if (!(modifyInstanceEventWindowRequestTimeRangesList = (SdkInternalList)modifyInstanceEventWindowRequest.getTimeRanges()).isEmpty() || !modifyInstanceEventWindowRequestTimeRangesList.isAutoConstruct()) {
            int timeRangesListIndex = 1;
            for (InstanceEventWindowTimeRangeRequest modifyInstanceEventWindowRequestTimeRangesListValue : modifyInstanceEventWindowRequestTimeRangesList) {
                if (modifyInstanceEventWindowRequestTimeRangesListValue.getStartWeekDay() != null) {
                    request.addParameter("TimeRange." + timeRangesListIndex + ".StartWeekDay", StringUtils.fromString((String)modifyInstanceEventWindowRequestTimeRangesListValue.getStartWeekDay()));
                }
                if (modifyInstanceEventWindowRequestTimeRangesListValue.getStartHour() != null) {
                    request.addParameter("TimeRange." + timeRangesListIndex + ".StartHour", StringUtils.fromInteger((Integer)modifyInstanceEventWindowRequestTimeRangesListValue.getStartHour()));
                }
                if (modifyInstanceEventWindowRequestTimeRangesListValue.getEndWeekDay() != null) {
                    request.addParameter("TimeRange." + timeRangesListIndex + ".EndWeekDay", StringUtils.fromString((String)modifyInstanceEventWindowRequestTimeRangesListValue.getEndWeekDay()));
                }
                if (modifyInstanceEventWindowRequestTimeRangesListValue.getEndHour() != null) {
                    request.addParameter("TimeRange." + timeRangesListIndex + ".EndHour", StringUtils.fromInteger((Integer)modifyInstanceEventWindowRequestTimeRangesListValue.getEndHour()));
                }
                ++timeRangesListIndex;
            }
        }
        if (modifyInstanceEventWindowRequest.getCronExpression() != null) {
            request.addParameter("CronExpression", StringUtils.fromString((String)modifyInstanceEventWindowRequest.getCronExpression()));
        }
        return request;
    }
}

