/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.domain;

import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanBalanceChangedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanChargePaymentPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanChargePaymentPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanCreditBalanceRefundPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanCreditBalanceRefundPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanForeClosurePostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanForeClosurePreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanRefundPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanRefundPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionDownPaymentPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionDownPaymentPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionGoodwillCreditPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionGoodwillCreditPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionInterestPaymentWaiverPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionInterestPaymentWaiverPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionInterestRefundPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionInterestRefundPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionMakeRepaymentPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionMakeRepaymentPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionMerchantIssuedRefundPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionMerchantIssuedRefundPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionPayoutRefundPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionPayoutRefundPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionRecoveryPaymentPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionRecoveryPaymentPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.organisation.holiday.domain.HolidayRepository;
import org.apache.fineract.organisation.holiday.domain.HolidayStatusType;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.workingdays.domain.WorkingDays;
import org.apache.fineract.organisation.workingdays.domain.WorkingDaysRepositoryWrapper;
import org.apache.fineract.portfolio.account.domain.AccountTransferStandingInstruction;
import org.apache.fineract.portfolio.account.domain.StandingInstructionRepository;
import org.apache.fineract.portfolio.account.domain.StandingInstructionStatus;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.exception.ClientNotActiveException;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagement;
import org.apache.fineract.portfolio.delinquency.helper.DelinquencyEffectivePauseHelper;
import org.apache.fineract.portfolio.delinquency.service.DelinquencyReadPlatformService;
import org.apache.fineract.portfolio.delinquency.service.DelinquencyWritePlatformService;
import org.apache.fineract.portfolio.delinquency.validator.LoanDelinquencyActionData;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.exception.GroupNotActiveException;
import org.apache.fineract.portfolio.loanaccount.data.HolidayDetailDTO;
import org.apache.fineract.portfolio.loanaccount.data.LoanRefundRequestData;
import org.apache.fineract.portfolio.loanaccount.data.LoanScheduleDelinquencyData;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountDomainService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountDomainServiceJpa;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountDomainServiceJpaHelper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargePaidBy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCollateralManagement;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCollateralManagementRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanDisbursementDetails;
import org.apache.fineract.portfolio.loanaccount.domain.LoanEvent;
import org.apache.fineract.portfolio.loanaccount.domain.LoanLifecycleStateMachine;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanSubStatus;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelation;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelationTypeEnum;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionToRepaymentScheduleMapping;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.MoneyHolder;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.TransactionCtx;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanChargeValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanDownPaymentTransactionValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanForeclosureValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanTransactionValidator;
import org.apache.fineract.portfolio.loanaccount.service.InterestRefundService;
import org.apache.fineract.portfolio.loanaccount.service.InterestRefundServiceDelegate;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanBalanceService;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeService;
import org.apache.fineract.portfolio.loanaccount.service.LoanDownPaymentHandlerService;
import org.apache.fineract.portfolio.loanaccount.service.LoanJournalEntryPoster;
import org.apache.fineract.portfolio.loanaccount.service.LoanRefundService;
import org.apache.fineract.portfolio.loanaccount.service.LoanScheduleService;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionService;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.apache.fineract.portfolio.loanaccount.service.ReprocessLoanTransactionsService;
import org.apache.fineract.portfolio.loanproduct.domain.LoanSupportedInterestRefundTypes;
import org.apache.fineract.portfolio.note.domain.Note;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.data.PostDatedChecksStatus;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.domain.PostDatedChecks;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.domain.PostDatedChecksRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LoanAccountDomainServiceJpa
implements LoanAccountDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanAccountDomainServiceJpa.class);
    private final LoanAssembler loanAccountAssembler;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final LoanTransactionRepository loanTransactionRepository;
    private final ConfigurationDomainService configurationDomainService;
    private final HolidayRepository holidayRepository;
    private final WorkingDaysRepositoryWrapper workingDaysRepository;
    private final NoteRepository noteRepository;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanUtilService loanUtilService;
    private final StandingInstructionRepository standingInstructionRepository;
    private final PostDatedChecksRepository postDatedChecksRepository;
    private final LoanCollateralManagementRepository loanCollateralManagementRepository;
    private final DelinquencyWritePlatformService delinquencyWritePlatformService;
    private final LoanLifecycleStateMachine loanLifecycleStateMachine;
    private final ExternalIdFactory externalIdFactory;
    private final DelinquencyEffectivePauseHelper delinquencyEffectivePauseHelper;
    private final DelinquencyReadPlatformService delinquencyReadPlatformService;
    private final LoanAccrualsProcessingService loanAccrualsProcessingService;
    private final InterestRefundServiceDelegate interestRefundServiceDelegate;
    private final LoanTransactionValidator loanTransactionValidator;
    private final LoanForeclosureValidator loanForeclosureValidator;
    private final LoanDownPaymentTransactionValidator loanDownPaymentTransactionValidator;
    private final LoanChargeService loanChargeService;
    private final LoanScheduleService loanScheduleService;
    private final LoanDownPaymentHandlerService loanDownPaymentHandlerService;
    private final LoanChargeValidator loanChargeValidator;
    private final LoanRefundService loanRefundService;
    private final LoanAccountService loanAccountService;
    private final ReprocessLoanTransactionsService reprocessLoanTransactionsService;
    private final LoanTransactionProcessingService loanTransactionProcessingService;
    private final LoanBalanceService loanBalanceService;
    private final LoanTransactionService loanTransactionService;
    private final LoanAccountDomainServiceJpaHelper loanAccountDomainServiceJpaHelper;
    private final LoanJournalEntryPoster journalEntryPoster;

    @Transactional
    public LoanTransaction makeRepayment(LoanTransactionType repaymentTransactionType, Loan loan, LocalDate transactionDate, BigDecimal transactionAmount, PaymentDetail paymentDetail, String noteText, ExternalId txnExternalId, boolean isRecoveryRepayment, String chargeRefundChargeType, boolean isAccountTransfer, HolidayDetailDTO holidayDetailDto, Boolean isHolidayValidationDone) {
        return this.makeRepayment(repaymentTransactionType, loan, transactionDate, transactionAmount, paymentDetail, noteText, txnExternalId, isRecoveryRepayment, chargeRefundChargeType, isAccountTransfer, holidayDetailDto, isHolidayValidationDone, false);
    }

    @Transactional
    public void updateLoanCollateralStatus(Set<LoanCollateralManagement> loanCollateralManagementSet, boolean isReleased) {
        for (LoanCollateralManagement loanCollateralManagement : loanCollateralManagementSet) {
            loanCollateralManagement.setIsReleased(isReleased);
        }
        this.loanCollateralManagementRepository.saveAll(loanCollateralManagementSet);
    }

    @Nullable
    private LoanTransaction createInterestRefundLoanTransaction(Loan loan, LoanTransaction refundTransaction) {
        Money newTotalInterest;
        InterestRefundService interestRefundService = this.interestRefundServiceDelegate.lookupInterestRefundService(loan);
        if (interestRefundService == null) {
            return null;
        }
        Money totalInterest = interestRefundService.totalInterestByTransactions(null, (Long)loan.getId(), refundTransaction.getTransactionDate(), List.of(), loan.getLoanTransactions().stream().map(AbstractPersistableCustom::getId).toList());
        BigDecimal interestRefundAmount = totalInterest.minus(newTotalInterest = interestRefundService.totalInterestByTransactions(null, (Long)loan.getId(), refundTransaction.getTransactionDate(), List.of(refundTransaction), loan.getLoanTransactions().stream().map(AbstractPersistableCustom::getId).toList())).getAmount();
        if (MathUtil.isZero((BigDecimal)interestRefundAmount)) {
            return null;
        }
        ExternalId txnExternalId = this.externalIdFactory.create();
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanTransactionInterestRefundPreBusinessEvent(loan));
        return LoanTransaction.interestRefund((Loan)loan, (BigDecimal)interestRefundAmount, (LocalDate)refundTransaction.getDateOf(), (ExternalId)txnExternalId);
    }

    public LoanTransaction createManualInterestRefundWithAmount(Loan loan, LoanTransaction targetTransaction, BigDecimal interestRefundAmount, PaymentDetail paymentDetail, ExternalId txnExternalId) {
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanTransactionInterestRefundPreBusinessEvent(loan));
        return LoanTransaction.interestRefund((Loan)loan, (BigDecimal)interestRefundAmount, (LocalDate)targetTransaction.getDateOf(), (PaymentDetail)paymentDetail, (ExternalId)txnExternalId);
    }

    @Transactional
    public LoanTransaction makeRepayment(LoanTransactionType repaymentTransactionType, Loan loan, LocalDate transactionDate, BigDecimal transactionAmount, PaymentDetail paymentDetail, String noteText, ExternalId txnExternalId, boolean isRecoveryRepayment, String chargeRefundChargeType, boolean isAccountTransfer, HolidayDetailDTO holidayDetailDto, Boolean isHolidayValidationDone, boolean isLoanToLoanTransfer) {
        Set loanTransactionToRepaymentScheduleMappings;
        this.checkClientOrGroupActive(loan);
        LoanBusinessEvent repaymentEvent = this.getLoanRepaymentTypeBusinessEvent(repaymentTransactionType, isRecoveryRepayment, loan);
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)repaymentEvent);
        Money repaymentAmount = Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)transactionAmount);
        LoanTransaction newRepaymentTransaction = isRecoveryRepayment ? LoanTransaction.recoveryRepayment((Office)loan.getOffice(), (Money)repaymentAmount, (PaymentDetail)paymentDetail, (LocalDate)transactionDate, (ExternalId)txnExternalId) : LoanTransaction.repaymentType((LoanTransactionType)repaymentTransactionType, (Office)loan.getOffice(), (Money)repaymentAmount, (PaymentDetail)paymentDetail, (LocalDate)transactionDate, (ExternalId)txnExternalId, (String)chargeRefundChargeType);
        LocalDate recalculateFrom = null;
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            recalculateFrom = transactionDate;
        }
        ScheduleGeneratorDTO scheduleGeneratorDTOForPrepay = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom, transactionDate, holidayDetailDto);
        LocalDate recalculateTill = this.loanAccountDomainServiceJpaHelper.calculateRecalculateTillDate(loan, transactionDate, scheduleGeneratorDTOForPrepay, repaymentAmount);
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom, recalculateTill, holidayDetailDto);
        if (!isHolidayValidationDone.booleanValue()) {
            HolidayDetailDTO holidayDetailDTO = scheduleGeneratorDTO.getHolidayDetailDTO();
            this.loanTransactionValidator.validateRepaymentDateIsOnHoliday(newRepaymentTransaction.getTransactionDate(), holidayDetailDTO.isAllowTransactionsOnHoliday(), holidayDetailDTO.getHolidays());
            this.loanTransactionValidator.validateRepaymentDateIsOnNonWorkingDay(newRepaymentTransaction.getTransactionDate(), holidayDetailDTO.getWorkingDays(), holidayDetailDTO.isAllowTransactionsOnNonWorkingDay());
        }
        LoanEvent event = isRecoveryRepayment ? LoanEvent.LOAN_RECOVERY_PAYMENT : LoanEvent.LOAN_REPAYMENT_OR_WAIVER;
        this.loanTransactionValidator.validateActivityNotBeforeLastTransactionDate(loan, newRepaymentTransaction.getTransactionDate(), event);
        this.loanDownPaymentTransactionValidator.validateRepaymentTypeAccountStatus(loan, newRepaymentTransaction, event);
        this.loanTransactionValidator.validateActivityNotBeforeClientOrGroupTransferDate(loan, event, newRepaymentTransaction.getTransactionDate());
        this.makeRepayment(loan, newRepaymentTransaction, scheduleGeneratorDTO);
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
            this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
        }
        this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(newRepaymentTransaction);
        loan = this.loanAccountService.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            Note note = Note.loanTransactionNote((Loan)loan, (LoanTransaction)newRepaymentTransaction, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
        this.setLoanDelinquencyTag(loan, transactionDate);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(newRepaymentTransaction, isAccountTransfer, isLoanToLoanTransfer);
        if (!repaymentTransactionType.isChargeRefund()) {
            LoanTransactionBusinessEvent transactionRepaymentEvent = this.getTransactionRepaymentTypeBusinessEvent(repaymentTransactionType, isRecoveryRepayment, newRepaymentTransaction);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)transactionRepaymentEvent);
        }
        this.disableStandingInstructionsLinkedToClosedLoan(loan);
        if (loan.getLoanType().isIndividualAccount() && (loanTransactionToRepaymentScheduleMappings = newRepaymentTransaction.getLoanTransactionToRepaymentScheduleMappings()) != null) {
            for (LoanTransactionToRepaymentScheduleMapping loanTransactionToRepaymentScheduleMapping : loanTransactionToRepaymentScheduleMappings) {
                LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment = loanTransactionToRepaymentScheduleMapping.getLoanRepaymentScheduleInstallment();
                if (loanRepaymentScheduleInstallment == null) continue;
                boolean isPaid = loanRepaymentScheduleInstallment.isNotFullyPaidOff();
                PostDatedChecks postDatedChecks = this.postDatedChecksRepository.getPendingPostDatedCheck(loanRepaymentScheduleInstallment);
                if (postDatedChecks == null) break;
                if (!isPaid) {
                    postDatedChecks.setStatus(PostDatedChecksStatus.POST_DATED_CHECKS_PAID);
                } else {
                    postDatedChecks.setStatus(PostDatedChecksStatus.POST_DATED_CHECKS_PENDING);
                }
                this.postDatedChecksRepository.saveAndFlush((Object)postDatedChecks);
            }
        }
        return newRepaymentTransaction;
    }

    private LoanBusinessEvent getLoanRepaymentTypeBusinessEvent(LoanTransactionType repaymentTransactionType, boolean isRecoveryRepayment, Loan loan) {
        LoanTransactionMakeRepaymentPreBusinessEvent repaymentEvent = null;
        if (repaymentTransactionType.isRepayment()) {
            repaymentEvent = new LoanTransactionMakeRepaymentPreBusinessEvent(loan);
        } else if (repaymentTransactionType.isMerchantIssuedRefund()) {
            repaymentEvent = new LoanTransactionMerchantIssuedRefundPreBusinessEvent(loan);
        } else if (repaymentTransactionType.isPayoutRefund()) {
            repaymentEvent = new LoanTransactionPayoutRefundPreBusinessEvent(loan);
        } else if (repaymentTransactionType.isGoodwillCredit()) {
            repaymentEvent = new LoanTransactionGoodwillCreditPreBusinessEvent(loan);
        } else if (repaymentTransactionType.isInterestPaymentWaiver()) {
            repaymentEvent = new LoanTransactionInterestPaymentWaiverPreBusinessEvent(loan);
        } else if (repaymentTransactionType.isChargeRefund()) {
            repaymentEvent = new LoanChargePaymentPreBusinessEvent(loan);
        } else if (isRecoveryRepayment) {
            repaymentEvent = new LoanTransactionRecoveryPaymentPreBusinessEvent(loan);
        } else if (repaymentTransactionType.isDownPayment()) {
            repaymentEvent = new LoanTransactionDownPaymentPreBusinessEvent(loan);
        } else if (repaymentTransactionType.isInterestRefund()) {
            repaymentEvent = new LoanTransactionInterestRefundPreBusinessEvent(loan);
        }
        return repaymentEvent;
    }

    private LoanTransactionBusinessEvent getTransactionRepaymentTypeBusinessEvent(LoanTransactionType repaymentTransactionType, boolean isRecoveryRepayment, LoanTransaction transaction) {
        LoanTransactionMakeRepaymentPostBusinessEvent repaymentEvent = null;
        if (repaymentTransactionType.isRepayment()) {
            repaymentEvent = new LoanTransactionMakeRepaymentPostBusinessEvent(transaction);
        } else if (repaymentTransactionType.isMerchantIssuedRefund()) {
            repaymentEvent = new LoanTransactionMerchantIssuedRefundPostBusinessEvent(transaction);
        } else if (repaymentTransactionType.isPayoutRefund()) {
            repaymentEvent = new LoanTransactionPayoutRefundPostBusinessEvent(transaction);
        } else if (repaymentTransactionType.isGoodwillCredit()) {
            repaymentEvent = new LoanTransactionGoodwillCreditPostBusinessEvent(transaction);
        } else if (repaymentTransactionType.isInterestPaymentWaiver()) {
            repaymentEvent = new LoanTransactionInterestPaymentWaiverPostBusinessEvent(transaction);
        } else if (repaymentTransactionType.isChargeRefund()) {
            repaymentEvent = new LoanChargePaymentPostBusinessEvent(transaction);
        } else if (isRecoveryRepayment) {
            repaymentEvent = new LoanTransactionRecoveryPaymentPostBusinessEvent(transaction);
        } else if (repaymentTransactionType.isDownPayment()) {
            repaymentEvent = new LoanTransactionDownPaymentPostBusinessEvent(transaction);
        } else if (repaymentTransactionType.isInterestRefund()) {
            repaymentEvent = new LoanTransactionInterestRefundPostBusinessEvent(transaction);
        }
        return repaymentEvent;
    }

    @Transactional
    public LoanTransaction makeChargePayment(Loan loan, Long chargeId, LocalDate transactionDate, BigDecimal transactionAmount, PaymentDetail paymentDetail, String noteText, ExternalId txnExternalId, Integer transactionType, Integer installmentNumber) {
        this.checkClientOrGroupActive(loan);
        if (loan.isChargedOff() && DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)loan.getChargedOffOnDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.transaction.date.cannot.be.earlier.than.charge.off.date", "Loan: " + String.valueOf(loan.getId()) + " backdated transaction is not allowed. Transaction date cannot be earlier than the charge-off date of the loan", new Object[]{loan.getId()});
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanChargePaymentPreBusinessEvent(loan));
        Money paymentAmout = Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)transactionAmount);
        LoanTransactionType loanTransactionType = LoanTransactionType.fromInt((Integer)transactionType);
        LoanTransaction newPaymentTransaction = LoanTransaction.loanPayment(null, (Office)loan.getOffice(), (Money)paymentAmout, (PaymentDetail)paymentDetail, (LocalDate)transactionDate, (ExternalId)txnExternalId, (LoanTransactionType)loanTransactionType);
        if (loanTransactionType.isRepaymentAtDisbursement()) {
            this.handlePayDisbursementTransaction(loan, chargeId, newPaymentTransaction);
        } else {
            boolean allowTransactionsOnHoliday = this.configurationDomainService.allowTransactionsOnHolidayEnabled();
            List holidays = this.holidayRepository.findByOfficeIdAndGreaterThanDate(loan.getOfficeId(), transactionDate, HolidayStatusType.ACTIVE.getValue());
            WorkingDays workingDays = this.workingDaysRepository.findOne();
            boolean allowTransactionsOnNonWorkingDay = this.configurationDomainService.allowTransactionsOnNonWorkingDayEnabled();
            boolean isHolidayEnabled = this.configurationDomainService.isRescheduleRepaymentsOnHolidaysEnabled();
            HolidayDetailDTO holidayDetailDTO = new HolidayDetailDTO(isHolidayEnabled, holidays, workingDays, allowTransactionsOnHoliday, allowTransactionsOnNonWorkingDay);
            this.loanDownPaymentTransactionValidator.validateAccountStatus(loan, LoanEvent.LOAN_CHARGE_PAYMENT);
            this.loanTransactionValidator.validateRepaymentDateIsOnHoliday(newPaymentTransaction.getTransactionDate(), holidayDetailDTO.isAllowTransactionsOnHoliday(), holidayDetailDTO.getHolidays());
            this.loanTransactionValidator.validateRepaymentDateIsOnNonWorkingDay(newPaymentTransaction.getTransactionDate(), holidayDetailDTO.getWorkingDays(), holidayDetailDTO.isAllowTransactionsOnNonWorkingDay());
            this.loanTransactionValidator.validateActivityNotBeforeLastTransactionDate(loan, newPaymentTransaction.getTransactionDate(), LoanEvent.LOAN_CHARGE_PAYMENT);
            this.loanTransactionValidator.validateActivityNotBeforeClientOrGroupTransferDate(loan, LoanEvent.LOAN_CHARGE_PAYMENT, newPaymentTransaction.getTransactionDate());
            this.loanChargeService.makeChargePayment(loan, chargeId, newPaymentTransaction, installmentNumber);
        }
        this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(newPaymentTransaction);
        this.loanAccountService.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            Note note = Note.loanTransactionNote((Loan)loan, (LoanTransaction)newPaymentTransaction, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(newPaymentTransaction, true, false);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanChargePaymentPostBusinessEvent(newPaymentTransaction));
        return newPaymentTransaction;
    }

    private void handlePayDisbursementTransaction(Loan loan, Long chargeId, LoanTransaction chargesPayment) {
        LoanCharge charge = null;
        for (LoanCharge loanCharge : loan.getCharges()) {
            if (!loanCharge.isActive() || !chargeId.equals(loanCharge.getId())) continue;
            charge = loanCharge;
        }
        LoanChargePaidBy loanChargePaidBy = new LoanChargePaidBy(chargesPayment, charge, charge.amount(), null);
        chargesPayment.getLoanChargesPaid().add(loanChargePaidBy);
        Money zero = Money.zero((MonetaryCurrency)loan.getCurrency());
        chargesPayment.updateComponents(zero, zero, charge.getAmount(loan.getCurrency()), zero);
        chargesPayment.updateLoan(loan);
        loan.addLoanTransaction(chargesPayment);
        this.loanBalanceService.updateLoanOutstandingBalances(loan);
        charge.markAsFullyPaid();
    }

    private void checkClientOrGroupActive(Loan loan) {
        Client client = loan.client();
        if (client != null && client.isNotActive()) {
            throw new ClientNotActiveException((Long)client.getId());
        }
        Group group = loan.group();
        if (group != null && group.isNotActive()) {
            throw new GroupNotActiveException((Long)group.getId());
        }
    }

    public LoanTransaction makeRefund(Long accountId, CommandProcessingResultBuilder builderResult, LocalDate transactionDate, BigDecimal transactionAmount, PaymentDetail paymentDetail, String noteText, ExternalId txnExternalId) {
        Loan loan = this.loanAccountAssembler.assembleFrom(accountId);
        this.checkClientOrGroupActive(loan);
        if (loan.isChargedOff() && DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)loan.getChargedOffOnDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.transaction.date.cannot.be.earlier.than.charge.off.date", "Loan: " + String.valueOf(loan.getId()) + " backdated transaction is not allowed. Transaction date cannot be earlier than the charge-off date of the loan", new Object[]{loan.getId()});
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanRefundPreBusinessEvent(loan));
        Money refundAmount = Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)transactionAmount);
        LoanTransaction newRefundTransaction = LoanTransaction.refund((Office)loan.getOffice(), (Money)refundAmount, (PaymentDetail)paymentDetail, (LocalDate)transactionDate, (ExternalId)txnExternalId);
        boolean allowTransactionsOnHoliday = this.configurationDomainService.allowTransactionsOnHolidayEnabled();
        List holidays = this.holidayRepository.findByOfficeIdAndGreaterThanDate(loan.getOfficeId(), transactionDate, HolidayStatusType.ACTIVE.getValue());
        WorkingDays workingDays = this.workingDaysRepository.findOne();
        boolean allowTransactionsOnNonWorkingDay = this.configurationDomainService.allowTransactionsOnNonWorkingDayEnabled();
        this.loanTransactionValidator.validateRepaymentDateIsOnHoliday(newRefundTransaction.getTransactionDate(), allowTransactionsOnHoliday, holidays);
        this.loanTransactionValidator.validateRepaymentDateIsOnNonWorkingDay(newRefundTransaction.getTransactionDate(), workingDays, allowTransactionsOnNonWorkingDay);
        this.loanRefundService.makeRefund(loan, newRefundTransaction);
        this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(newRefundTransaction);
        this.loanRepositoryWrapper.saveAndFlush(loan);
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            Note note = Note.loanTransactionNote((Loan)loan, (LoanTransaction)newRefundTransaction, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(newRefundTransaction, true, false);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanRefundPostBusinessEvent(newRefundTransaction));
        builderResult.withEntityId((Long)newRefundTransaction.getId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId());
        return newRefundTransaction;
    }

    @Transactional
    public LoanTransaction makeDisburseTransaction(Long loanId, LocalDate transactionDate, BigDecimal transactionAmount, PaymentDetail paymentDetail, String noteText, ExternalId txnExternalId) {
        return this.makeDisburseTransaction(loanId, transactionDate, transactionAmount, paymentDetail, noteText, txnExternalId, false);
    }

    @Transactional
    public LoanTransaction makeDisburseTransaction(Long loanId, LocalDate transactionDate, BigDecimal transactionAmount, PaymentDetail paymentDetail, String noteText, ExternalId txnExternalId, boolean isLoanToLoanTransfer) {
        Loan loan = this.loanAccountAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        if (loan.isChargedOff() && DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)loan.getChargedOffOnDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.transaction.date.cannot.be.earlier.than.charge.off.date", "Loan: " + String.valueOf(loan.getId()) + " backdated transaction is not allowed. Transaction date cannot be earlier than the charge-off date of the loan", new Object[]{loan.getId()});
        }
        Money amount = Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)transactionAmount);
        LoanTransaction disbursementTransaction = LoanTransaction.disbursement((Loan)loan, (Money)amount, (PaymentDetail)paymentDetail, (LocalDate)transactionDate, (ExternalId)txnExternalId, (Money)loan.getTotalOverpaidAsMoney());
        loan.deductFromNetDisbursalAmount(transactionAmount);
        disbursementTransaction.updateLoan(loan);
        loan.addLoanTransaction(disbursementTransaction);
        this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(disbursementTransaction);
        this.loanAccountService.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            Note note = Note.loanTransactionNote((Loan)loan, (LoanTransaction)disbursementTransaction, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(disbursementTransaction, true, isLoanToLoanTransfer);
        return disbursementTransaction;
    }

    public void reverseTransfer(LoanTransaction loanTransaction) {
        if (loanTransaction.getLoan().isChargedOff() && DateUtils.isBefore((LocalDate)loanTransaction.getTransactionDate(), (LocalDate)loanTransaction.getLoan().getChargedOffOnDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.transaction.date.cannot.be.earlier.than.charge.off.date", "Loan transaction: " + String.valueOf(loanTransaction.getId()) + " reversal is not allowed before or on the date when the loan got charged-off", new Object[]{loanTransaction.getId()});
        }
        this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(loanTransaction.getLoan(), loanTransaction, "reversed");
        loanTransaction.reverse();
        this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(loanTransaction);
    }

    public void setLoanDelinquencyTag(Loan loan, LocalDate transactionDate) {
        LoanScheduleDelinquencyData loanDelinquencyData = new LoanScheduleDelinquencyData((Long)loan.getId(), transactionDate, null, loan);
        List savedDelinquencyList = this.delinquencyReadPlatformService.retrieveLoanDelinquencyActions((Long)loan.getId());
        List effectiveDelinquencyList = this.delinquencyEffectivePauseHelper.calculateEffectiveDelinquencyList(savedDelinquencyList);
        loanDelinquencyData = this.delinquencyWritePlatformService.calculateDelinquencyData(loanDelinquencyData, effectiveDelinquencyList);
        log.debug("Processing Loan {} with {} overdue days since date {}", new Object[]{loanDelinquencyData.getLoanId(), loanDelinquencyData.getOverdueDays(), loanDelinquencyData.getOverdueSinceDate()});
        if (loanDelinquencyData.getOverdueDays() > 0L) {
            this.delinquencyWritePlatformService.applyDelinquencyTagToLoan(loanDelinquencyData, effectiveDelinquencyList);
        } else {
            this.delinquencyWritePlatformService.removeDelinquencyTagToLoan(loanDelinquencyData.getLoan());
        }
    }

    public void setLoanDelinquencyTag(Loan loan, LocalDate transactionDate, List<LoanDelinquencyActionData> effectiveDelinquencyList) {
        LoanScheduleDelinquencyData loanDelinquencyData = new LoanScheduleDelinquencyData((Long)loan.getId(), transactionDate, null, loan);
        loanDelinquencyData = this.delinquencyWritePlatformService.calculateDelinquencyData(loanDelinquencyData, effectiveDelinquencyList);
        log.debug("Processing Loan {} with {} overdue days since date {}", new Object[]{loanDelinquencyData.getLoanId(), loanDelinquencyData.getOverdueDays(), loanDelinquencyData.getOverdueSinceDate()});
        if (loanDelinquencyData.getOverdueDays() > 0L) {
            this.delinquencyWritePlatformService.applyDelinquencyTagToLoan(loanDelinquencyData, effectiveDelinquencyList);
        } else {
            this.delinquencyWritePlatformService.removeDelinquencyTagToLoan(loanDelinquencyData.getLoan());
        }
    }

    public LoanTransaction creditBalanceRefund(Loan loan, LocalDate transactionDate, BigDecimal transactionAmount, String noteText, ExternalId externalId, PaymentDetail paymentDetail) {
        if (transactionDate.isAfter(DateUtils.getBusinessLocalDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.transaction.date.cannot.be.in.the.future", "Loan: " + String.valueOf(loan.getId()) + ", Credit Balance Refund transaction cannot be created for the future.", new Object[]{loan.getId()});
        }
        if (loan.isChargedOff() && DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)loan.getChargedOffOnDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.transaction.date.cannot.be.earlier.than.charge.off.date", "Loan: " + String.valueOf(loan.getId()) + " backdated transaction is not allowed. Transaction date cannot be earlier than the charge-off date of the loan", new Object[]{loan.getId()});
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanCreditBalanceRefundPreBusinessEvent(loan));
        Money refundAmount = Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)transactionAmount);
        LoanTransaction newCreditBalanceRefundTransaction = LoanTransaction.creditBalanceRefund((Loan)loan, (Office)loan.getOffice(), (Money)refundAmount, (LocalDate)transactionDate, (ExternalId)externalId, (PaymentDetail)paymentDetail);
        this.loanDownPaymentTransactionValidator.validateAccountStatus(loan, LoanEvent.LOAN_CREDIT_BALANCE_REFUND);
        this.loanTransactionValidator.validateRefundDateIsAfterLastRepayment(loan, newCreditBalanceRefundTransaction.getTransactionDate());
        this.loanRefundService.creditBalanceRefund(loan, newCreditBalanceRefundTransaction);
        newCreditBalanceRefundTransaction = (LoanTransaction)this.loanTransactionRepository.saveAndFlush((Object)newCreditBalanceRefundTransaction);
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            Note note = Note.loanTransactionNote((Loan)loan, (LoanTransaction)newCreditBalanceRefundTransaction, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(newCreditBalanceRefundTransaction, false, false);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanCreditBalanceRefundPostBusinessEvent(newCreditBalanceRefundTransaction));
        return newCreditBalanceRefundTransaction;
    }

    public LoanTransaction makeRefundForActiveLoan(Long accountId, CommandProcessingResultBuilder builderResult, LocalDate transactionDate, BigDecimal transactionAmount, PaymentDetail paymentDetail, String noteText, ExternalId txnExternalId) {
        Loan loan = this.loanAccountAssembler.assembleFrom(accountId);
        this.checkClientOrGroupActive(loan);
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanRefundPreBusinessEvent(loan));
        Money refundAmount = Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)transactionAmount);
        if (loan.isChargedOff() && DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)loan.getChargedOffOnDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.transaction.date.cannot.be.earlier.than.charge.off.date", "Loan: " + String.valueOf(loan.getId()) + " backdated transaction is not allowed. Transaction date cannot be earlier than the charge-off date of the loan", new Object[]{loan.getId()});
        }
        LoanTransaction newRefundTransaction = LoanTransaction.refundForActiveLoan((Office)loan.getOffice(), (Money)refundAmount, (PaymentDetail)paymentDetail, (LocalDate)transactionDate, (ExternalId)txnExternalId);
        this.loanTransactionValidator.validateRefundDateIsAfterLastRepayment(loan, newRefundTransaction.getTransactionDate());
        boolean allowTransactionsOnHoliday = this.configurationDomainService.allowTransactionsOnHolidayEnabled();
        List holidays = this.holidayRepository.findByOfficeIdAndGreaterThanDate(loan.getOfficeId(), transactionDate, HolidayStatusType.ACTIVE.getValue());
        WorkingDays workingDays = this.workingDaysRepository.findOne();
        boolean allowTransactionsOnNonWorkingDay = this.configurationDomainService.allowTransactionsOnNonWorkingDayEnabled();
        this.loanDownPaymentTransactionValidator.validateAccountStatus(loan, LoanEvent.LOAN_REFUND);
        this.loanTransactionValidator.validateRepaymentDateIsOnHoliday(newRefundTransaction.getTransactionDate(), allowTransactionsOnHoliday, holidays);
        this.loanTransactionValidator.validateRepaymentDateIsOnNonWorkingDay(newRefundTransaction.getTransactionDate(), workingDays, allowTransactionsOnNonWorkingDay);
        this.loanTransactionValidator.validateActivityNotBeforeClientOrGroupTransferDate(loan, LoanEvent.LOAN_REFUND, newRefundTransaction.getTransactionDate());
        this.loanRefundService.makeRefundForActiveLoan(loan, newRefundTransaction);
        this.loanTransactionRepository.saveAndFlush((Object)newRefundTransaction);
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            Note note = Note.loanTransactionNote((Loan)loan, (LoanTransaction)newRefundTransaction, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, loan.isInterestBearingAndInterestRecalculationEnabled(), true);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(newRefundTransaction, false, false);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanRefundPostBusinessEvent(newRefundTransaction));
        builderResult.withEntityId((Long)newRefundTransaction.getId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId());
        return newRefundTransaction;
    }

    public LoanTransaction foreCloseLoan(Loan loan, LocalDate foreClosureDate, String noteText, ExternalId externalId, Map<String, Object> changes) {
        if (loan.isChargedOff() && DateUtils.isBefore((LocalDate)foreClosureDate, (LocalDate)loan.getChargedOffOnDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.transaction.date.cannot.be.earlier.than.charge.off.date", "Loan: " + String.valueOf(loan.getId()) + " backdated transaction is not allowed. Transaction date cannot be earlier than the charge-off date of the loan", new Object[]{loan.getId()});
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanForeClosurePreBusinessEvent(loan));
        MonetaryCurrency currency = loan.getCurrency();
        ArrayList<LoanTransaction> newTransactions = new ArrayList<LoanTransaction>();
        ScheduleGeneratorDTO scheduleGeneratorDTO = null;
        LoanRepaymentScheduleInstallment foreCloseDetail = this.loanBalanceService.fetchLoanForeclosureDetail(loan, foreClosureDate);
        this.loanAccrualsProcessingService.processAccrualsOnLoanForeClosure(loan, foreClosureDate, newTransactions);
        Money interestPayable = foreCloseDetail.getInterestCharged(currency);
        Money feePayable = foreCloseDetail.getFeeChargesCharged(currency);
        Money penaltyPayable = foreCloseDetail.getPenaltyChargesCharged(currency);
        Money payPrincipal = foreCloseDetail.getPrincipal(currency);
        this.updateInstallmentsPostDate(loan, foreClosureDate);
        LoanTransaction payment = null;
        if (payPrincipal.plus(interestPayable).plus(feePayable).plus(penaltyPayable).isGreaterThanZero()) {
            PaymentDetail paymentDetail = null;
            payment = LoanTransaction.repayment((Office)loan.getOffice(), (Money)payPrincipal.plus(interestPayable).plus(feePayable).plus(penaltyPayable), paymentDetail, (LocalDate)foreClosureDate, (ExternalId)externalId);
            payment.updateLoan(loan);
            newTransactions.add(payment);
        }
        ArrayList<Long> transactionIds = new ArrayList<Long>();
        if (payment != null) {
            this.loanForeclosureValidator.validateForForeclosure(loan, payment.getTransactionDate());
        }
        this.loanDownPaymentTransactionValidator.validateAccountStatus(loan, LoanEvent.LOAN_FORECLOSURE);
        this.handleForeClosureTransactions(loan, payment, scheduleGeneratorDTO);
        this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
        }
        for (LoanTransaction newTransaction : newTransactions) {
            LoanTransaction savedNewTransaction = this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(newTransaction);
            loan.addLoanTransaction(savedNewTransaction);
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(newTransaction, false, false);
            transactionIds.add((Long)savedNewTransaction.getId());
        }
        changes.put("transactions", transactionIds);
        changes.put("eventAmount", payPrincipal.getAmount().negate());
        loan = this.loanAccountService.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            changes.put("note", noteText);
            Note note = Note.loanNote((Loan)loan, (String)noteText);
            this.noteRepository.save((Object)note);
        }
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanForeClosurePostBusinessEvent(payment));
        return payment;
    }

    @Transactional
    public void disableStandingInstructionsLinkedToClosedLoan(Loan loan) {
        Integer standingInstructionStatus;
        Collection accountTransferStandingInstructions;
        if (loan != null && loan.getStatus() != null && loan.getStatus().isClosed() && !(accountTransferStandingInstructions = this.standingInstructionRepository.findByLoanAccountAndStatus(loan, standingInstructionStatus = StandingInstructionStatus.ACTIVE.getValue())).isEmpty()) {
            for (AccountTransferStandingInstruction accountTransferStandingInstruction : accountTransferStandingInstructions) {
                accountTransferStandingInstruction.updateStatus(StandingInstructionStatus.DISABLED.getValue());
                this.standingInstructionRepository.save((Object)accountTransferStandingInstruction);
            }
        }
    }

    public void updateAndSaveLoanCollateralTransactionsForIndividualAccounts(Loan loan, LoanTransaction loanTransaction) {
        if (loan.getLoanType().isIndividualAccount()) {
            Set loanCollateralManagements = loan.getLoanCollateralManagements();
            for (LoanCollateralManagement loanCollateralManagement : loanCollateralManagements) {
                if (loanTransaction != null) {
                    loanCollateralManagement.setLoanTransactionData(loanTransaction);
                }
                ClientCollateralManagement clientCollateralManagement = loanCollateralManagement.getClientCollateralManagement();
                if (!loan.getStatus().isClosed()) continue;
                loanCollateralManagement.setIsReleased(true);
                BigDecimal quantity = loanCollateralManagement.getQuantity();
                clientCollateralManagement.updateQuantity(clientCollateralManagement.getQuantity().add(quantity));
                loanCollateralManagement.setClientCollateralManagement(clientCollateralManagement);
            }
            this.loanCollateralManagementRepository.saveAll((Iterable)loanCollateralManagements);
        }
    }

    public Pair<LoanTransaction, LoanTransaction> makeRefund(Loan loan, ScheduleGeneratorDTO scheduleGeneratorDTO, LoanTransactionType loanTransactionType, LocalDate transactionDate, BigDecimal transactionAmount, PaymentDetail paymentDetail, ExternalId txnExternalId, Boolean interestRefundCalculationOverride) {
        boolean processLatest;
        switch (1.$SwitchMap$org$apache$fineract$portfolio$loanaccount$domain$LoanTransactionType[loanTransactionType.ordinal()]) {
            case 1: {
                this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanTransactionMerchantIssuedRefundPreBusinessEvent(loan));
                break;
            }
            case 2: {
                this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanTransactionPayoutRefundPreBusinessEvent(loan));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Not configured loan transaction type: %s!", loanTransactionType));
            }
        }
        LoanTransaction refundTransaction = LoanTransaction.refund((Loan)loan, (LoanTransactionType)loanTransactionType, (BigDecimal)transactionAmount, (PaymentDetail)paymentDetail, (LocalDate)transactionDate, (ExternalId)txnExternalId);
        boolean isTransactionChronologicallyLatest = this.loanTransactionService.isChronologicallyLatestRepaymentOrWaiver(loan, refundTransaction);
        boolean shouldCreateInterestRefundTransaction = Objects.requireNonNullElseGet(interestRefundCalculationOverride, () -> loan.getLoanProductRelatedDetail().getSupportedInterestRefundTypes().stream().map(LoanSupportedInterestRefundTypes::getTransactionType).anyMatch(transactionType -> transactionType.equals((Object)loanTransactionType)));
        LoanTransaction interestRefundTransaction = null;
        if (shouldCreateInterestRefundTransaction && (interestRefundTransaction = this.createInterestRefundLoanTransaction(loan, refundTransaction)) != null) {
            interestRefundTransaction.getLoanTransactionRelations().add(LoanTransactionRelation.linkToTransaction((LoanTransaction)interestRefundTransaction, (LoanTransaction)refundTransaction, (LoanTransactionRelationTypeEnum)LoanTransactionRelationTypeEnum.RELATED));
        }
        LoanRepaymentScheduleInstallment currentInstallment = loan.fetchLoanRepaymentScheduleInstallmentByDueDate(transactionDate);
        boolean bl = processLatest = isTransactionChronologicallyLatest && !loan.isForeclosure() && !loan.hasChargesAffectedByBackdatedRepaymentLikeTransaction(refundTransaction) && this.loanTransactionProcessingService.canProcessLatestTransactionOnly(loan, refundTransaction, currentInstallment);
        if (processLatest) {
            this.loanTransactionProcessingService.processLatestTransaction(loan.getTransactionProcessingStrategyCode(), refundTransaction, new TransactionCtx(loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges(), new MoneyHolder(loan.getTotalOverpaidAsMoney()), null));
            loan.getLoanTransactions().add(refundTransaction);
            if (interestRefundTransaction != null) {
                this.loanTransactionProcessingService.processLatestTransaction(loan.getTransactionProcessingStrategyCode(), interestRefundTransaction, new TransactionCtx(loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges(), new MoneyHolder(loan.getTotalOverpaidAsMoney()), null));
                loan.addLoanTransaction(interestRefundTransaction);
            }
        } else {
            if (loan.isCumulativeSchedule() && loan.isInterestBearingAndInterestRecalculationEnabled()) {
                this.loanScheduleService.regenerateRepaymentScheduleWithInterestRecalculation(loan, scheduleGeneratorDTO);
            } else if (loan.isProgressiveSchedule() && (loan.hasChargeOffTransaction() && loan.hasAccelerateChargeOffStrategy() || loan.hasContractTerminationTransaction())) {
                this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
            }
            loan.getLoanTransactions().add(refundTransaction);
            if (interestRefundTransaction != null) {
                loan.addLoanTransaction(interestRefundTransaction);
            }
            this.reprocessLoanTransactionsService.reprocessTransactions(loan);
        }
        this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(refundTransaction);
        if (interestRefundTransaction != null) {
            this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(interestRefundTransaction);
        }
        this.loanLifecycleStateMachine.determineAndTransition(loan, transactionDate);
        switch (1.$SwitchMap$org$apache$fineract$portfolio$loanaccount$domain$LoanTransactionType[loanTransactionType.ordinal()]) {
            case 1: {
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanTransactionMerchantIssuedRefundPostBusinessEvent(refundTransaction));
                break;
            }
            case 2: {
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanTransactionPayoutRefundPostBusinessEvent(refundTransaction));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Not configured loan transaction type: %s!", loanTransactionType));
            }
        }
        if (interestRefundTransaction != null) {
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanTransactionInterestRefundPostBusinessEvent(interestRefundTransaction));
        }
        return Pair.of((Object)refundTransaction, (Object)interestRefundTransaction);
    }

    public void updateAndSavePostDatedChecksForIndividualAccount(Loan loan, LoanTransaction transaction) {
        Set loanTransactionToRepaymentScheduleMappings;
        if (loan.getLoanType().isIndividualAccount() && (loanTransactionToRepaymentScheduleMappings = transaction.getLoanTransactionToRepaymentScheduleMappings()) != null) {
            for (LoanTransactionToRepaymentScheduleMapping loanTransactionToRepaymentScheduleMapping : loanTransactionToRepaymentScheduleMappings) {
                LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment = loanTransactionToRepaymentScheduleMapping.getLoanRepaymentScheduleInstallment();
                if (loanRepaymentScheduleInstallment == null) continue;
                boolean isPaid = loanRepaymentScheduleInstallment.isNotFullyPaidOff();
                PostDatedChecks postDatedChecks = this.postDatedChecksRepository.getPendingPostDatedCheck(loanRepaymentScheduleInstallment);
                if (postDatedChecks == null) break;
                if (!isPaid) {
                    postDatedChecks.setStatus(PostDatedChecksStatus.POST_DATED_CHECKS_PAID);
                } else {
                    postDatedChecks.setStatus(PostDatedChecksStatus.POST_DATED_CHECKS_PENDING);
                }
                this.postDatedChecksRepository.saveAndFlush((Object)postDatedChecks);
            }
        }
    }

    public LoanTransaction applyInterestRefund(Loan loan, LoanRefundRequestData loanRefundRequest) {
        PaymentDetail paymentDetail = null;
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        BigDecimal refundAmount = loanRefundRequest.getTotalAmount();
        LoanTransaction interestRefundTransaction = LoanTransaction.interestRefund((Loan)loan, (Office)loan.getOffice(), (BigDecimal)refundAmount, (BigDecimal)loanRefundRequest.getPrincipal(), (BigDecimal)loanRefundRequest.getInterest(), (BigDecimal)loanRefundRequest.getFeeCharges(), (BigDecimal)loanRefundRequest.getPenaltyCharges(), paymentDetail, (LocalDate)transactionDate, (ExternalId)this.externalIdFactory.create());
        interestRefundTransaction.updateLoan(loan);
        this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(interestRefundTransaction);
        loan.addLoanTransaction(interestRefundTransaction);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(interestRefundTransaction, false, false);
        return interestRefundTransaction;
    }

    private void updateInstallmentsPostDate(Loan loan, LocalDate transactionDate) {
        ArrayList<LoanRepaymentScheduleInstallment> newInstallments = new ArrayList<LoanRepaymentScheduleInstallment>(loan.getRepaymentScheduleInstallments());
        MonetaryCurrency currency = loan.getCurrency();
        Money totalPrincipal = Money.zero((MonetaryCurrency)currency);
        Money[] balances = this.loanBalanceService.retrieveIncomeForOverlappingPeriod(loan, transactionDate);
        boolean isInterestComponent = true;
        for (LoanRepaymentScheduleInstallment installment : loan.getRepaymentScheduleInstallments()) {
            if (DateUtils.isAfter((LocalDate)transactionDate, (LocalDate)installment.getDueDate())) continue;
            totalPrincipal = totalPrincipal.plus(installment.getPrincipal(currency));
            newInstallments.remove(installment);
            if (!DateUtils.isEqual((LocalDate)transactionDate, (LocalDate)installment.getDueDate())) continue;
            isInterestComponent = false;
        }
        for (LoanDisbursementDetails loanDisbursementDetails : loan.getDisbursementDetails()) {
            if (loanDisbursementDetails.actualDisbursementDate() != null) continue;
            totalPrincipal = Money.of((MonetaryCurrency)currency, (BigDecimal)totalPrincipal.getAmount().subtract(loanDisbursementDetails.principal()));
        }
        LocalDate installmentStartDate = loan.getDisbursementDate();
        if (!newInstallments.isEmpty()) {
            installmentStartDate = ((LoanRepaymentScheduleInstallment)newInstallments.get(newInstallments.size() - 1)).getDueDate();
        }
        int installmentNumber = newInstallments.size();
        if (!isInterestComponent) {
            ++installmentNumber;
        }
        LoanRepaymentScheduleInstallment newInstallment = new LoanRepaymentScheduleInstallment(null, Integer.valueOf(newInstallments.size() + 1), installmentStartDate, transactionDate, totalPrincipal.getAmount(), balances[0].getAmount(), balances[1].getAmount(), balances[2].getAmount(), isInterestComponent, null);
        newInstallment.updateInstallmentNumber(Integer.valueOf(newInstallments.size() + 1));
        newInstallments.add(newInstallment);
        loan.updateLoanScheduleOnForeclosure(newInstallments);
        Set charges = loan.getActiveCharges();
        boolean penaltyWaitPeriod = false;
        for (LoanCharge loanCharge : charges) {
            if (DateUtils.isAfter((LocalDate)loanCharge.getDueLocalDate(), (LocalDate)transactionDate)) {
                loanCharge.setActive(false);
                continue;
            }
            if (loanCharge.getDueLocalDate() != null) continue;
            this.loanChargeService.recalculateLoanCharge(loan, loanCharge, 0);
            loanCharge.updateWaivedAmount(currency);
        }
        for (LoanTransaction loanTransaction : loan.getLoanTransactions()) {
            if (!loanTransaction.isChargesWaiver()) continue;
            for (LoanChargePaidBy chargePaidBy : loanTransaction.getLoanChargesPaid()) {
                if ((!chargePaidBy.getLoanCharge().isDueDateCharge() || !DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)chargePaidBy.getLoanCharge().getDueLocalDate())) && (!chargePaidBy.getLoanCharge().isInstalmentFee() || chargePaidBy.getInstallmentNumber() == null || chargePaidBy.getInstallmentNumber() <= installmentNumber)) continue;
                this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(loanTransaction.getLoan(), loanTransaction, "reversed");
                loanTransaction.reverse();
            }
        }
    }

    private void makeRepayment(Loan loan, LoanTransaction repaymentTransaction, ScheduleGeneratorDTO scheduleGeneratorDTO) {
        this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(loan, repaymentTransaction, "created");
        this.loanDownPaymentHandlerService.handleRepaymentOrRecoveryOrWaiverTransaction(loan, repaymentTransaction, null, scheduleGeneratorDTO);
    }

    private void handleForeClosureTransactions(Loan loan, LoanTransaction repaymentTransaction, ScheduleGeneratorDTO scheduleGeneratorDTO) {
        loan.setLoanSubStatus(LoanSubStatus.FORECLOSED);
        this.loanDownPaymentHandlerService.handleRepaymentOrRecoveryOrWaiverTransaction(loan, repaymentTransaction, null, scheduleGeneratorDTO);
    }

    @Generated
    public LoanAccountDomainServiceJpa(LoanAssembler loanAccountAssembler, LoanRepositoryWrapper loanRepositoryWrapper, LoanTransactionRepository loanTransactionRepository, ConfigurationDomainService configurationDomainService, HolidayRepository holidayRepository, WorkingDaysRepositoryWrapper workingDaysRepository, NoteRepository noteRepository, BusinessEventNotifierService businessEventNotifierService, LoanUtilService loanUtilService, StandingInstructionRepository standingInstructionRepository, PostDatedChecksRepository postDatedChecksRepository, LoanCollateralManagementRepository loanCollateralManagementRepository, DelinquencyWritePlatformService delinquencyWritePlatformService, LoanLifecycleStateMachine loanLifecycleStateMachine, ExternalIdFactory externalIdFactory, DelinquencyEffectivePauseHelper delinquencyEffectivePauseHelper, DelinquencyReadPlatformService delinquencyReadPlatformService, LoanAccrualsProcessingService loanAccrualsProcessingService, InterestRefundServiceDelegate interestRefundServiceDelegate, LoanTransactionValidator loanTransactionValidator, LoanForeclosureValidator loanForeclosureValidator, LoanDownPaymentTransactionValidator loanDownPaymentTransactionValidator, LoanChargeService loanChargeService, LoanScheduleService loanScheduleService, LoanDownPaymentHandlerService loanDownPaymentHandlerService, LoanChargeValidator loanChargeValidator, LoanRefundService loanRefundService, LoanAccountService loanAccountService, ReprocessLoanTransactionsService reprocessLoanTransactionsService, LoanTransactionProcessingService loanTransactionProcessingService, LoanBalanceService loanBalanceService, LoanTransactionService loanTransactionService, LoanAccountDomainServiceJpaHelper loanAccountDomainServiceJpaHelper, LoanJournalEntryPoster journalEntryPoster) {
        this.loanAccountAssembler = loanAccountAssembler;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.loanTransactionRepository = loanTransactionRepository;
        this.configurationDomainService = configurationDomainService;
        this.holidayRepository = holidayRepository;
        this.workingDaysRepository = workingDaysRepository;
        this.noteRepository = noteRepository;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanUtilService = loanUtilService;
        this.standingInstructionRepository = standingInstructionRepository;
        this.postDatedChecksRepository = postDatedChecksRepository;
        this.loanCollateralManagementRepository = loanCollateralManagementRepository;
        this.delinquencyWritePlatformService = delinquencyWritePlatformService;
        this.loanLifecycleStateMachine = loanLifecycleStateMachine;
        this.externalIdFactory = externalIdFactory;
        this.delinquencyEffectivePauseHelper = delinquencyEffectivePauseHelper;
        this.delinquencyReadPlatformService = delinquencyReadPlatformService;
        this.loanAccrualsProcessingService = loanAccrualsProcessingService;
        this.interestRefundServiceDelegate = interestRefundServiceDelegate;
        this.loanTransactionValidator = loanTransactionValidator;
        this.loanForeclosureValidator = loanForeclosureValidator;
        this.loanDownPaymentTransactionValidator = loanDownPaymentTransactionValidator;
        this.loanChargeService = loanChargeService;
        this.loanScheduleService = loanScheduleService;
        this.loanDownPaymentHandlerService = loanDownPaymentHandlerService;
        this.loanChargeValidator = loanChargeValidator;
        this.loanRefundService = loanRefundService;
        this.loanAccountService = loanAccountService;
        this.reprocessLoanTransactionsService = reprocessLoanTransactionsService;
        this.loanTransactionProcessingService = loanTransactionProcessingService;
        this.loanBalanceService = loanBalanceService;
        this.loanTransactionService = loanTransactionService;
        this.loanAccountDomainServiceJpaHelper = loanAccountDomainServiceJpaHelper;
        this.journalEntryPoster = journalEntryPoster;
    }
}

