/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service.aggregationjob.services;

import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.data.JournalEntryAggregationSummaryData;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.data.JournalEntryAggregationTrackingData;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.domain.JournalEntryAggregationTracking;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.domain.JournalEntryAggregationTrackingRepository;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.domain.JournalEntrySummary;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.domain.JournalEntrySummaryRepository;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.services.JournalEntryAggregationWriterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class JournalEntryAggregationWriterServiceImpl
implements JournalEntryAggregationWriterService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JournalEntryAggregationWriterServiceImpl.class);
    private JournalEntrySummaryRepository journalSummaryRepository;
    private JournalEntryAggregationTrackingRepository journalEntryAggregationTrackingRepository;
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public void insertJournalEntrySummaryBatch(List<JournalEntryAggregationSummaryData> journalEntrySummaries) {
        List<JournalEntrySummary> entities = journalEntrySummaries.stream().map(arg_0 -> this.convertToJournalEntrySummary(arg_0)).toList();
        this.journalSummaryRepository.saveAll(entities);
    }

    public void insertJournalEntryTracking(JournalEntryAggregationTrackingData journalEntrySummaryTrackingDTO) throws Exception {
        log.info("Inserting journal entry tracking");
        this.saveJournalEntryTracking(journalEntrySummaryTrackingDTO);
    }

    public void rollbackJournalEntrySummary(Long jobExecutionId) {
        log.info("Rolling back journal entry summary for jobExecutionId={}", (Object)jobExecutionId);
        this.journalSummaryRepository.deleteByJobExecutionId(jobExecutionId);
    }

    public void rollbackJournalEntryTracking(Long jobExecutionId) {
        log.info("Rolling back journal entry summary tracking for jobExecutionId={}", (Object)jobExecutionId);
        this.journalEntryAggregationTrackingRepository.deleteByJobExecutionId(jobExecutionId);
    }

    private void saveJournalEntryTracking(JournalEntryAggregationTrackingData journalEntrySummaryTrackingDTO) {
        JournalEntryAggregationTracking journalEntryAggregationTracking = new JournalEntryAggregationTracking();
        journalEntryAggregationTracking.setSubmittedOnDate(journalEntrySummaryTrackingDTO.getSubmittedOnDate());
        journalEntryAggregationTracking.setAggregatedOnDateFrom(journalEntrySummaryTrackingDTO.getAggregatedOnDateFrom());
        journalEntryAggregationTracking.setAggregatedOnDateTo(journalEntrySummaryTrackingDTO.getAggregatedOnDateTo());
        journalEntryAggregationTracking.setJobExecutionId(journalEntrySummaryTrackingDTO.getJobExecutionId());
        this.journalEntryAggregationTrackingRepository.save((Object)journalEntryAggregationTracking);
    }

    private JournalEntrySummary convertToJournalEntrySummary(JournalEntryAggregationSummaryData summaryDTO) {
        JournalEntrySummary entrySummary = new JournalEntrySummary();
        entrySummary.setProduct(summaryDTO.getProductId());
        entrySummary.setGlAccountId(summaryDTO.getGlAccountId());
        entrySummary.setOffice(summaryDTO.getOffice());
        entrySummary.setEntityTypeEnum(summaryDTO.getEntityTypeEnum());
        entrySummary.setSubmittedOnDate(summaryDTO.getSubmittedOnDate());
        entrySummary.setDebitAmount(summaryDTO.getDebitAmount());
        entrySummary.setCreditAmount(summaryDTO.getCreditAmount());
        entrySummary.setExternalOwnerId(summaryDTO.getExternalOwnerId());
        entrySummary.setAggregatedOnDate(summaryDTO.getAggregatedOnDate());
        entrySummary.setJobExecutionId(summaryDTO.getJobExecutionId());
        return entrySummary;
    }

    @Generated
    public JournalEntryAggregationWriterServiceImpl(JournalEntrySummaryRepository journalSummaryRepository, JournalEntryAggregationTrackingRepository journalEntryAggregationTrackingRepository, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.journalSummaryRepository = journalSummaryRepository;
        this.journalEntryAggregationTrackingRepository = journalEntryAggregationTrackingRepository;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

