/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.charge.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.accounting.common.AccountingDropdownReadPlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainServiceJpa;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityType;
import org.apache.fineract.infrastructure.entityaccess.service.FineractEntityAccessUtil;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformService;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.charge.domain.ChargeAppliesTo;
import org.apache.fineract.portfolio.charge.domain.ChargeTimeType;
import org.apache.fineract.portfolio.charge.exception.ChargeNotFoundException;
import org.apache.fineract.portfolio.charge.service.ChargeDropdownReadPlatformService;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformServiceImpl;
import org.apache.fineract.portfolio.common.service.DropdownReadPlatformService;
import org.apache.fineract.portfolio.tax.service.TaxReadPlatformService;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class ChargeReadPlatformServiceImpl
implements ChargeReadPlatformService {
    private final CurrencyReadPlatformService currencyReadPlatformService;
    private final ChargeDropdownReadPlatformService chargeDropdownReadPlatformService;
    private final JdbcTemplate jdbcTemplate;
    private final DropdownReadPlatformService dropdownReadPlatformService;
    private final FineractEntityAccessUtil fineractEntityAccessUtil;
    private final AccountingDropdownReadPlatformService accountingDropdownReadPlatformService;
    private final TaxReadPlatformService taxReadPlatformService;
    private final ConfigurationDomainServiceJpa configurationDomainServiceJpa;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    @Cacheable(value={"charges"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat('ch')")
    public List<ChargeData> retrieveAllCharges() {
        ChargeMapper rm = new ChargeMapper();
        String sql = "select " + rm.chargeSchema() + " where c.is_deleted=false ";
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        sql = sql + " order by c.name ";
        return this.jdbcTemplate.query(sql, (RowMapper)rm);
    }

    public List<ChargeData> retrieveAllChargesForCurrency(String currencyCode) {
        ChargeMapper rm = new ChargeMapper();
        String sql = "select " + rm.chargeSchema() + " where c.is_deleted=false and c.currency_code= ? ";
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        sql = sql + " order by c.name ";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{currencyCode});
    }

    public ChargeData retrieveCharge(Long chargeId) {
        try {
            ChargeMapper rm = new ChargeMapper();
            String sql = "select " + rm.chargeSchema() + " where c.id = ? and c.is_deleted=false ";
            sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
            sql = sql + " ;";
            return (ChargeData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{chargeId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new ChargeNotFoundException(chargeId, e);
        }
    }

    public ChargeData retrieveNewChargeDetails() {
        List currencyOptions = this.currencyReadPlatformService.retrieveAllowedCurrencies();
        List allowedChargeCalculationTypeOptions = this.chargeDropdownReadPlatformService.retrieveCalculationTypes();
        List allowedChargeAppliesToOptions = this.chargeDropdownReadPlatformService.retrieveApplicableToTypes();
        List allowedChargeTimeOptions = this.chargeDropdownReadPlatformService.retrieveCollectionTimeTypes();
        List chargePaymentOptions = this.chargeDropdownReadPlatformService.retrivePaymentModes();
        List loansChargeCalculationTypeOptions = this.chargeDropdownReadPlatformService.retrieveLoanCalculationTypes();
        List loansChargeTimeTypeOptions = this.chargeDropdownReadPlatformService.retrieveLoanCollectionTimeTypes();
        List savingsChargeCalculationTypeOptions = this.chargeDropdownReadPlatformService.retrieveSavingsCalculationTypes();
        List savingsChargeTimeTypeOptions = this.chargeDropdownReadPlatformService.retrieveSavingsCollectionTimeTypes();
        List clientChargeCalculationTypeOptions = this.chargeDropdownReadPlatformService.retrieveClientCalculationTypes();
        List clientChargeTimeTypeOptions = this.chargeDropdownReadPlatformService.retrieveClientCollectionTimeTypes();
        List feeFrequencyOptions = this.dropdownReadPlatformService.retrievePeriodFrequencyTypeOptions();
        Map incomeOrLiabilityAccountOptions = this.accountingDropdownReadPlatformService.retrieveAccountMappingOptionsForCharges();
        List shareChargeCalculationTypeOptions = this.chargeDropdownReadPlatformService.retrieveSharesCalculationTypes();
        List shareChargeTimeTypeOptions = this.chargeDropdownReadPlatformService.retrieveSharesCollectionTimeTypes();
        List taxGroupOptions = this.taxReadPlatformService.retrieveTaxGroupsForLookUp();
        String accountMappingForChargeConfig = this.configurationDomainServiceJpa.getAccountMappingForCharge();
        List expenseAccountOptions = this.accountingDropdownReadPlatformService.retrieveExpenseAccountOptions();
        List assetAccountOptions = this.accountingDropdownReadPlatformService.retrieveAssetAccountOptions();
        return ChargeData.builder().currencyOptions((Collection)currencyOptions).chargeCalculationTypeOptions(allowedChargeCalculationTypeOptions).chargeAppliesToOptions(allowedChargeAppliesToOptions).chargeTimeTypeOptions(allowedChargeTimeOptions).chargePaymetModeOptions(chargePaymentOptions).loanChargeCalculationTypeOptions(loansChargeCalculationTypeOptions).loanChargeTimeTypeOptions(loansChargeTimeTypeOptions).savingsChargeCalculationTypeOptions(savingsChargeCalculationTypeOptions).savingsChargeTimeTypeOptions(savingsChargeTimeTypeOptions).clientChargeCalculationTypeOptions(clientChargeCalculationTypeOptions).clientChargeTimeTypeOptions(clientChargeTimeTypeOptions).feeFrequencyOptions(feeFrequencyOptions).incomeOrLiabilityAccountOptions(incomeOrLiabilityAccountOptions).taxGroupOptions((Collection)taxGroupOptions).shareChargeCalculationTypeOptions(shareChargeCalculationTypeOptions).shareChargeTimeTypeOptions(shareChargeTimeTypeOptions).accountMappingForChargeConfig(accountMappingForChargeConfig).expenseAccountOptions(expenseAccountOptions).assetAccountOptions(assetAccountOptions).build();
    }

    public List<ChargeData> retrieveLoanProductCharges(Long loanProductId) {
        ChargeMapper rm = new ChargeMapper();
        String sql = "select " + rm.loanProductChargeSchema() + " where c.is_deleted=false and c.is_active=true and plc.product_loan_id=? ";
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{loanProductId});
    }

    public List<ChargeData> retrieveLoanProductCharges(Long loanProductId, ChargeTimeType chargeTime) {
        ChargeMapper rm = new ChargeMapper();
        String sql = "select " + rm.loanProductChargeSchema() + " where c.is_deleted=false and c.is_active=true and plc.product_loan_id=? and c.charge_time_enum=? ";
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{loanProductId, chargeTime.getValue()});
    }

    public List<ChargeData> retrieveLoanApplicableFees() {
        ChargeMapper rm = new ChargeMapper();
        Object[] params = new Object[]{ChargeAppliesTo.LOAN.getValue()};
        String sql = "select " + rm.chargeSchema() + " where c.is_deleted=false and c.is_active=true and c.is_penalty=false and c.charge_applies_to_enum=? ";
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        sql = sql + " order by c.name ";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, params);
    }

    public List<ChargeData> retrieveLoanAccountApplicableCharges(Long loanId, ChargeTimeType[] excludeChargeTimes) {
        ChargeMapper rm = new ChargeMapper();
        StringBuilder excludeClause = new StringBuilder("");
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("loanId", loanId);
        paramMap.put("chargeAppliesTo", ChargeAppliesTo.LOAN.getValue());
        this.processChargeExclusionsForLoans(excludeChargeTimes, excludeClause);
        String sql = "select " + rm.chargeSchema() + " join m_loan la on la.currency_code = c.currency_code where la.id=:loanId and c.is_deleted=false and c.is_active=true and c.charge_applies_to_enum=:chargeAppliesTo" + String.valueOf(excludeClause) + " ";
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        sql = sql + " order by c.name ";
        return this.namedParameterJdbcTemplate.query(sql, paramMap, (RowMapper)rm);
    }

    private void processChargeExclusionsForLoans(ChargeTimeType[] excludeChargeTimes, StringBuilder excludeClause) {
        if (excludeChargeTimes != null && excludeChargeTimes.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < excludeChargeTimes.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(excludeChargeTimes[i].getValue());
            }
            excludeClause = excludeClause.append(" and c.charge_time_enum not in(" + sb.toString() + ") ");
            excludeClause.append(" ");
        }
    }

    public List<ChargeData> retrieveLoanProductApplicableCharges(Long loanProductId, ChargeTimeType[] excludeChargeTimes) {
        ChargeMapper rm = new ChargeMapper();
        StringBuilder excludeClause = new StringBuilder("");
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("productId", loanProductId);
        paramMap.put("chargeAppliesTo", ChargeAppliesTo.LOAN.getValue());
        this.processChargeExclusionsForLoans(excludeChargeTimes, excludeClause);
        String sql = "select " + rm.chargeSchema() + " join m_product_loan lp on lp.currency_code = c.currency_code where lp.id=:productId and c.is_deleted=false and c.is_active=true and c.charge_applies_to_enum=:chargeAppliesTo" + String.valueOf(excludeClause) + " ";
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        sql = sql + " order by c.name ";
        return this.namedParameterJdbcTemplate.query(sql, paramMap, (RowMapper)rm);
    }

    public List<ChargeData> retrieveLoanApplicablePenalties() {
        ChargeMapper rm = new ChargeMapper();
        String sql = "select " + rm.chargeSchema() + " where c.is_deleted=false and c.is_active=true and c.is_penalty=true and c.charge_applies_to_enum=? ";
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        sql = sql + " order by c.name ";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{ChargeAppliesTo.LOAN.getValue()});
    }

    private String addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled() {
        Object sql = "";
        String inClause = this.fineractEntityAccessUtil.getSQLWhereClauseForProductIDsForUserOffice_ifGlobalConfigEnabled(FineractEntityType.CHARGE);
        if (inClause != null && !inClause.trim().isEmpty()) {
            sql = (String)sql + " and c.id in ( " + inClause + " ) ";
        }
        return sql;
    }

    public List<ChargeData> retrieveSavingsProductApplicableCharges(boolean feeChargesOnly) {
        ChargeMapper rm = new ChargeMapper();
        String sql = "select " + rm.chargeSchema() + " where c.is_deleted=false and c.is_active=true and c.charge_applies_to_enum=? ";
        if (feeChargesOnly) {
            sql = "select " + rm.chargeSchema() + " where c.is_deleted=false and c.is_active=true and c.is_penalty=false and c.charge_applies_to_enum=? ";
        }
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        sql = sql + " order by c.name ";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{ChargeAppliesTo.SAVINGS.getValue()});
    }

    public List<ChargeData> retrieveSavingsApplicablePenalties() {
        ChargeMapper rm = new ChargeMapper();
        String sql = "select " + rm.chargeSchema() + " where c.is_deleted=false and c.is_active=true and c.is_penalty=true and c.charge_applies_to_enum=? ";
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        sql = sql + " order by c.name ";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{ChargeAppliesTo.SAVINGS.getValue()});
    }

    public List<ChargeData> retrieveSavingsProductCharges(Long savingsProductId) {
        ChargeMapper rm = new ChargeMapper();
        String sql = "select " + rm.savingsProductChargeSchema() + " where c.is_deleted=false and c.is_active=true and spc.savings_product_id=? ";
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{savingsProductId});
    }

    public List<ChargeData> retrieveShareProductCharges(Long shareProductId) {
        ChargeMapper rm = new ChargeMapper();
        String sql = "select " + rm.shareProductChargeSchema() + " where c.is_deleted=false and c.is_active=true and mspc.product_id=? ";
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{shareProductId});
    }

    public List<ChargeData> retrieveSavingsAccountApplicableCharges(Long savingsAccountId) {
        ChargeMapper rm = new ChargeMapper();
        String sql = "select " + rm.chargeSchema() + " join m_savings_account sa on sa.currency_code = c.currency_code where c.is_deleted=false and c.is_active=true and c.charge_applies_to_enum=?  and sa.id = ?";
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{ChargeAppliesTo.SAVINGS.getValue(), savingsAccountId});
    }

    public List<ChargeData> retrieveAllChargesApplicableToClients() {
        ChargeMapper rm = new ChargeMapper();
        String sql = "select " + rm.chargeSchema() + " where c.is_deleted=false and c.is_active=true and c.charge_applies_to_enum=? ";
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        sql = sql + " order by c.name ";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{ChargeAppliesTo.CLIENT.getValue()});
    }

    public List<ChargeData> retrieveSharesApplicableCharges() {
        ChargeMapper rm = new ChargeMapper();
        String sql = "select " + rm.chargeSchema() + " where c.is_deleted=false and c.is_active=true and c.charge_applies_to_enum=? ";
        sql = sql + this.addInClauseToSQL_toLimitChargesMappedToOffice_ifOfficeSpecificProductsEnabled();
        sql = sql + " order by c.name ";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{ChargeAppliesTo.SHARES.getValue()});
    }

    @Generated
    public ChargeReadPlatformServiceImpl(CurrencyReadPlatformService currencyReadPlatformService, ChargeDropdownReadPlatformService chargeDropdownReadPlatformService, JdbcTemplate jdbcTemplate, DropdownReadPlatformService dropdownReadPlatformService, FineractEntityAccessUtil fineractEntityAccessUtil, AccountingDropdownReadPlatformService accountingDropdownReadPlatformService, TaxReadPlatformService taxReadPlatformService, ConfigurationDomainServiceJpa configurationDomainServiceJpa, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.currencyReadPlatformService = currencyReadPlatformService;
        this.chargeDropdownReadPlatformService = chargeDropdownReadPlatformService;
        this.jdbcTemplate = jdbcTemplate;
        this.dropdownReadPlatformService = dropdownReadPlatformService;
        this.fineractEntityAccessUtil = fineractEntityAccessUtil;
        this.accountingDropdownReadPlatformService = accountingDropdownReadPlatformService;
        this.taxReadPlatformService = taxReadPlatformService;
        this.configurationDomainServiceJpa = configurationDomainServiceJpa;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

