/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.api;

import com.google.gson.JsonElement;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookPopulatorService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.ApiFacingEnum;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.CommandParameterUtil;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksReadService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.PortfolioAccountDTO;
import org.apache.fineract.portfolio.account.data.PortfolioAccountData;
import org.apache.fineract.portfolio.account.service.AccountAssociationsReadPlatformService;
import org.apache.fineract.portfolio.account.service.PortfolioAccountReadPlatformService;
import org.apache.fineract.portfolio.accountdetails.service.AccountDetailsReadPlatformService;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.service.CalendarReadPlatformService;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.charge.domain.ChargeTimeType;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.collateralmanagement.data.LoanCollateralResponseData;
import org.apache.fineract.portfolio.collateralmanagement.service.LoanCollateralManagementReadPlatformService;
import org.apache.fineract.portfolio.common.domain.DaysInYearCustomStrategyType;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.delinquency.api.DelinquencyApiResourceSwagger;
import org.apache.fineract.portfolio.delinquency.data.LoanDelinquencyTagHistoryData;
import org.apache.fineract.portfolio.delinquency.service.DelinquencyReadPlatformService;
import org.apache.fineract.portfolio.delinquency.validator.LoanDelinquencyActionData;
import org.apache.fineract.portfolio.fund.service.FundReadPlatformService;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.fineract.portfolio.group.service.GroupReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.api.LoanApiConstants;
import org.apache.fineract.portfolio.loanaccount.api.LoansApiResourceSwagger;
import org.apache.fineract.portfolio.loanaccount.data.CollectionData;
import org.apache.fineract.portfolio.loanaccount.data.GlimRepaymentTemplate;
import org.apache.fineract.portfolio.loanaccount.data.LoanAccountData;
import org.apache.fineract.portfolio.loanaccount.data.LoanApprovalData;
import org.apache.fineract.portfolio.loanaccount.data.LoanApprovedAmountHistoryData;
import org.apache.fineract.portfolio.loanaccount.data.LoanCollateralManagementData;
import org.apache.fineract.portfolio.loanaccount.data.LoanSummaryData;
import org.apache.fineract.portfolio.loanaccount.data.PaidInAdvanceData;
import org.apache.fineract.portfolio.loanaccount.data.RepaymentScheduleRelatedLoanData;
import org.apache.fineract.portfolio.loanaccount.domain.LoanApprovedAmountHistoryRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeCalculationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeIncomeType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeCalculationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.loanaccount.domain.LoanSummaryBalancesRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTermVariationType;
import org.apache.fineract.portfolio.loanaccount.exception.LoanTemplateTypeRequiredException;
import org.apache.fineract.portfolio.loanaccount.exception.NotSupportedLoanTemplateTypeException;
import org.apache.fineract.portfolio.loanaccount.guarantor.service.GuarantorReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleModel;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleProcessingType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleCalculationPlatformService;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleHistoryReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.repository.LoanCapitalizedIncomeBalanceRepository;
import org.apache.fineract.portfolio.loanaccount.rescheduleloan.domain.LoanTermVariationsRepository;
import org.apache.fineract.portfolio.loanaccount.service.GLIMAccountInfoReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanSummaryDataProvider;
import org.apache.fineract.portfolio.loanaccount.service.LoanSummaryProviderDelegate;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;
import org.apache.fineract.portfolio.loanproduct.domain.InterestMethod;
import org.apache.fineract.portfolio.loanproduct.service.LoanDropdownReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.service.LoanEnumerations;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.apache.fineract.portfolio.note.domain.NoteType;
import org.apache.fineract.portfolio.note.service.NoteReadPlatformService;
import org.apache.fineract.portfolio.rate.service.RateReadService;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountStatusType;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Path(value="/v1/loans")
@Component
@Tag(name="Loans", description="The API concept of loans models the loan application process and the loan contract/monitoring process.\n\nField Descriptions\naccountNo\nThe account no. associated with this loan. Is auto generated if not provided at loan application creation time.\nexternalId\nA place to put an external reference for this loan e.g. The ID another system uses.\nIf provided, it must be unique.\nfundId\nOptional: For associating a loan with a given fund.\nloanOfficerId\nOptional: For associating a loan with a given staff member who is a loan officer.\nloanPurposeId\nOptional: For marking a loan with a given loan purpose option. Loan purposes are configurable and can be setup by system admin through code/code values screens.\nprincipal\nThe loan amount to be disbursed to through loan.\nloanTermFrequency\nThe length of loan term\nUsed like: loanTermFrequency loanTermFrequencyType\ne.g. 12 Months\nloanTermFrequencyType\nThe loan term period to use. Used like: loanTermFrequency loanTermFrequencyType\ne.g. 12 Months Example Values: 0=Days, 1=Weeks, 2=Months, 3=Years\nnumberOfRepayments\nNumber of installments to repay.\nUsed like: numberOfRepayments Every repaymentEvery repaymentFrequencyType\ne.g. 10 (repayments) Every 12 Weeks\nrepaymentEvery\nUsed like: numberOfRepayments Every repaymentEvery repaymentFrequencyType\ne.g. 10 (repayments) Every 12 Weeks\nrepaymentFrequencyType\nUsed like: numberOfRepayments Every repaymentEvery repaymentFrequencyType\ne.g. 10 (repayments) Every 12 Weeks \nExample Values: 0=Days, 1=Weeks, 2=Months\ninterestRatePerPeriod\nInterest Rate.\nUsed like: interestRatePerPeriod % interestRateFrequencyType - interestType\ne.g. 12.0000% Per year - Declining Balance\ninterestRateFrequencyType\nUsed like: interestRatePerPeriod% interestRateFrequencyType - interestType\ne.g. 12.0000% Per year - Declining Balance \nExample Values: 2=Per month, 3=Per year\ngraceOnPrincipalPayment\nOptional: Integer - represents the number of repayment periods that grace should apply to the principal component of a repayment period.\ngraceOnInterestPayment\nOptional: Integer - represents the number of repayment periods that grace should apply to the interest component of a repayment period. Interest is still calculated but offset to later repayment periods.\ngraceOnInterestCharged\nOptional: Integer - represents the number of repayment periods that should be interest-free.\ngraceOnArrearsAgeing\nOptional: Integer - Used in Arrears calculation to only take into account loans that are more than graceOnArrearsAgeing days overdue.\ninterestChargedFromDate\nOptional: Date - The date from with interest is to start being charged.\nexpectedDisbursementDate\nThe proposed disbursement date of the loan so a proposed repayment schedule can be provided.\nsubmittedOnDate\nThe date the loan application was submitted by applicant.\nlinkAccountId\nThe Savings Account id for linking with loan account for payments.\namortizationType\nExample Values: 0=Equal principle payments, 1=Equal installments\ninterestType\nUsed like: interestRatePerPeriod% interestRateFrequencyType - interestType\ne.g. 12.0000% Per year - Declining Balance \nExample Values: 0=Declining Balance, 1=Flat\ninterestCalculationPeriodType\nExample Values: 0=Daily, 1=Same as repayment period\nallowPartialPeriodInterestCalcualtion\nThis value will be supported along with interestCalculationPeriodType as Same as repayment period to calculate interest for partial periods. Example: Interest charged from is 5th of April , Principal is 10000 and interest is 1% per month then the interest will be (10000 * 1%)* (25/30) , it calculates for the month first then calculates exact periods between start date and end date(can be a decimal)\ninArrearsTolerance\nThe amount that can be 'waived' at end of all loan payments because it is too small to worry about.\nThis is also the tolerance amount assessed when determining if a loan is in arrears.\ntransactionProcessingStrategyCode\nAn enumeration that indicates the type of transaction processing strategy to be used. This relates to functionality that is also known as Payment Application Logic.\nA number of out of the box approaches exist, some are custom to specific MFIs, some are more general and indicate the order in which payments are processed.\n\nRefer to the Payment Application Logic / Transaction Processing Strategy section in the appendix for more detailed overview of each available payment application logic provided out of the box.\n\nList of current approaches:\n1 = Mifos style (Similar to Old Mifos)\n2 = Heavensfamily (Custom MFI approach)\n3 = Creocore (Custom MFI approach)\n4 = RBI (India)\n5 = Principal Interest Penalties Fees Order\n6 = Interest Principal Penalties Fees Order\n7 = Early Payment Strategy\nloanType\nTo represent different type of loans.\nAt present there are three type of loans are supported. \nAvailable loan types:\nindividual: Loan given to individual member\ngroup: Loan given to group as a whole\njlg: Joint liability group loan given to members in a group on individual basis. JLG loan can be given to one or more members in a group.\nrecalculationRestFrequencyDate\nSpecifies rest frequency start date for interest recalculation. This date must be before or equal to disbursement date\nrecalculationCompoundingFrequencyDate\nSpecifies compounding frequency start date for interest recalculation. This date must be equal to disbursement date")
public class LoansApiResource {
    private static final Set<String> LOAN_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "accountNo", "status", "externalId", "clientId", "group", "loanProductId", "loanProductName", "loanProductDescription", "isLoanProductLinkedToFloatingRate", "fundId", "fundName", "loanPurposeId", "loanPurposeName", "loanOfficerId", "loanOfficerName", "currency", "principal", "totalOverpaid", "inArrearsTolerance", "termFrequency", "termPeriodFrequencyType", "numberOfRepayments", "repaymentEvery", "interestRatePerPeriod", "annualInterestRate", "repaymentFrequencyType", "transactionProcessingStrategyCode", "transactionProcessingStrategyName", "interestRateFrequencyType", "amortizationType", "interestType", "interestCalculationPeriodType", "allowPartialPeriodInterestCalcualtion", "expectedFirstRepaymentOnDate", "graceOnPrincipalPayment", "recurringMoratoriumOnPrincipalPeriods", "graceOnInterestPayment", "graceOnInterestCharged", "interestChargedFromDate", "timeline", "totalFeeChargesAtDisbursement", "summary", "repaymentSchedule", "transactions", "charges", "collateral", "guarantors", "meeting", "productOptions", "amortizationTypeOptions", "interestTypeOptions", "interestCalculationPeriodTypeOptions", "repaymentFrequencyTypeOptions", "repaymentFrequencyNthDayTypeOptions", "repaymentFrequencyDaysOfWeekTypeOptions", "termFrequencyTypeOptions", "interestRateFrequencyTypeOptions", "fundOptions", "repaymentStrategyOptions", "chargeOptions", "loanOfficerOptions", "loanPurposeOptions", "loanCollateralOptions", "chargeTemplate", "calendarOptions", "syncDisbursementWithMeeting", "loanCounter", "loanProductCounter", "notes", "accountLinkingOptions", "linkedAccount", "interestRateDifferential", "isFloatingInterestRate", "interestRatesPeriods", "lastClosedBusinessDate", "canUseForTopup", "isTopup", "loanIdToClose", "topupAmount", "clientActiveLoanOptions", "datatables", "rates", "multiDisburseDetails", "emiAmountVariations", "collection", "interestRecognitionOnDisbursementDate", "daysInYearCustomStrategy"));
    private static final Set<String> LOAN_APPROVAL_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("approvalDate", "approvalAmount"));
    private static final Set<String> GLIM_ACCOUNTS_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("glimId", "groupId", "clientId", "parentLoanAccountNo", "parentPrincipalAmount", "childLoanAccountNo", "childPrincipalAmount", "clientName"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "LOAN";
    private static final String RESOURCE_NAME_FOR_DELINQUENCY_ACTION_PERMISSIONS = "DELINQUENCY_ACTION";
    private final PlatformSecurityContext context;
    private final LoanReadPlatformService loanReadPlatformService;
    private final LoanProductReadPlatformService loanProductReadPlatformService;
    private final LoanDropdownReadPlatformService dropdownReadPlatformService;
    private final FundReadPlatformService fundReadPlatformService;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final LoanChargeReadPlatformService loanChargeReadPlatformService;
    private final LoanScheduleCalculationPlatformService calculationPlatformService;
    private final GuarantorReadPlatformService guarantorReadPlatformService;
    private final CodeValueReadPlatformService codeValueReadPlatformService;
    private final GroupReadPlatformService groupReadPlatformService;
    private final DefaultToApiJsonSerializer<LoanAccountData> toApiJsonSerializer;
    private final DefaultToApiJsonSerializer<LoanApprovalData> loanApprovalDataToApiJsonSerializer;
    private final DefaultToApiJsonSerializer<LoanScheduleData> loanScheduleToApiJsonSerializer;
    private final DefaultToApiJsonSerializer<LoanDelinquencyActionData> delinquencyActionSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final FromJsonHelper fromJsonHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final CalendarReadPlatformService calendarReadPlatformService;
    private final NoteReadPlatformService noteReadPlatformService;
    private final PortfolioAccountReadPlatformService portfolioAccountReadPlatformService;
    private final AccountAssociationsReadPlatformService accountAssociationsReadPlatformService;
    private final LoanScheduleHistoryReadPlatformService loanScheduleHistoryReadPlatformService;
    private final AccountDetailsReadPlatformService accountDetailsReadPlatformService;
    private final EntityDatatableChecksReadService entityDatatableChecksReadService;
    private final BulkImportWorkbookService bulkImportWorkbookService;
    private final BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService;
    private final RateReadService rateReadService;
    private final ConfigurationDomainService configurationDomainService;
    private final DefaultToApiJsonSerializer<GlimRepaymentTemplate> glimTemplateToApiJsonSerializer;
    private final GLIMAccountInfoReadPlatformService glimAccountInfoReadPlatformService;
    private final LoanCollateralManagementReadPlatformService loanCollateralManagementReadPlatformService;
    private final DefaultToApiJsonSerializer<LoanDelinquencyTagHistoryData> jsonSerializerTagHistory;
    private final DelinquencyReadPlatformService delinquencyReadPlatformService;
    private final SqlValidator sqlValidator;
    private final LoanSummaryBalancesRepository loanSummaryBalancesRepository;
    private final ClientReadPlatformService clientReadPlatformService;
    private final LoanTermVariationsRepository loanTermVariationsRepository;
    private final LoanSummaryProviderDelegate loanSummaryProviderDelegate;
    private final LoanCapitalizedIncomeBalanceRepository loanCapitalizedIncomeBalanceRepository;
    private final LoanApprovedAmountHistoryRepository loanApprovedAmountHistoryRepository;

    @GET
    @Path(value="{loanId}/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.GetLoansApprovalTemplateResponse.class))})})
    public String retrieveApprovalTemplate(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @QueryParam(value="templateType") @Parameter(description="templateType") String templateType, @Context UriInfo uriInfo) {
        return this.retrieveApprovalTemplate(loanId, null, templateType, uriInfo);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Loan Details Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed description Lists\nExample Requests:\n\nloans/template?templateType=individual&clientId=1\n\n\nloans/template?templateType=individual&clientId=1&productId=1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.GetLoansTemplateResponse.class))})})
    public String template(@QueryParam(value="clientId") @Parameter(description="clientId") Long clientId, @QueryParam(value="groupId") @Parameter(description="groupId") Long groupId, @QueryParam(value="productId") @Parameter(description="productId") Long productId, @QueryParam(value="templateType") @Parameter(description="templateType") String templateType, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly, @DefaultValue(value="false") @QueryParam(value="activeOnly") @Parameter(description="activeOnly") boolean onlyActive, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection productOptions = this.loanProductReadPlatformService.retrieveAllLoanProductsForLookup(onlyActive);
        Collection calendarOptions = null;
        LoanAccountData newLoanAccount = new LoanAccountData();
        LocalDate expectedDisbursementDate = DateUtils.getBusinessLocalDate();
        Long officeId = null;
        ArrayList accountLinkingOptions = null;
        boolean isRatesEnabled = this.configurationDomainService.isSubRatesEnabled();
        if (productId != null) {
            newLoanAccount = this.loanReadPlatformService.retrieveLoanProductDetailsTemplate(productId, clientId, groupId);
        }
        if (templateType == null) {
            String errorMsg = "Loan template type must be provided";
            throw new LoanTemplateTypeRequiredException("Loan template type must be provided");
        }
        if (templateType.equals("collateral")) {
            List loanCollateralOptions = this.codeValueReadPlatformService.retrieveCodeValuesByCode("LoanCollateral");
            newLoanAccount = newLoanAccount.setLoanCollateralOptions((Collection)loanCollateralOptions);
        } else {
            switch (templateType) {
                case "individual": 
                case "jlg": {
                    if (clientId != null) {
                        ClientData clientData = this.clientReadPlatformService.retrieveOne(clientId);
                        officeId = clientData.getOfficeId();
                        newLoanAccount = newLoanAccount.withClientData(clientData).withExpectedDisbursementDate(expectedDisbursementDate);
                    }
                    if (!templateType.equals("jlg")) break;
                    GroupGeneralData groupData = this.groupReadPlatformService.retrieveOne(groupId);
                    newLoanAccount = newLoanAccount.setGroup(groupData);
                    calendarOptions = this.loanReadPlatformService.retrieveCalendars(groupId);
                    break;
                }
                case "group": {
                    GroupGeneralData groupData = this.groupReadPlatformService.retrieveOne(groupId);
                    officeId = groupData.getOfficeId();
                    calendarOptions = this.loanReadPlatformService.retrieveCalendars(groupId);
                    newLoanAccount = newLoanAccount.setGroup(groupData).withExpectedDisbursementDate(expectedDisbursementDate);
                    accountLinkingOptions = this.getAccountLinkingOptions(newLoanAccount, clientId, groupId);
                    break;
                }
                case "jlgbulk": {
                    GroupGeneralData groupData = this.groupReadPlatformService.retrieveGroupAndMembersDetails(groupId);
                    officeId = groupData.getOfficeId();
                    calendarOptions = this.loanReadPlatformService.retrieveCalendars(groupId);
                    newLoanAccount = newLoanAccount.setGroup(groupData).withExpectedDisbursementDate(expectedDisbursementDate);
                    if (productId == null) break;
                    HashMap<Long, Integer> memberLoanCycle = new HashMap<Long, Integer>();
                    Collection members = groupData.clientMembers();
                    accountLinkingOptions = new ArrayList();
                    if (members != null) {
                        for (ClientData clientData : members) {
                            Integer loanCounter = this.loanReadPlatformService.retriveLoanCounter(clientData.getId(), productId);
                            memberLoanCycle.put(clientData.getId(), loanCounter);
                            accountLinkingOptions.addAll(this.getAccountLinkingOptions(newLoanAccount, clientData.getId(), groupId));
                        }
                    }
                    newLoanAccount = newLoanAccount.associateMemberVariations(memberLoanCycle);
                    break;
                }
                default: {
                    String errorMsg = "Loan template type '" + templateType + "' is not supported";
                    throw new NotSupportedLoanTemplateTypeException(errorMsg, new Object[]{templateType});
                }
            }
            Collection allowedLoanOfficers = this.loanReadPlatformService.retrieveAllowedLoanOfficers(officeId, staffInSelectedOfficeOnly);
            if (clientId != null) {
                accountLinkingOptions = this.getAccountLinkingOptions(newLoanAccount, clientId, groupId);
            }
            newLoanAccount = newLoanAccount.associationsAndTemplate(productOptions, allowedLoanOfficers, calendarOptions, (Collection)accountLinkingOptions, Boolean.valueOf(isRatesEnabled));
        }
        List datatableTemplates = this.entityDatatableChecksReadService.retrieveTemplates(StatusEnum.CREATE.getValue(), EntityTables.LOAN.getName(), productId);
        newLoanAccount.setDatatables(datatableTemplates);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)newLoanAccount, LOAN_DATA_PARAMETERS);
    }

    private Collection<PortfolioAccountData> getAccountLinkingOptions(LoanAccountData newLoanAccount, Long clientId, Long groupId) {
        CurrencyData currencyData = newLoanAccount.getCurrency();
        String currencyCode = null;
        if (currencyData != null) {
            currencyCode = currencyData.getCode();
        }
        long[] accountStatus = new long[]{SavingsAccountStatusType.ACTIVE.getValue().intValue()};
        PortfolioAccountDTO portfolioAccountDTO = new PortfolioAccountDTO(PortfolioAccountType.SAVINGS.getValue(), clientId, currencyCode, accountStatus, DepositAccountType.SAVINGS_DEPOSIT.getValue());
        if (groupId != null) {
            portfolioAccountDTO.setGroupId(groupId);
        }
        return this.portfolioAccountReadPlatformService.retrieveAllForLookup(portfolioAccountDTO);
    }

    @GET
    @Path(value="{loanId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Loan", description="Note: template=true parameter doesn't apply to this resource.Example Requests:\n\nloans/1\n\n\nloans/1?fields=id,principal,annualInterestRate\n\n\nloans/1?associations=all\n\nloans/1?associations=all&exclude=guarantors\n\n\nloans/1?fields=id,principal,annualInterestRate&associations=repaymentSchedule,transactions")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.GetLoansLoanIdResponse.class))})})
    public String retrieveLoan(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly, @DefaultValue(value="all") @QueryParam(value="associations") @Parameter(in=ParameterIn.QUERY, name="associations", description="Loan object relations to be included in the response", required=false, examples={@ExampleObject(value="all"), @ExampleObject(value="repaymentSchedule,transactions")}) String associations, @QueryParam(value="exclude") @Parameter(in=ParameterIn.QUERY, name="exclude", description="Optional Loan object relation list to be filtered in the response", required=false, example="guarantors,futureSchedule") String exclude, @QueryParam(value="fields") @Parameter(in=ParameterIn.QUERY, name="fields", description="Optional Loan attribute list to be in the response", required=false, example="id,principal,annualInterestRate") String fields, @Context UriInfo uriInfo) {
        return this.retrieveLoan(loanId, null, staffInSelectedOfficeOnly, exclude, uriInfo);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Loans", description="The list capability of loans can support pagination and sorting.\nExample Requests:\n\nloans\n\nloans?fields=accountNo\n\nloans?offset=10&limit=50\n\nloans?orderBy=accountNo&sortOrder=DESC")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.GetLoansResponse.class))})})
    public String retrieveAll(@Context UriInfo uriInfo, @QueryParam(value="externalId") @Parameter(description="externalId") String externalId, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder, @QueryParam(value="accountNo") @Parameter(description="accountNo") String accountNo, @QueryParam(value="associations") @Parameter(description="associations") String associations, @QueryParam(value="clientId") @Parameter(description="clientId") Long clientId, @QueryParam(value="status") @Parameter(description="status") String status) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        this.sqlValidator.validate(accountNo);
        this.sqlValidator.validate(externalId);
        SearchParameters searchParameters = SearchParameters.builder().accountNo(accountNo).sortOrder(sortOrder).externalId(externalId).offset(offset).limit(limit).orderBy(orderBy).status(status).clientId(clientId).build();
        Page loanBasicDetails = this.loanReadPlatformService.retrieveAll(searchParameters);
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        if (associationParameters.contains("summary")) {
            List<Long> loanIds = loanBasicDetails.getPageItems().stream().map(LoanAccountData::getId).toList();
            Map disbursementDataByLoanIds = this.loanReadPlatformService.retrieveLoanDisbursementDetails(loanIds);
            Map repaymentPeriodDataByLoanIds = this.loanCapitalizedIncomeBalanceRepository.findRepaymentPeriodDataByLoanIds(loanIds);
            Map loanTransactionBalancesByLoanIds = this.loanSummaryBalancesRepository.retrieveLoanSummaryBalancesByTransactionType(loanIds, LoanApiConstants.LOAN_SUMMARY_TRANSACTION_TYPES);
            loanBasicDetails.getPageItems().forEach(i -> {
                if (i.getSummary() != null) {
                    Long loanId = i.getId();
                    List disbursementData = disbursementDataByLoanIds.getOrDefault(loanId, Collections.emptyList());
                    List capitalizedIncomeData = repaymentPeriodDataByLoanIds.getOrDefault(loanId, Collections.emptyList());
                    List loanTransactionBalances = loanTransactionBalancesByLoanIds.getOrDefault(loanId, Collections.emptyList());
                    RepaymentScheduleRelatedLoanData repaymentScheduleRelatedData = new RepaymentScheduleRelatedLoanData(i.getTimeline().getExpectedDisbursementDate(), i.getTimeline().getActualDisbursementDate(), i.getCurrency(), i.getPrincipal(), i.getInArrearsTolerance(), i.getFeeChargesAtDisbursementCharged());
                    LoanScheduleData repaymentSchedule = this.loanReadPlatformService.retrieveRepaymentSchedule(loanId, repaymentScheduleRelatedData, disbursementData, capitalizedIncomeData, i.isInterestRecalculationEnabled(), LoanScheduleType.fromEnumOptionData((EnumOptionData)i.getLoanScheduleType()));
                    LoanSummaryDataProvider loanSummaryDataProvider = this.loanSummaryProviderDelegate.resolveLoanSummaryDataProvider(i.getTransactionProcessingStrategyCode());
                    LoanSummaryData summaryData = loanSummaryDataProvider.withTransactionAmountsSummary(loanId, i.getSummary(), repaymentSchedule, loanTransactionBalances);
                    i.setSummary(summaryData);
                }
            });
        }
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, loanBasicDetails, LOAN_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Calculate loan repayment schedule | Submit a new Loan Application", description="It calculates the loan repayment Schedule\nSubmits a new loan application\nMandatory Fields: clientId, productId, principal, loanTermFrequency, loanTermFrequencyType, loanType, numberOfRepayments, repaymentEvery, repaymentFrequencyType, interestRatePerPeriod, amortizationType, interestType, interestCalculationPeriodType, transactionProcessingStrategyCode, expectedDisbursementDate, submittedOnDate, loanType\nOptional Fields: graceOnPrincipalPayment, graceOnInterestPayment, graceOnInterestCharged, linkAccountId, allowPartialPeriodInterestCalcualtion, fixedEmiAmount, maxOutstandingLoanBalance, disbursementData, graceOnArrearsAgeing, createStandingInstructionAtDisbursement (requires linkedAccountId if set to true)\nAdditional Mandatory Fields if interest recalculation is enabled for product and Rest frequency not same as repayment period: recalculationRestFrequencyDate\nAdditional Mandatory Fields if interest recalculation with interest/fee compounding is enabled for product and compounding frequency not same as repayment period: recalculationCompoundingFrequencyDate\nAdditional Mandatory Field if Entity-Datatable Check is enabled for the entity of type loan: datatables")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PostLoansRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PostLoansResponse.class))})})
    public String calculateLoanScheduleOrSubmitLoanApplication(@QueryParam(value="command") @Parameter(description="command") String commandParam, @Context UriInfo uriInfo, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        if (CommandParameterUtil.is((String)commandParam, (String)"calculateLoanSchedule")) {
            JsonElement parsedQuery = this.fromJsonHelper.parse(apiRequestBodyAsJson);
            JsonQuery query = JsonQuery.from((String)apiRequestBodyAsJson, (JsonElement)parsedQuery, (FromJsonHelper)this.fromJsonHelper);
            LoanScheduleModel loanSchedule = this.calculationPlatformService.calculateLoanSchedule(query, Boolean.valueOf(true));
            ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
            return this.loanScheduleToApiJsonSerializer.serialize(settings, (Object)loanSchedule.toData(), new HashSet());
        }
        CommandWrapper commandRequest = new CommandWrapperBuilder().createLoanApplication().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{loanId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Modify a loan application", description="Loan application can only be modified when in 'Submitted and pending approval' state. Once the application is approved, the details cannot be changed using this method.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PutLoansLoanIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PutLoansLoanIdResponse.class))})})
    public String modifyLoanApplication(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.modifyLoanApplication(loanId, null, commandParam, apiRequestBodyAsJson);
    }

    @DELETE
    @Path(value="{loanId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Loan Application", description="Note: Only loans in \"Submitted and awaiting approval\" status can be deleted.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.DeleteLoansLoanIdResponse.class))})})
    public String deleteLoanApplication(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId) {
        return this.deleteLoanApplication(loanId, null);
    }

    @POST
    @Path(value="{loanId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Approve Loan Application | Recover Loan Guarantee | Undo Loan Application Approval | Assign a Loan Officer | Unassign a Loan Officer | Reject Loan Application | Applicant Withdraws from Loan Application | Disburse Loan Disburse Loan To Savings Account | Undo Loan Disbursal", description="Approve Loan Application:\nMandatory Fields: approvedOnDate\nOptional Fields: approvedLoanAmount and expectedDisbursementDate\nApproves the loan application\n\nRecover Loan Guarantee:\nRecovers the loan guarantee\n\nUndo Loan Application Approval:\nUndoes the Loan Application Approval\n\nAssign a Loan Officer:\nAllows you to assign Loan Officer for existing Loan.\n\nUnassign a Loan Officer:\nAllows you to unassign the Loan Officer.\n\nReject Loan Application:\nMandatory Fields: rejectedOnDate\nAllows you to reject the loan application\n\nApplicant Withdraws from Loan Application:\nMandatory Fields: withdrawnOnDate\nAllows the applicant to withdraw the loan application\n\nDisburse Loan:\nMandatory Fields: actualDisbursementDate\nOptional Fields: transactionAmount and fixedEmiAmount\nDisburses the Loan\n\nDisburse Loan To Savings Account:\nMandatory Fields: actualDisbursementDate\nOptional Fields: transactionAmount and fixedEmiAmount\nDisburses the loan to Saving Account\n\nUndo Loan Disbursal:\nUndoes the Loan Disbursal\nShowing request and response for Assign a Loan Officer")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PostLoansLoanIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PostLoansLoanIdResponse.class))})})
    public String stateTransitions(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.stateTransitions(loanId, null, commandParam, apiRequestBodyAsJson);
    }

    @GET
    @Path(value="downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getLoansTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="staffId") Long staffId, @QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.LOANS.toString(), officeId, staffId, dateFormat);
    }

    @GET
    @Path(value="glimAccount/{glimId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getGlimRepaymentTemplate(@PathParam(value="glimId") Long glimId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection glimRepaymentTemplate = this.glimAccountInfoReadPlatformService.findglimRepaymentTemplate(glimId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.glimTemplateToApiJsonSerializer.serialize(settings, glimRepaymentTemplate, GLIM_ACCOUNTS_DATA_PARAMETERS);
    }

    @POST
    @Path(value="glimAccount/{glimId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Approve GLIM Application | Undo GLIM Application Approval | Reject GLIM Application | Disburse Loan Disburse Loan To Savings Account | Undo Loan Disbursal", description="Approve GLIM Application:\nMandatory Fields: approvedOnDate\nOptional Fields: approvedLoanAmount and expectedDisbursementDate\nApproves the GLIM application\n\nUndo GLIM Application Approval:\nUndoes the GLIM Application Approval\n\nReject GLIM Application:\nMandatory Fields: rejectedOnDate\nAllows you to reject the GLIM application\n\nDisburse Loan:\nMandatory Fields: actualDisbursementDate\nOptional Fields: transactionAmount and fixedEmiAmount\nDisburses the Loan\n\nDisburse Loan To Savings Account:\nMandatory Fields: actualDisbursementDate\nOptional Fields: transactionAmount and fixedEmiAmount\nDisburses the loan to Saving Account\n\nUndo Loan Disbursal:\nUndoes the Loan Disbursal\n")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PostLoansLoanIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PostLoansLoanIdResponse.class))})})
    public String glimStateTransitions(@PathParam(value="glimId") Long glimId, @QueryParam(value="command") String commandParam, String apiRequestBodyAsJson) {
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandWrapper commandRequest = null;
        if (CommandParameterUtil.is((String)commandParam, (String)"reject")) {
            commandRequest = builder.rejectGLIMApplication(glimId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"approve")) {
            commandRequest = builder.approveGLIMLoanApplication(glimId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"disburse")) {
            commandRequest = builder.disburseGlimLoanApplication(glimId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"glimrepayment")) {
            commandRequest = builder.repaymentGlimLoanApplication(glimId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"undodisbursal")) {
            commandRequest = builder.undoGLIMLoanDisbursal(glimId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"undoapproval")) {
            commandRequest = builder.undoGLIMLoanApproval(glimId).build();
        }
        if (commandRequest == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[0]);
        }
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="repayments/downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getLoanRepaymentTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.LOAN_TRANSACTIONS.toString(), officeId, null, dateFormat);
    }

    @POST
    @Path(value="uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload Loan template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postLoanTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.LOANS.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
        return this.toApiJsonSerializer.serialize((Object)importDocumentId);
    }

    @POST
    @Path(value="repayments/uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload Loan repayments template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postLoanRepaymentTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.LOAN_TRANSACTIONS.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
        return this.toApiJsonSerializer.serialize((Object)importDocumentId);
    }

    @GET
    @Path(value="{loanId}/delinquencytags")
    @Consumes(value={"text/html", "application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve the Loan Delinquency Tag history using the Loan Id", description="")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DelinquencyApiResourceSwagger.GetDelinquencyTagHistoryResponse.class)))})})
    public String getDelinquencyTagHistory(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @Context UriInfo uriInfo) {
        return this.getDelinquencyTagHistory(loanId, null, uriInfo);
    }

    @GET
    @Path(value="external-id/{loanExternalId}/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.GetLoansApprovalTemplateResponse.class))})})
    public String retrieveApprovalTemplate(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @QueryParam(value="templateType") @Parameter(description="templateType") String templateType, @Context UriInfo uriInfo) {
        return this.retrieveApprovalTemplate(null, loanExternalId, templateType, uriInfo);
    }

    @GET
    @Path(value="external-id/{loanExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Loan", description="Note: template=true parameter doesn't apply to this resource.Example Requests:\n\nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854\n\n\nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?fields=id,principal,annualInterestRate\n\n\nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?associations=all\n\nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?associations=all&exclude=guarantors\n\n\nloans/external-id/7dd80a7c-ycba-a446-t378-91eb6f53e854?fields=id,principal,annualInterestRate&associations=repaymentSchedule,transactions")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.GetLoansLoanIdResponse.class))})})
    public String retrieveLoan(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly, @DefaultValue(value="all") @QueryParam(value="associations") @Parameter(in=ParameterIn.QUERY, name="associations", description="Loan object relations to be included in the response", required=false, examples={@ExampleObject(value="all"), @ExampleObject(value="repaymentSchedule,transactions")}) String associations, @QueryParam(value="exclude") @Parameter(in=ParameterIn.QUERY, name="exclude", description="Optional Loan object relation list to be filtered in the response", required=false, example="guarantors,futureSchedule") String exclude, @QueryParam(value="fields") @Parameter(in=ParameterIn.QUERY, name="fields", description="Optional Loan attribute list to be in the response", required=false, example="id,principal,annualInterestRate") String fields, @Context UriInfo uriInfo) {
        return this.retrieveLoan(null, loanExternalId, staffInSelectedOfficeOnly, exclude, uriInfo);
    }

    @PUT
    @Path(value="external-id/{loanExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Modify a loan application", description="Loan application can only be modified when in 'Submitted and pending approval' state. Once the application is approved, the details cannot be changed using this method.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PutLoansLoanIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PutLoansLoanIdResponse.class))})})
    public String modifyLoanApplication(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.modifyLoanApplication(null, loanExternalId, commandParam, apiRequestBodyAsJson);
    }

    @DELETE
    @Path(value="external-id/{loanExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Loan Application", description="Note: Only loans in \"Submitted and awaiting approval\" status can be deleted.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.DeleteLoansLoanIdResponse.class))})})
    public String deleteLoanApplication(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId) {
        return this.deleteLoanApplication(null, loanExternalId);
    }

    @POST
    @Path(value="external-id/{loanExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Approve Loan Application | Recover Loan Guarantee | Undo Loan Application Approval | Assign a Loan Officer | Unassign a Loan Officer | Reject Loan Application | Applicant Withdraws from Loan Application | Disburse Loan Disburse Loan To Savings Account | Undo Loan Disbursal", description="Approve Loan Application:\nMandatory Fields: approvedOnDate\nOptional Fields: approvedLoanAmount and expectedDisbursementDate\nApproves the loan application\n\nRecover Loan Guarantee:\nRecovers the loan guarantee\n\nUndo Loan Application Approval:\nUndoes the Loan Application Approval\n\nAssign a Loan Officer:\nAllows you to assign Loan Officer for existing Loan.\n\nUnassign a Loan Officer:\nAllows you to unassign the Loan Officer.\n\nReject Loan Application:\nMandatory Fields: rejectedOnDate\nAllows you to reject the loan application\n\nApplicant Withdraws from Loan Application:\nMandatory Fields: withdrawnOnDate\nAllows the applicant to withdraw the loan application\n\nDisburse Loan:\nMandatory Fields: actualDisbursementDate\nOptional Fields: transactionAmount and fixedEmiAmount\nDisburses the Loan\n\nDisburse Loan To Savings Account:\nMandatory Fields: actualDisbursementDate\nOptional Fields: transactionAmount and fixedEmiAmount\nDisburses the loan to Saving Account\n\nUndo Loan Disbursal:\nUndoes the Loan Disbursal\nShowing request and response for Assign a Loan Officer")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PostLoansLoanIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PostLoansLoanIdResponse.class))})})
    public String stateTransitions(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.stateTransitions(null, loanExternalId, commandParam, apiRequestBodyAsJson);
    }

    @GET
    @Path(value="external-id/{loanExternalId}/delinquencytags")
    @Consumes(value={"text/html", "application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve the Loan Delinquency Tag history using the Loan Id", description="")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DelinquencyApiResourceSwagger.GetDelinquencyTagHistoryResponse.class)))})})
    public String getDelinquencyTagHistory(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @Context UriInfo uriInfo) {
        return this.getDelinquencyTagHistory(null, loanExternalId, uriInfo);
    }

    @GET
    @Path(value="{loanId}/delinquency-actions")
    @Consumes(value={"text/html", "application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve delinquency actions related to the loan", description="")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DelinquencyApiResourceSwagger.GetDelinquencyActionsResponse.class)))})})
    public String getLoanDelinquencyActions(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @Context UriInfo uriInfo) {
        return this.getLoanDelinquencyActions(loanId, null, uriInfo);
    }

    @GET
    @Path(value="external-id/{loanExternalId}/delinquency-actions")
    @Consumes(value={"text/html", "application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve delinquency actions related to the loan", description="")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DelinquencyApiResourceSwagger.GetDelinquencyActionsResponse.class)))})})
    public String getLoanDelinquencyActions(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @Context UriInfo uriInfo) {
        return this.getLoanDelinquencyActions(null, loanExternalId, uriInfo);
    }

    @POST
    @Path(value="{loanId}/delinquency-actions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Adds a new delinquency action for a loan", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=DelinquencyApiResourceSwagger.PostLoansDelinquencyActionRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=DelinquencyApiResourceSwagger.PostLoansDelinquencyActionResponse.class))})})
    public String createLoanDelinquencyAction(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @Context UriInfo uriInfo, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.createLoanDelinquencyAction(loanId, ExternalId.empty(), apiRequestBodyAsJson);
    }

    @POST
    @Path(value="external-id/{loanExternalId}/delinquency-actions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Adds a new delinquency action for a loan", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=DelinquencyApiResourceSwagger.PostLoansDelinquencyActionRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=DelinquencyApiResourceSwagger.PostLoansDelinquencyActionResponse.class))})})
    public String createLoanDelinquencyAction(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @Context UriInfo uriInfo, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.createLoanDelinquencyAction(null, ExternalIdFactory.produce((String)loanExternalId), apiRequestBodyAsJson);
    }

    @PUT
    @Path(value="{loanId}/approved-amount")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Modifies the approved amount of the loan", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PutLoansApprovedAmountRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PutLoansApprovedAmountResponse.class))})})
    public CommandProcessingResult modifyLoanApprovedAmount(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @Context UriInfo uriInfo, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.modifyLoanApprovedAmount(loanId, ExternalId.empty(), apiRequestBodyAsJson);
    }

    @PUT
    @Path(value="external-id/{loanExternalId}/approved-amount")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Modifies the approved amount of the loan", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PutLoansApprovedAmountRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PutLoansApprovedAmountResponse.class))})})
    public CommandProcessingResult modifyLoanApprovedAmount(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @Context UriInfo uriInfo, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.modifyLoanApprovedAmount(null, ExternalIdFactory.produce((String)loanExternalId), apiRequestBodyAsJson);
    }

    @GET
    @Path(value="{loanId}/approved-amount")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Collects and returns the approved amount modification history for a given loan", description="")
    public List<LoanApprovedAmountHistoryData> getLoanApprovedAmountHistory(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @Context UriInfo uriInfo) {
        return this.getLoanApprovedAmountHistory(loanId, ExternalId.empty());
    }

    @GET
    @Path(value="external-id/{loanExternalId}/approved-amount")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Collects and returns the approved amount modification history for a given loan", description="")
    public List<LoanApprovedAmountHistoryData> getLoanApprovedAmountHistory(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @Context UriInfo uriInfo) {
        return this.getLoanApprovedAmountHistory(null, ExternalIdFactory.produce((String)loanExternalId));
    }

    @PUT
    @Path(value="{loanId}/available-disbursement-amount")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Modifies the available disbursement amount of the loan", description="Modifies the available disbursement amount of the loan, this indirectly modifies the approved amount that can be disbursed on the loan")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PutLoansAvailableDisbursementAmountRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PutLoansAvailableDisbursementAmountResponse.class))})})
    public CommandProcessingResult modifyLoanAvailableDisbursementAmount(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @Context UriInfo uriInfo, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.modifyLoanAvailableDisbursementAmount(loanId, ExternalId.empty(), apiRequestBodyAsJson);
    }

    @PUT
    @Path(value="external-id/{loanExternalId}/available-disbursement-amount")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Modifies the available disbursement amount of the loan", description="Modifies the available disbursement amount of the loan, this indirectly modifies the approved amount that can be disbursed on the loan")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PutLoansAvailableDisbursementAmountRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoansApiResourceSwagger.PutLoansAvailableDisbursementAmountResponse.class))})})
    public CommandProcessingResult modifyLoanAvailableDisbursementAmount(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalId, @Context UriInfo uriInfo, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.modifyLoanAvailableDisbursementAmount(null, ExternalIdFactory.produce((String)loanExternalId), apiRequestBodyAsJson);
    }

    private String retrieveApprovalTemplate(Long loanId, String loanExternalIdStr, String templateType, UriInfo uriInfo) {
        Long resolvedLoanId;
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        LoanApprovalData loanApprovalTemplate = null;
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        Long l = resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        if (templateType == null) {
            String errorMsg = "Loan template type must be provided";
            throw new LoanTemplateTypeRequiredException("Loan template type must be provided");
        }
        if (templateType.equals("approval")) {
            loanApprovalTemplate = this.loanReadPlatformService.retrieveApprovalTemplate(resolvedLoanId);
        }
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.loanApprovalDataToApiJsonSerializer.serialize(settings, (Object)loanApprovalTemplate, LOAN_APPROVAL_DATA_PARAMETERS);
    }

    private String retrieveLoan(Long loanId, String loanExternalIdStr, boolean staffInSelectedOfficeOnly, String exclude, UriInfo uriInfo) {
        CalendarData calendarData;
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        LoanAccountData loanBasicDetails = this.loanReadPlatformService.retrieveOne(resolvedLoanId);
        if (loanBasicDetails.isInterestRecalculationEnabled()) {
            Collection interestRecalculationCalendarDatas = this.calendarReadPlatformService.retrieveCalendarsByEntity(loanBasicDetails.getInterestRecalculationDetailId(), CalendarEntityType.LOAN_RECALCULATION_REST_DETAIL.getValue(), null);
            calendarData = null;
            if (!CollectionUtils.isEmpty((Collection)interestRecalculationCalendarDatas)) {
                calendarData = (CalendarData)interestRecalculationCalendarDatas.iterator().next();
            }
            Collection interestRecalculationCompoundingCalendarDatas = this.calendarReadPlatformService.retrieveCalendarsByEntity(loanBasicDetails.getInterestRecalculationDetailId(), CalendarEntityType.LOAN_RECALCULATION_COMPOUNDING_DETAIL.getValue(), null);
            CalendarData compoundingCalendarData = null;
            if (!CollectionUtils.isEmpty((Collection)interestRecalculationCompoundingCalendarDatas)) {
                compoundingCalendarData = (CalendarData)interestRecalculationCompoundingCalendarDatas.iterator().next();
            }
            loanBasicDetails = loanBasicDetails.withInterestRecalculationCalendarData(calendarData, compoundingCalendarData);
        }
        if (loanBasicDetails.getRepaymentFrequencyType() != null && ((Long)loanBasicDetails.getRepaymentFrequencyType().getId()).intValue() == PeriodFrequencyType.MONTHS.getValue().intValue()) {
            Collection loanCalendarDatas = this.calendarReadPlatformService.retrieveCalendarsByEntity(resolvedLoanId, CalendarEntityType.LOANS.getValue(), null);
            calendarData = null;
            if (!CollectionUtils.isEmpty((Collection)loanCalendarDatas)) {
                calendarData = (CalendarData)loanCalendarDatas.iterator().next();
            }
            if (calendarData != null) {
                loanBasicDetails = loanBasicDetails.setMeeting(calendarData);
            }
        }
        Collection interestRatesPeriods = this.loanReadPlatformService.retrieveLoanInterestRatePeriodData(loanBasicDetails);
        Collection loanRepayments = null;
        LoanScheduleData repaymentSchedule = null;
        Collection charges = null;
        List guarantors = null;
        CalendarData meeting = null;
        List notes = null;
        PortfolioAccountData linkedAccount = null;
        Collection disbursementData = null;
        List emiAmountVariations = null;
        List loanTermVariations = null;
        ArrayList<LoanCollateralManagementData> loanCollateralManagementData = new ArrayList<LoanCollateralManagementData>();
        CollectionData collectionData = null;
        HashSet<String> mandatoryResponseParameters = new HashSet<String>();
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        if (!associationParameters.isEmpty()) {
            if (associationParameters.contains("all")) {
                associationParameters.addAll(Arrays.asList("repaymentSchedule", "futureSchedule", "originalSchedule", "transactions", "charges", "guarantors", "collateral", "notes", "linkedAccount", "multiDisburseDetails", "collection", "loanTermVariations"));
            }
            ApiParameterHelper.excludeAssociationsForResponseIfProvided((String)exclude, (Set)associationParameters);
            if (associationParameters.contains("guarantors")) {
                mandatoryResponseParameters.add("guarantors");
                guarantors = this.guarantorReadPlatformService.retrieveGuarantorsForLoan(resolvedLoanId);
                if (CollectionUtils.isEmpty((Collection)guarantors)) {
                    guarantors = null;
                }
            }
            if (associationParameters.contains("collection")) {
                mandatoryResponseParameters.add("collection");
                collectionData = this.delinquencyReadPlatformService.calculateLoanCollectionData(resolvedLoanId);
            }
            if (associationParameters.contains("transactions")) {
                mandatoryResponseParameters.add("transactions");
                loanRepayments = this.loanReadPlatformService.retrieveLoanTransactions(resolvedLoanId);
            }
            if (associationParameters.contains("multiDisburseDetails") || associationParameters.contains("repaymentSchedule")) {
                mandatoryResponseParameters.add("multiDisburseDetails");
                disbursementData = this.loanReadPlatformService.retrieveLoanDisbursementDetails(resolvedLoanId);
            }
            if (associationParameters.contains("emiAmountVariations") || associationParameters.contains("repaymentSchedule")) {
                mandatoryResponseParameters.add("emiAmountVariations");
                emiAmountVariations = this.loanTermVariationsRepository.findLoanTermVariationsByLoanIdAndTermType(resolvedLoanId.longValue(), LoanTermVariationType.EMI_AMOUNT.getValue().intValue());
            }
            if (associationParameters.contains("loanTermVariations")) {
                mandatoryResponseParameters.add("loanTermVariations");
                loanTermVariations = this.loanTermVariationsRepository.findLoanTermVariationsByLoanId(resolvedLoanId.longValue());
            }
            if (associationParameters.contains("repaymentSchedule")) {
                mandatoryResponseParameters.add("repaymentSchedule");
                List capitalizedIncomeData = this.loanCapitalizedIncomeBalanceRepository.findRepaymentPeriodDataByLoanId(resolvedLoanId);
                RepaymentScheduleRelatedLoanData repaymentScheduleRelatedData = new RepaymentScheduleRelatedLoanData(loanBasicDetails.getTimeline().getExpectedDisbursementDate(), loanBasicDetails.getTimeline().getActualDisbursementDate(), loanBasicDetails.getCurrency(), loanBasicDetails.getPrincipal(), loanBasicDetails.getInArrearsTolerance(), loanBasicDetails.getFeeChargesAtDisbursementCharged());
                repaymentSchedule = this.loanReadPlatformService.retrieveRepaymentSchedule(resolvedLoanId, repaymentScheduleRelatedData, disbursementData, (Collection)capitalizedIncomeData, loanBasicDetails.isInterestRecalculationEnabled(), LoanScheduleType.fromEnumOptionData((EnumOptionData)loanBasicDetails.getLoanScheduleType()));
                if (associationParameters.contains("futureSchedule") && loanBasicDetails.isInterestRecalculationEnabled()) {
                    mandatoryResponseParameters.add("futureSchedule");
                    this.calculationPlatformService.updateFutureSchedule(repaymentSchedule, resolvedLoanId);
                }
                if (associationParameters.contains("originalSchedule") && loanBasicDetails.isInterestRecalculationEnabled() && LoanStatus.fromInt((Integer)loanBasicDetails.getStatus().getId().intValue()).isActive()) {
                    mandatoryResponseParameters.add("originalSchedule");
                    LoanScheduleData loanScheduleData = this.loanScheduleHistoryReadPlatformService.retrieveRepaymentArchiveSchedule(resolvedLoanId, repaymentScheduleRelatedData, disbursementData, LoanScheduleType.fromEnumOptionData((EnumOptionData)loanBasicDetails.getLoanScheduleType()));
                    loanBasicDetails = loanBasicDetails.setOriginalSchedule(loanScheduleData);
                }
            }
            if (associationParameters.contains("charges")) {
                mandatoryResponseParameters.add("charges");
                charges = this.loanChargeReadPlatformService.retrieveLoanCharges(resolvedLoanId);
                if (CollectionUtils.isEmpty((Collection)charges)) {
                    charges = null;
                }
            }
            if (associationParameters.contains("collateral")) {
                mandatoryResponseParameters.add("collateral");
                List loanCollateralManagements = this.loanCollateralManagementReadPlatformService.getLoanCollateralResponseDataList(resolvedLoanId);
                for (LoanCollateralResponseData loanCollateralManagement : loanCollateralManagements) {
                    loanCollateralManagementData.add(loanCollateralManagement.toCommand());
                }
            }
            if (associationParameters.contains("meeting")) {
                mandatoryResponseParameters.add("meeting");
                meeting = this.calendarReadPlatformService.retrieveLoanCalendar(resolvedLoanId);
            }
            if (associationParameters.contains("notes")) {
                mandatoryResponseParameters.add("notes");
                notes = this.noteReadPlatformService.retrieveNotesByResource(resolvedLoanId, NoteType.LOAN.getValue());
                if (CollectionUtils.isEmpty((Collection)notes)) {
                    notes = null;
                }
            }
            if (associationParameters.contains("linkedAccount")) {
                mandatoryResponseParameters.add("linkedAccount");
                linkedAccount = this.accountAssociationsReadPlatformService.retriveLoanLinkedAssociation(resolvedLoanId);
            }
        }
        Collection productOptions = null;
        List loanTermFrequencyTypeOptions = null;
        List repaymentFrequencyTypeOptions = null;
        List repaymentFrequencyNthDayTypeOptions = null;
        List repaymentFrequencyDayOfWeekTypeOptions = null;
        Collection repaymentStrategyOptions = null;
        List interestRateFrequencyTypeOptions = null;
        List amortizationTypeOptions = null;
        List interestTypeOptions = null;
        List interestCalculationPeriodTypeOptions = null;
        List fundOptions = null;
        Collection allowedLoanOfficers = null;
        List chargeOptions = null;
        ChargeData chargeTemplate = null;
        List loanPurposeOptions = null;
        List loanCollateralOptions = null;
        Collection calendarOptions = null;
        Collection accountLinkingOptions = null;
        Collection clientActiveLoanOptions = null;
        boolean template = ApiParameterHelper.template((MultivaluedMap)uriInfo.getQueryParameters());
        if (template) {
            productOptions = this.loanProductReadPlatformService.retrieveAllLoanProductsForLookup();
            LoanProductData product = this.loanProductReadPlatformService.retrieveLoanProduct(loanBasicDetails.getLoanProductId());
            loanBasicDetails.setProduct(product);
            loanTermFrequencyTypeOptions = this.dropdownReadPlatformService.retrieveLoanTermFrequencyTypeOptions();
            repaymentFrequencyTypeOptions = this.dropdownReadPlatformService.retrieveRepaymentFrequencyTypeOptions();
            repaymentFrequencyNthDayTypeOptions = this.dropdownReadPlatformService.retrieveRepaymentFrequencyOptionsForNthDayOfMonth();
            repaymentFrequencyDayOfWeekTypeOptions = this.dropdownReadPlatformService.retrieveRepaymentFrequencyOptionsForDaysOfWeek();
            interestRateFrequencyTypeOptions = this.dropdownReadPlatformService.retrieveInterestRateFrequencyTypeOptions();
            amortizationTypeOptions = this.dropdownReadPlatformService.retrieveLoanAmortizationTypeOptions();
            interestTypeOptions = product.isLinkedToFloatingInterestRates() ? Collections.singletonList(LoanEnumerations.interestType((InterestMethod)InterestMethod.DECLINING_BALANCE)) : this.dropdownReadPlatformService.retrieveLoanInterestTypeOptions();
            interestCalculationPeriodTypeOptions = this.dropdownReadPlatformService.retrieveLoanInterestRateCalculatedInPeriodOptions();
            fundOptions = this.fundReadPlatformService.retrieveAllFunds();
            repaymentStrategyOptions = this.dropdownReadPlatformService.retrieveTransactionProcessingStrategies();
            chargeOptions = product.getMultiDisburseLoan() != false ? this.chargeReadPlatformService.retrieveLoanAccountApplicableCharges(resolvedLoanId, new ChargeTimeType[]{ChargeTimeType.OVERDUE_INSTALLMENT}) : this.chargeReadPlatformService.retrieveLoanAccountApplicableCharges(resolvedLoanId, new ChargeTimeType[]{ChargeTimeType.OVERDUE_INSTALLMENT, ChargeTimeType.TRANCHE_DISBURSEMENT});
            chargeTemplate = this.loanChargeReadPlatformService.retrieveLoanChargeTemplate();
            Long officeId = loanBasicDetails.getClientOfficeId();
            if (officeId == null && loanBasicDetails.getGroup() != null) {
                officeId = loanBasicDetails.getGroup().getOfficeId();
            }
            allowedLoanOfficers = this.loanReadPlatformService.retrieveAllowedLoanOfficers(officeId, staffInSelectedOfficeOnly);
            loanPurposeOptions = this.codeValueReadPlatformService.retrieveCodeValuesByCode("LoanPurpose");
            loanCollateralOptions = this.codeValueReadPlatformService.retrieveCodeValuesByCode("LoanCollateral");
            CurrencyData currencyData = loanBasicDetails.getCurrency();
            String currencyCode = null;
            if (currencyData != null) {
                currencyCode = currencyData.getCode();
            }
            long[] accountStatus = new long[]{SavingsAccountStatusType.ACTIVE.getValue().intValue()};
            PortfolioAccountDTO portfolioAccountDTO = new PortfolioAccountDTO(PortfolioAccountType.SAVINGS.getValue(), loanBasicDetails.getClientId(), currencyCode, accountStatus, DepositAccountType.SAVINGS_DEPOSIT.getValue());
            accountLinkingOptions = this.portfolioAccountReadPlatformService.retrieveAllForLookup(portfolioAccountDTO);
            if (!associationParameters.contains("linkedAccount")) {
                mandatoryResponseParameters.add("linkedAccount");
                linkedAccount = this.accountAssociationsReadPlatformService.retriveLoanLinkedAssociation(resolvedLoanId);
            }
            if (loanBasicDetails.getGroup() != null && loanBasicDetails.getGroup().getId() != null) {
                calendarOptions = this.loanReadPlatformService.retrieveCalendars(loanBasicDetails.getGroup().getId());
            }
            if (loanBasicDetails.getProduct().isCanUseForTopup() && loanBasicDetails.getClientId() != null) {
                clientActiveLoanOptions = this.accountDetailsReadPlatformService.retrieveClientActiveLoanAccountSummary(loanBasicDetails.getClientId());
            }
        }
        List overdueCharges = this.chargeReadPlatformService.retrieveLoanProductCharges(loanBasicDetails.getLoanProductId(), ChargeTimeType.OVERDUE_INSTALLMENT);
        PaidInAdvanceData paidInAdvanceTemplate = this.loanReadPlatformService.retrieveTotalPaidInAdvance(resolvedLoanId);
        boolean isRatesEnabled = this.configurationDomainService.isSubRatesEnabled();
        List rates = null;
        if (isRatesEnabled) {
            rates = this.rateReadService.retrieveLoanRates(resolvedLoanId);
        }
        if (loanBasicDetails.getSummary() != null) {
            LoanSummaryDataProvider loanSummaryDataProvider = this.loanSummaryProviderDelegate.resolveLoanSummaryDataProvider(loanBasicDetails.getTransactionProcessingStrategyCode());
            loanBasicDetails.setSummary(loanSummaryDataProvider.withTransactionAmountsSummary(loanBasicDetails.getId(), loanBasicDetails.getSummary(), repaymentSchedule, this.loanSummaryBalancesRepository.retrieveLoanSummaryBalancesByTransactionType(loanBasicDetails.getId(), LoanApiConstants.LOAN_SUMMARY_TRANSACTION_TYPES)));
        }
        LoanAccountData loanAccount = loanBasicDetails.associationsAndTemplate(repaymentSchedule, loanRepayments, charges, loanCollateralManagementData, (Collection)guarantors, meeting, productOptions, (Collection)loanTermFrequencyTypeOptions, (Collection)repaymentFrequencyTypeOptions, (Collection)repaymentFrequencyNthDayTypeOptions, (Collection)repaymentFrequencyDayOfWeekTypeOptions, repaymentStrategyOptions, (Collection)interestRateFrequencyTypeOptions, (Collection)amortizationTypeOptions, (Collection)interestTypeOptions, (Collection)interestCalculationPeriodTypeOptions, (Collection)fundOptions, (Collection)chargeOptions, chargeTemplate, allowedLoanOfficers, loanPurposeOptions, loanCollateralOptions, calendarOptions, (Collection)notes, accountLinkingOptions, linkedAccount, disbursementData, (Collection)emiAmountVariations, (Collection)overdueCharges, paidInAdvanceTemplate, interestRatesPeriods, clientActiveLoanOptions, rates, Boolean.valueOf(isRatesEnabled), collectionData, LoanScheduleType.getValuesAsEnumOptionDataList(), LoanScheduleProcessingType.getValuesAsEnumOptionDataList(), loanTermVariations, ApiFacingEnum.getValuesAsStringEnumOptionDataList(DaysInYearCustomStrategyType.class), ApiFacingEnum.getValuesAsStringEnumOptionDataList(LoanCapitalizedIncomeCalculationType.class), ApiFacingEnum.getValuesAsStringEnumOptionDataList(LoanCapitalizedIncomeStrategy.class), ApiFacingEnum.getValuesAsStringEnumOptionDataList(LoanCapitalizedIncomeType.class), ApiFacingEnum.getValuesAsStringEnumOptionDataList(LoanBuyDownFeeCalculationType.class), ApiFacingEnum.getValuesAsStringEnumOptionDataList(LoanBuyDownFeeStrategy.class), ApiFacingEnum.getValuesAsStringEnumOptionDataList(LoanBuyDownFeeIncomeType.class));
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters(), mandatoryResponseParameters);
        return this.toApiJsonSerializer.serialize(settings, (Object)loanAccount, LOAN_DATA_PARAMETERS);
    }

    private String modifyLoanApplication(Long loanId, String loanExternalIdStr, String commandParam, String apiRequestBodyAsJson) {
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        CommandWrapper commandRequest = CommandParameterUtil.is((String)commandParam, (String)"markAsFraud") ? builder.markAsFraud(resolvedLoanId).build() : builder.updateLoanApplication(resolvedLoanId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private String deleteLoanApplication(Long loanId, String loanExternalIdStr) {
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteLoanApplication(resolvedLoanId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private String stateTransitions(Long loanId, String loanExternalIdStr, String commandParam, String apiRequestBodyAsJson) {
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandWrapper commandRequest = null;
        if (CommandParameterUtil.is((String)commandParam, (String)"reject")) {
            commandRequest = builder.rejectLoanApplication(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"withdrawnByApplicant")) {
            commandRequest = builder.withdrawLoanApplication(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"approve")) {
            commandRequest = builder.approveLoanApplication(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"disburse")) {
            commandRequest = builder.disburseLoanApplication(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"disburseToSavings")) {
            commandRequest = builder.disburseLoanToSavingsApplication(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"disburseWithoutAutoDownPayment")) {
            commandRequest = builder.disburseWithoutAutoDownPayment(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"undoapproval")) {
            commandRequest = builder.undoLoanApplicationApproval(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"undodisbursal")) {
            commandRequest = builder.undoLoanApplicationDisbursal(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"undolastdisbursal")) {
            commandRequest = builder.undoLastDisbursalLoanApplication(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"assignloanofficer")) {
            commandRequest = builder.assignLoanOfficer(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"unassignloanofficer")) {
            commandRequest = builder.unassignLoanOfficer(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"recoverGuarantees")) {
            commandRequest = new CommandWrapperBuilder().recoverFromGuarantor(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"assigndelinquency")) {
            commandRequest = builder.assignDelinquency(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"contractTermination")) {
            commandRequest = builder.applyContractTermination(resolvedLoanId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"undoContractTermination")) {
            commandRequest = builder.undoContractTermination(resolvedLoanId).build();
        }
        if (commandRequest == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[0]);
        }
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private String getDelinquencyTagHistory(Long loanId, String loanExternalIdStr, UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("DELINQUENCY_TAGS");
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        Collection loanDelinquencyTagHistoryData = this.delinquencyReadPlatformService.retrieveDelinquencyRangeHistory(resolvedLoanId);
        return this.jsonSerializerTagHistory.serialize((Object)loanDelinquencyTagHistoryData);
    }

    private String getLoanDelinquencyActions(Long loanId, String loanExternalIdStr, UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        List delinquencyActions = this.delinquencyReadPlatformService.retrieveLoanDelinquencyActions(resolvedLoanId);
        List<LoanDelinquencyActionData> result = delinquencyActions.stream().map(LoanDelinquencyActionData::new).toList();
        return this.jsonSerializerTagHistory.serialize(result);
    }

    private String createLoanDelinquencyAction(Long loanId, ExternalId loanExternalId, String apiRequestBodyAsJson) {
        this.context.authenticatedUser().validateHasCreatePermission(RESOURCE_NAME_FOR_DELINQUENCY_ACTION_PERMISSIONS);
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        CommandWrapperBuilder builder = new CommandWrapperBuilder().createDelinquencyAction(resolvedLoanId);
        builder.withJson(apiRequestBodyAsJson);
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(builder.build());
        return this.delinquencyActionSerializer.serialize((Object)result);
    }

    private CommandProcessingResult modifyLoanApprovedAmount(Long loanId, ExternalId loanExternalId, String apiRequestBodyAsJson) {
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandWrapper commandRequest = builder.updateLoanApprovedAmount(resolvedLoanId).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    private List<LoanApprovedAmountHistoryData> getLoanApprovedAmountHistory(Long loanId, ExternalId loanExternalId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        Pageable sortedByCreationDate = Pageable.unpaged((Sort)Sort.by((String[])new String[]{"createdDate"}).ascending());
        return this.loanApprovedAmountHistoryRepository.findAllByLoanId(resolvedLoanId, sortedByCreationDate);
    }

    private CommandProcessingResult modifyLoanAvailableDisbursementAmount(Long loanId, ExternalId loanExternalId, String apiRequestBodyAsJson) {
        Long resolvedLoanId = loanId == null ? this.loanReadPlatformService.getResolvedLoanId(loanExternalId) : loanId;
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandWrapper commandRequest = builder.updateLoanAvailableDisbursementAmount(resolvedLoanId).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @Generated
    public LoansApiResource(PlatformSecurityContext context, LoanReadPlatformService loanReadPlatformService, LoanProductReadPlatformService loanProductReadPlatformService, LoanDropdownReadPlatformService dropdownReadPlatformService, FundReadPlatformService fundReadPlatformService, ChargeReadPlatformService chargeReadPlatformService, LoanChargeReadPlatformService loanChargeReadPlatformService, LoanScheduleCalculationPlatformService calculationPlatformService, GuarantorReadPlatformService guarantorReadPlatformService, CodeValueReadPlatformService codeValueReadPlatformService, GroupReadPlatformService groupReadPlatformService, DefaultToApiJsonSerializer<LoanAccountData> toApiJsonSerializer, DefaultToApiJsonSerializer<LoanApprovalData> loanApprovalDataToApiJsonSerializer, DefaultToApiJsonSerializer<LoanScheduleData> loanScheduleToApiJsonSerializer, DefaultToApiJsonSerializer<LoanDelinquencyActionData> delinquencyActionSerializer, ApiRequestParameterHelper apiRequestParameterHelper, FromJsonHelper fromJsonHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, CalendarReadPlatformService calendarReadPlatformService, NoteReadPlatformService noteReadPlatformService, PortfolioAccountReadPlatformService portfolioAccountReadPlatformService, AccountAssociationsReadPlatformService accountAssociationsReadPlatformService, LoanScheduleHistoryReadPlatformService loanScheduleHistoryReadPlatformService, AccountDetailsReadPlatformService accountDetailsReadPlatformService, EntityDatatableChecksReadService entityDatatableChecksReadService, BulkImportWorkbookService bulkImportWorkbookService, BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService, RateReadService rateReadService, ConfigurationDomainService configurationDomainService, DefaultToApiJsonSerializer<GlimRepaymentTemplate> glimTemplateToApiJsonSerializer, GLIMAccountInfoReadPlatformService glimAccountInfoReadPlatformService, LoanCollateralManagementReadPlatformService loanCollateralManagementReadPlatformService, DefaultToApiJsonSerializer<LoanDelinquencyTagHistoryData> jsonSerializerTagHistory, DelinquencyReadPlatformService delinquencyReadPlatformService, SqlValidator sqlValidator, LoanSummaryBalancesRepository loanSummaryBalancesRepository, ClientReadPlatformService clientReadPlatformService, LoanTermVariationsRepository loanTermVariationsRepository, LoanSummaryProviderDelegate loanSummaryProviderDelegate, LoanCapitalizedIncomeBalanceRepository loanCapitalizedIncomeBalanceRepository, LoanApprovedAmountHistoryRepository loanApprovedAmountHistoryRepository) {
        this.context = context;
        this.loanReadPlatformService = loanReadPlatformService;
        this.loanProductReadPlatformService = loanProductReadPlatformService;
        this.dropdownReadPlatformService = dropdownReadPlatformService;
        this.fundReadPlatformService = fundReadPlatformService;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.loanChargeReadPlatformService = loanChargeReadPlatformService;
        this.calculationPlatformService = calculationPlatformService;
        this.guarantorReadPlatformService = guarantorReadPlatformService;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
        this.groupReadPlatformService = groupReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.loanApprovalDataToApiJsonSerializer = loanApprovalDataToApiJsonSerializer;
        this.loanScheduleToApiJsonSerializer = loanScheduleToApiJsonSerializer;
        this.delinquencyActionSerializer = delinquencyActionSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.fromJsonHelper = fromJsonHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.calendarReadPlatformService = calendarReadPlatformService;
        this.noteReadPlatformService = noteReadPlatformService;
        this.portfolioAccountReadPlatformService = portfolioAccountReadPlatformService;
        this.accountAssociationsReadPlatformService = accountAssociationsReadPlatformService;
        this.loanScheduleHistoryReadPlatformService = loanScheduleHistoryReadPlatformService;
        this.accountDetailsReadPlatformService = accountDetailsReadPlatformService;
        this.entityDatatableChecksReadService = entityDatatableChecksReadService;
        this.bulkImportWorkbookService = bulkImportWorkbookService;
        this.bulkImportWorkbookPopulatorService = bulkImportWorkbookPopulatorService;
        this.rateReadService = rateReadService;
        this.configurationDomainService = configurationDomainService;
        this.glimTemplateToApiJsonSerializer = glimTemplateToApiJsonSerializer;
        this.glimAccountInfoReadPlatformService = glimAccountInfoReadPlatformService;
        this.loanCollateralManagementReadPlatformService = loanCollateralManagementReadPlatformService;
        this.jsonSerializerTagHistory = jsonSerializerTagHistory;
        this.delinquencyReadPlatformService = delinquencyReadPlatformService;
        this.sqlValidator = sqlValidator;
        this.loanSummaryBalancesRepository = loanSummaryBalancesRepository;
        this.clientReadPlatformService = clientReadPlatformService;
        this.loanTermVariationsRepository = loanTermVariationsRepository;
        this.loanSummaryProviderDelegate = loanSummaryProviderDelegate;
        this.loanCapitalizedIncomeBalanceRepository = loanCapitalizedIncomeBalanceRepository;
        this.loanApprovedAmountHistoryRepository = loanApprovedAmountHistoryRepository;
    }
}

