/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;

public abstract class Event {
    private final UUID id;
    private final Map<String, Object> attributes;
    private Long sourceTimestamp;

    public Event() {
        this(UUID.randomUUID(), new HashMap<String, Object>());
    }

    @JsonCreator
    public Event(UUID id, Map<String, Object> attributes) {
        this.id = id;
        this.attributes = attributes;
    }

    public UUID getId() {
        return this.id;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Object getAttr(String name) {
        return this.attributes.get(name);
    }

    public void setAttr(String name, Object value) {
        this.attributes.put(name, value);
    }

    public boolean hasSourceTimestamp() {
        return this.sourceTimestamp != null;
    }

    public Long getSourceTimestamp() {
        return this.sourceTimestamp;
    }

    public void setSourceTimestamp(long timestamp) {
        this.sourceTimestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event other = (Event)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.attributes, other.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.attributes);
    }
}

