/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.AbstractFileStore;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.operation.AppendFileStoreWrite;
import org.apache.paimon.operation.AppendOnlyFileStoreScan;
import org.apache.paimon.operation.BaseAppendFileStoreWrite;
import org.apache.paimon.operation.BucketSelectConverter;
import org.apache.paimon.operation.BucketedAppendFileStoreWrite;
import org.apache.paimon.operation.RawFileSplitRead;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.types.RowType;

public class AppendOnlyFileStore
extends AbstractFileStore<InternalRow> {
    private final RowType bucketKeyType;
    private final RowType rowType;

    public AppendOnlyFileStore(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, CoreOptions options, RowType partitionType, RowType bucketKeyType, RowType rowType, String tableName, CatalogEnvironment catalogEnvironment) {
        super(fileIO, schemaManager, schema, tableName, options, partitionType, catalogEnvironment);
        this.bucketKeyType = bucketKeyType;
        this.rowType = rowType;
    }

    @Override
    public BucketMode bucketMode() {
        return this.options.bucket() == -1 ? BucketMode.BUCKET_UNAWARE : BucketMode.HASH_FIXED;
    }

    @Override
    public AppendOnlyFileStoreScan newScan() {
        return this.newScan(AbstractFileStore.ScanType.FOR_READ);
    }

    public RawFileSplitRead newRead() {
        return new RawFileSplitRead(this.fileIO, this.schemaManager, this.schema, this.rowType, FileFormatDiscover.of(this.options), this.pathFactory(), this.options.fileIndexReadEnabled());
    }

    public BaseAppendFileStoreWrite newWrite(String commitUser) {
        return this.newWrite(commitUser, null, null);
    }

    public BaseAppendFileStoreWrite newWrite(String commitUser, @Nullable ManifestCacheFilter manifestFilter, @Nullable Integer writeId) {
        DeletionVectorsMaintainer.Factory dvMaintainerFactory;
        DeletionVectorsMaintainer.Factory factory = dvMaintainerFactory = this.options.deletionVectorsEnabled() ? DeletionVectorsMaintainer.factory(this.newIndexFileHandler()) : null;
        if (this.bucketMode() == BucketMode.BUCKET_UNAWARE) {
            return new AppendFileStoreWrite(this.fileIO, this.newRead(), this.schema.id(), this.rowType, this.partitionType, this.pathFactory(), this.snapshotManager(), this.newScan(AbstractFileStore.ScanType.FOR_WRITE).withManifestCacheFilter(manifestFilter), this.options, dvMaintainerFactory, this.tableName);
        }
        return new BucketedAppendFileStoreWrite(this.fileIO, this.newRead(), this.schema.id(), commitUser, this.rowType, this.partitionType, this.pathFactory(), this.snapshotManager(), this.newScan(AbstractFileStore.ScanType.FOR_WRITE).withManifestCacheFilter(manifestFilter), this.options, dvMaintainerFactory, this.tableName);
    }

    @Override
    protected AppendOnlyFileStoreScan newScan(AbstractFileStore.ScanType scanType) {
        BucketSelectConverter bucketSelectConverter = predicate -> {
            if (this.bucketMode() != BucketMode.HASH_FIXED) {
                return Optional.empty();
            }
            if (this.bucketKeyType.getFieldCount() == 0) {
                return Optional.empty();
            }
            List bucketFilters = PredicateBuilder.pickTransformFieldMapping((List)PredicateBuilder.splitAnd((Predicate)predicate), (List)this.rowType.getFieldNames(), (List)this.bucketKeyType.getFieldNames());
            if (!bucketFilters.isEmpty()) {
                return BucketSelectConverter.create(PredicateBuilder.and((List)bucketFilters), this.bucketKeyType);
            }
            return Optional.empty();
        };
        return new AppendOnlyFileStoreScan(this.newManifestsReader(scanType == AbstractFileStore.ScanType.FOR_WRITE), bucketSelectConverter, this.snapshotManager(), this.schemaManager, this.schema, this.manifestFileFactory(scanType == AbstractFileStore.ScanType.FOR_WRITE), this.options.scanManifestParallelism(), this.options.fileIndexReadEnabled());
    }

    @Override
    public Comparator<InternalRow> newKeyComparator() {
        return null;
    }
}

