/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class NestedSchemaUtils {
    public static void generateNestedColumnUpdates(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        if (oldType.getTypeRoot() == DataTypeRoot.ROW) {
            NestedSchemaUtils.handleRowTypeUpdate(fieldNames, oldType, newType, schemaChanges);
        } else if (oldType.getTypeRoot() == DataTypeRoot.ARRAY) {
            NestedSchemaUtils.handleArrayTypeUpdate(fieldNames, oldType, newType, schemaChanges);
        } else if (oldType.getTypeRoot() == DataTypeRoot.MAP) {
            NestedSchemaUtils.handleMapTypeUpdate(fieldNames, oldType, newType, schemaChanges);
        } else if (oldType.getTypeRoot() == DataTypeRoot.MULTISET) {
            NestedSchemaUtils.handleMultisetTypeUpdate(fieldNames, oldType, newType, schemaChanges);
        } else {
            NestedSchemaUtils.handlePrimitiveTypeUpdate(fieldNames, oldType, newType, schemaChanges);
        }
        NestedSchemaUtils.handleNullabilityChange(fieldNames, oldType, newType, schemaChanges);
    }

    private static void handleRowTypeUpdate(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        String joinedNames = String.join((CharSequence)".", fieldNames);
        Preconditions.checkArgument((newType.getTypeRoot() == DataTypeRoot.ROW ? 1 : 0) != 0, (String)"Column %s can only be updated to row type, and cannot be updated to %s type", (Object[])new Object[]{joinedNames, newType.getTypeRoot()});
        RowType oldRowType = (RowType)oldType;
        RowType newRowType = (RowType)newType;
        HashMap<String, Integer> oldFieldOrders = new HashMap<String, Integer>();
        for (int i = 0; i < oldRowType.getFieldCount(); ++i) {
            oldFieldOrders.put(((DataField)oldRowType.getFields().get(i)).name(), i);
        }
        int lastIdx = -1;
        String lastFieldName = "";
        for (Object newField : newRowType.getFields()) {
            String name = newField.name();
            if (!oldFieldOrders.containsKey(name)) continue;
            int idx = (Integer)oldFieldOrders.get(name);
            Preconditions.checkState((lastIdx < idx ? 1 : 0) != 0, (String)"Order of existing fields in column %s must be kept the same. However, field %s and %s have changed their orders.", (Object[])new Object[]{joinedNames, lastFieldName, name});
            lastIdx = idx;
            lastFieldName = name;
        }
        HashSet newFieldNames = new HashSet(newRowType.getFieldNames());
        for (String name : oldRowType.getFieldNames()) {
            if (newFieldNames.contains(name)) continue;
            ArrayList<String> dropColumnNames = new ArrayList<String>(fieldNames);
            dropColumnNames.add(name);
            schemaChanges.add(SchemaChange.dropColumn((String[])dropColumnNames.toArray(new String[0])));
        }
        for (int i = 0; i < newRowType.getFieldCount(); ++i) {
            DataField field = (DataField)newRowType.getFields().get(i);
            String name = field.name();
            ArrayList<String> fullFieldNames = new ArrayList<String>(fieldNames);
            fullFieldNames.add(name);
            if (!oldFieldOrders.containsKey(name)) {
                SchemaChange.Move move;
                if (i == 0) {
                    move = SchemaChange.Move.first((String)name);
                } else {
                    String lastName = ((DataField)newRowType.getFields().get(i - 1)).name();
                    move = SchemaChange.Move.after((String)name, (String)lastName);
                }
                schemaChanges.add(SchemaChange.addColumn((String[])fullFieldNames.toArray(new String[0]), (DataType)field.type(), (String)field.description(), (SchemaChange.Move)move));
                continue;
            }
            DataField oldField = (DataField)oldRowType.getFields().get((Integer)oldFieldOrders.get(name));
            if (!Objects.equals(oldField.description(), field.description())) {
                schemaChanges.add(SchemaChange.updateColumnComment((String[])fullFieldNames.toArray(new String[0]), (String)field.description()));
            }
            NestedSchemaUtils.generateNestedColumnUpdates(fullFieldNames, oldField.type(), field.type(), schemaChanges);
        }
    }

    private static void handleArrayTypeUpdate(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        String joinedNames = String.join((CharSequence)".", fieldNames);
        Preconditions.checkArgument((newType.getTypeRoot() == DataTypeRoot.ARRAY ? 1 : 0) != 0, (String)"Column %s can only be updated to array type, and cannot be updated to %s type", (Object[])new Object[]{joinedNames, newType});
        ArrayList<String> fullFieldNames = new ArrayList<String>(fieldNames);
        fullFieldNames.add("element");
        NestedSchemaUtils.generateNestedColumnUpdates(fullFieldNames, ((ArrayType)oldType).getElementType(), ((ArrayType)newType).getElementType(), schemaChanges);
    }

    private static void handleMapTypeUpdate(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        String joinedNames = String.join((CharSequence)".", fieldNames);
        Preconditions.checkArgument((newType.getTypeRoot() == DataTypeRoot.MAP ? 1 : 0) != 0, (String)"Column %s can only be updated to map type, and cannot be updated to %s type", (Object[])new Object[]{joinedNames, newType});
        MapType oldMapType = (MapType)oldType;
        MapType newMapType = (MapType)newType;
        Preconditions.checkArgument((boolean)oldMapType.getKeyType().equals((Object)newMapType.getKeyType()), (String)"Cannot update key type of column %s from %s type to %s type", (Object[])new Object[]{joinedNames, oldMapType.getKeyType(), newMapType.getKeyType()});
        ArrayList<String> fullFieldNames = new ArrayList<String>(fieldNames);
        fullFieldNames.add("value");
        NestedSchemaUtils.generateNestedColumnUpdates(fullFieldNames, oldMapType.getValueType(), newMapType.getValueType(), schemaChanges);
    }

    private static void handleMultisetTypeUpdate(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        String joinedNames = String.join((CharSequence)".", fieldNames);
        Preconditions.checkArgument((newType.getTypeRoot() == DataTypeRoot.MULTISET ? 1 : 0) != 0, (String)"Column %s can only be updated to multiset type, and cannot be updated to %s type", (Object[])new Object[]{joinedNames, newType});
        ArrayList<String> fullFieldNames = new ArrayList<String>(fieldNames);
        fullFieldNames.add("element");
        NestedSchemaUtils.generateNestedColumnUpdates(fullFieldNames, ((MultisetType)oldType).getElementType(), ((MultisetType)newType).getElementType(), schemaChanges);
    }

    private static void handlePrimitiveTypeUpdate(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        if (!oldType.equalsIgnoreNullable(newType)) {
            schemaChanges.add(SchemaChange.updateColumnType((String[])fieldNames.toArray(new String[0]), (DataType)newType, (boolean)false));
        }
    }

    private static void handleNullabilityChange(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        if (oldType.isNullable() != newType.isNullable()) {
            schemaChanges.add(SchemaChange.updateColumnNullability((String[])fieldNames.toArray(new String[0]), (boolean)newType.isNullable()));
        }
    }
}

