/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.sort;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.paimon.disk.FileIOChannel;

public class SpillChannelManager {
    private final HashSet<FileIOChannel.ID> channels = new HashSet(64);
    private final HashSet<FileIOChannel> openChannels = new HashSet(64);

    public synchronized void addChannel(FileIOChannel.ID id) {
        this.channels.add(id);
    }

    public synchronized void addOpenChannels(List<FileIOChannel> toOpen) {
        for (FileIOChannel channel : toOpen) {
            this.openChannels.add(channel);
            this.channels.remove(channel.getChannelID());
        }
    }

    public synchronized void removeChannel(FileIOChannel.ID id) {
        this.channels.remove(id);
    }

    public synchronized void reset() {
        Object channel;
        Iterator<Object> channels = this.openChannels.iterator();
        while (channels.hasNext()) {
            channel = channels.next();
            channels.remove();
            try {
                channel.closeAndDelete();
            }
            catch (Throwable throwable) {}
        }
        channels = this.channels.iterator();
        while (channels.hasNext()) {
            channel = (FileIOChannel.ID)channels.next();
            channels.remove();
            try {
                File f = new File(((FileIOChannel.ID)channel).getPath());
                if (!f.exists()) continue;
                f.delete();
            }
            catch (Throwable throwable) {}
        }
    }
}

