/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.utils.SemaphoredDelegatingExecutor;
import org.apache.paimon.utils.ThreadPoolUtils;

public class ManifestReadThreadPool {
    private static final String THREAD_NAME = "MANIFEST-READ-THREAD-POOL";
    private static ThreadPoolExecutor executorService = ThreadPoolUtils.createCachedThreadPool((int)Runtime.getRuntime().availableProcessors(), (String)"MANIFEST-READ-THREAD-POOL");

    public static synchronized ExecutorService getExecutorService(@Nullable Integer threadNum) {
        if (threadNum == null || threadNum.intValue() == executorService.getMaximumPoolSize()) {
            return executorService;
        }
        if (threadNum < executorService.getMaximumPoolSize()) {
            return new SemaphoredDelegatingExecutor((ExecutorService)executorService, threadNum.intValue(), false);
        }
        executorService = ThreadPoolUtils.createCachedThreadPool((int)threadNum, (String)THREAD_NAME);
        return executorService;
    }

    public static <T, U> Iterable<T> sequentialBatchedExecute(Function<U, List<T>> processor, List<U> input, @Nullable Integer threadNum) {
        ExecutorService executor = ManifestReadThreadPool.getExecutorService(threadNum);
        if (threadNum == null) {
            threadNum = executor instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)executor).getMaximumPoolSize() : ((SemaphoredDelegatingExecutor)executor).getPermitCount();
        }
        return ThreadPoolUtils.sequentialBatchedExecute((ExecutorService)executor, processor, input, (int)threadNum);
    }

    public static <T, U> Iterator<T> randomlyExecuteSequentialReturn(Function<U, List<T>> processor, List<U> input, @Nullable Integer threadNum) {
        ExecutorService executor = ManifestReadThreadPool.getExecutorService(threadNum);
        return ThreadPoolUtils.randomlyExecuteSequentialReturn((ExecutorService)executor, processor, input);
    }
}

